/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.molding;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.recipe.ItemOutput;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.recipe.molding.MoldingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MoldingRecipeBuilder
extends AbstractRecipeBuilder<MoldingRecipeBuilder> {
    private final ItemOutput output;
    private final MoldingRecipe.Serializer<?> serializer;
    private Ingredient material = Ingredient.field_193370_a;
    private Ingredient pattern = Ingredient.field_193370_a;
    private boolean patternConsumed = false;

    public static MoldingRecipeBuilder moldingTable(IItemProvider item) {
        return MoldingRecipeBuilder.molding(ItemOutput.fromItem((IItemProvider)item), (MoldingRecipe.Serializer)TinkerSmeltery.moldingTableSerializer.get());
    }

    public static MoldingRecipeBuilder moldingBasin(IItemProvider item) {
        return MoldingRecipeBuilder.molding(ItemOutput.fromItem((IItemProvider)item), (MoldingRecipe.Serializer)TinkerSmeltery.moldingBasinSerializer.get());
    }

    public MoldingRecipeBuilder setMaterial(Ingredient ingredient) {
        this.material = ingredient;
        return this;
    }

    public MoldingRecipeBuilder setMaterial(IItemProvider item) {
        return this.setMaterial(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}));
    }

    public MoldingRecipeBuilder setMaterial(ITag<Item> tag) {
        return this.setMaterial(Ingredient.func_199805_a(tag));
    }

    public MoldingRecipeBuilder setPattern(Ingredient ingredient, boolean consumed) {
        this.pattern = ingredient;
        this.patternConsumed = consumed;
        return this;
    }

    public MoldingRecipeBuilder setPattern(IItemProvider item, boolean consumed) {
        return this.setPattern(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}), consumed);
    }

    public MoldingRecipeBuilder setPattern(ITag<Item> tag, boolean consumed) {
        return this.setPattern(Ingredient.func_199805_a(tag), consumed);
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, Objects.requireNonNull(this.output.get().func_77973_b().getRegistryName()));
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        if (this.material == Ingredient.field_193370_a) {
            throw new IllegalStateException("Missing material for molding recipe");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "molding");
        consumer.accept((IFinishedRecipe)new FinishedRecipe(id, advancementId));
    }

    private MoldingRecipeBuilder(ItemOutput output, MoldingRecipe.Serializer<?> serializer) {
        this.output = output;
        this.serializer = serializer;
    }

    public static MoldingRecipeBuilder molding(ItemOutput output, MoldingRecipe.Serializer<?> serializer) {
        return new MoldingRecipeBuilder(output, serializer);
    }

    private class FinishedRecipe
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public FinishedRecipe(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)MoldingRecipeBuilder.this, ID, advancementID);
        }

        public void func_218610_a(JsonObject json) {
            json.add("material", MoldingRecipeBuilder.this.material.func_200304_c());
            if (MoldingRecipeBuilder.this.pattern != Ingredient.field_193370_a) {
                json.add("pattern", MoldingRecipeBuilder.this.pattern.func_200304_c());
                if (MoldingRecipeBuilder.this.patternConsumed) {
                    json.addProperty("pattern_consumed", Boolean.valueOf(true));
                }
            }
            json.add("result", MoldingRecipeBuilder.this.output.serialize());
        }

        public IRecipeSerializer<?> func_218609_c() {
            return MoldingRecipeBuilder.this.serializer;
        }
    }
}

