/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.spilling.effects;

import com.google.gson.JsonObject;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffect;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffectLoader;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;

public class RestoreHungerSpillingEffect
implements ISpillingEffect {
    public static final Loader LOADER = new Loader();
    private final int hunger;
    private final float saturation;

    @Override
    public void applyEffects(FluidStack fluid, float scale, ToolAttackContext context) {
        PlayerEntity player;
        LivingEntity target = context.getLivingTarget();
        if (target instanceof PlayerEntity && (player = (PlayerEntity)target).func_71043_e(false)) {
            player.func_71024_bL().func_75122_a((int)((float)this.hunger * scale), this.saturation * scale);
        }
    }

    @Override
    public ISpillingEffectLoader<?> getLoader() {
        return LOADER;
    }

    public RestoreHungerSpillingEffect(int hunger, float saturation) {
        this.hunger = hunger;
        this.saturation = saturation;
    }

    private static class Loader
    implements ISpillingEffectLoader<RestoreHungerSpillingEffect> {
        private Loader() {
        }

        @Override
        public RestoreHungerSpillingEffect deserialize(JsonObject json) {
            int hunger = JSONUtils.func_151203_m((JsonObject)json, (String)"hunger");
            float saturation = JSONUtils.func_151217_k((JsonObject)json, (String)"saturation");
            return new RestoreHungerSpillingEffect(hunger, saturation);
        }

        @Override
        public void serialize(RestoreHungerSpillingEffect effect, JsonObject json) {
            json.addProperty("hunger", (Number)effect.hunger);
            json.addProperty("saturation", (Number)Float.valueOf(effect.saturation));
        }

        @Override
        public RestoreHungerSpillingEffect read(PacketBuffer buffer) {
            int hunger = buffer.func_150792_a();
            float saturation = buffer.readFloat();
            return new RestoreHungerSpillingEffect(hunger, saturation);
        }

        @Override
        public void write(RestoreHungerSpillingEffect effect, PacketBuffer buffer) {
            buffer.func_150787_b(effect.hunger);
            buffer.writeFloat(effect.saturation);
        }
    }
}

