/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.severing;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.recipe.EntityIngredient;
import slimeknights.mantle.recipe.ItemOutput;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class SeveringRecipeBuilder
extends AbstractRecipeBuilder<SeveringRecipeBuilder> {
    private final EntityIngredient ingredient;
    private final ItemOutput output;
    private boolean isAgeable = false;
    private ItemOutput childOutput = null;

    public static SeveringRecipeBuilder severing(EntityIngredient ingredient, IItemProvider output) {
        return SeveringRecipeBuilder.severing(ingredient, ItemOutput.fromItem((IItemProvider)output));
    }

    public SeveringRecipeBuilder setChildOutput(@Nullable ItemOutput childOutput) {
        this.isAgeable = true;
        this.childOutput = childOutput;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, Objects.requireNonNull(this.output.get().func_77973_b().getRegistryName()));
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "severing");
        consumer.accept((IFinishedRecipe)new FinishedRecipe(id, advancementId));
    }

    private SeveringRecipeBuilder(EntityIngredient ingredient, ItemOutput output) {
        this.ingredient = ingredient;
        this.output = output;
    }

    public static SeveringRecipeBuilder severing(EntityIngredient ingredient, ItemOutput output) {
        return new SeveringRecipeBuilder(ingredient, output);
    }

    private class FinishedRecipe
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public FinishedRecipe(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)SeveringRecipeBuilder.this, ID, advancementID);
        }

        public void func_218610_a(JsonObject json) {
            json.add("entity", SeveringRecipeBuilder.this.ingredient.serialize());
            if (SeveringRecipeBuilder.this.isAgeable) {
                json.add("adult_result", SeveringRecipeBuilder.this.output.serialize());
                if (SeveringRecipeBuilder.this.childOutput != null) {
                    json.add("child_result", SeveringRecipeBuilder.this.childOutput.serialize());
                }
            } else {
                json.add("result", SeveringRecipeBuilder.this.output.serialize());
            }
        }

        public IRecipeSerializer<?> func_218609_c() {
            return SeveringRecipeBuilder.this.isAgeable ? (IRecipeSerializer)TinkerModifiers.ageableSeveringSerializer.get() : (IRecipeSerializer)TinkerModifiers.severingSerializer.get();
        }
    }
}

