/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.recipe.ItemOutput;
import slimeknights.mantle.recipe.SizedIngredient;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.RandomItem;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipeBuilder;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierRecipeBuilder
extends AbstractModifierRecipeBuilder<ModifierRecipeBuilder> {
    private final List<SizedIngredient> inputs = new ArrayList<SizedIngredient>();
    private final List<RandomItem> salvage = new ArrayList<RandomItem>();

    protected ModifierRecipeBuilder(ModifierEntry result) {
        super(result);
    }

    public static ModifierRecipeBuilder modifier(ModifierEntry modifier) {
        return new ModifierRecipeBuilder(modifier);
    }

    public static ModifierRecipeBuilder modifier(Modifier modifier) {
        return ModifierRecipeBuilder.modifier(new ModifierEntry(modifier, 1));
    }

    public ModifierRecipeBuilder addInput(SizedIngredient ingredient) {
        this.inputs.add(ingredient);
        return this;
    }

    public ModifierRecipeBuilder addInput(Ingredient ingredient) {
        return this.addInput(SizedIngredient.of((Ingredient)ingredient));
    }

    public ModifierRecipeBuilder addInput(IItemProvider item, int amount) {
        return this.addInput(SizedIngredient.fromItems((int)amount, (IItemProvider[])new IItemProvider[]{item}));
    }

    public ModifierRecipeBuilder addInput(IItemProvider item) {
        return this.addInput(item, 1);
    }

    public ModifierRecipeBuilder addInput(ITag<Item> tag, int amount) {
        return this.addInput(SizedIngredient.fromTag(tag, (int)amount));
    }

    public ModifierRecipeBuilder addInput(ITag<Item> tag) {
        return this.addInput(tag, 1);
    }

    public ModifierRecipeBuilder addSalvage(RandomItem item) {
        this.salvage.add(item);
        return this;
    }

    public ModifierRecipeBuilder addSalvage(IItemProvider item, float chance) {
        return this.addSalvage(RandomItem.chance(ItemOutput.fromItem((IItemProvider)item), chance));
    }

    public ModifierRecipeBuilder addSalvage(IItemProvider item, int minAmount, int maxAmount) {
        return this.addSalvage(RandomItem.range(ItemOutput.fromStack((ItemStack)new ItemStack(item, maxAmount)), minAmount));
    }

    public ModifierRecipeBuilder addSalvage(IItemProvider item, int maxAmount) {
        return this.addSalvage(item, 0, maxAmount);
    }

    public ModifierRecipeBuilder addSalvage(ITag<Item> tag, int minAmount, int maxAmount) {
        return this.addSalvage(RandomItem.range(ItemOutput.fromTag(tag, (int)maxAmount), minAmount));
    }

    public ModifierRecipeBuilder addInputSalvage(IItemProvider item, int minAmount, int maxAmount) {
        this.addInput(item, maxAmount);
        this.addSalvage(item, minAmount, maxAmount);
        return this;
    }

    public ModifierRecipeBuilder addInputSalvage(IItemProvider item, int amount) {
        return this.addInputSalvage(item, 0, amount);
    }

    public ModifierRecipeBuilder addInputSalvage(IItemProvider item, float salvageChance) {
        this.addInput(item);
        this.addSalvage(item, salvageChance);
        return this;
    }

    public ModifierRecipeBuilder addInputSalvage(ITag<Item> tag, int minAmount, int maxAmount) {
        this.addInput(SizedIngredient.fromTag(tag, (int)maxAmount));
        this.addSalvage(tag, minAmount, maxAmount);
        return this;
    }

    public ModifierRecipeBuilder addInputSalvage(ITag<Item> tag, int amount) {
        return this.addInputSalvage(tag, 0, amount);
    }

    public ModifierRecipeBuilder addInputSalvage(ITag<Item> tag, float salvageChance) {
        this.addInput(SizedIngredient.fromTag(tag, (int)1));
        this.addSalvage(RandomItem.chance(ItemOutput.fromTag(tag, (int)1), salvageChance));
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        if (this.inputs.isEmpty()) {
            throw new IllegalStateException("Must have at least 1 input");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((IFinishedRecipe)new FinishedRecipe(id, advancementId, false));
        if (this.includeUnarmed) {
            if (this.requirements != ModifierMatch.ALWAYS) {
                throw new IllegalStateException("Cannot use includeUnarmed with requirements");
            }
            consumer.accept((IFinishedRecipe)new FinishedRecipe(new ResourceLocation(id.func_110624_b(), id.func_110623_a() + "_unarmed"), null, true));
        }
    }

    @Override
    public ModifierRecipeBuilder buildSalvage(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        if (this.salvageMaxLevel != 0 && this.salvageMaxLevel < this.salvageMinLevel) {
            throw new IllegalStateException("Max level must be greater than min level");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((IFinishedRecipe)new FinishedSalvage(id, advancementId));
        return this;
    }

    private class FinishedSalvage
    extends AbstractModifierRecipeBuilder.SalvageFinishedRecipe {
        public FinishedSalvage(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super(ID, advancementID);
        }

        @Override
        public void func_218610_a(JsonObject json) {
            super.func_218610_a(json);
            if (!ModifierRecipeBuilder.this.salvage.isEmpty()) {
                JsonArray array = new JsonArray();
                for (RandomItem randomItem : ModifierRecipeBuilder.this.salvage) {
                    array.add(randomItem.serialize());
                }
                json.add("salvage", (JsonElement)array);
            }
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)TinkerModifiers.modifierSalvageSerializer.get();
        }
    }

    private class FinishedRecipe
    extends AbstractModifierRecipeBuilder.ModifierFinishedRecipe {
        public FinishedRecipe(@Nullable ResourceLocation ID, ResourceLocation advancementID, boolean withUnarmed) {
            super(ID, advancementID, withUnarmed);
        }

        @Override
        public void func_218610_a(JsonObject json) {
            JsonArray array = new JsonArray();
            for (SizedIngredient ingredient : ModifierRecipeBuilder.this.inputs) {
                array.add((JsonElement)ingredient.serialize());
            }
            json.add("inputs", (JsonElement)array);
            super.func_218610_a(json);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)TinkerModifiers.modifierSerializer.get();
        }
    }
}

