/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.IncrementalModifier;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationInventory;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationInventory;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class IncrementalModifierRecipe
extends AbstractModifierRecipe {
    private final Ingredient input;
    private final int amountPerInput;
    private final int neededPerLevel;
    private final ItemStack leftover;

    @Deprecated
    public IncrementalModifierRecipe(ResourceLocation id, Ingredient input, int amountPerInput, int neededPerLevel, Ingredient toolRequirement, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, int upgradeSlots, int abilitySlots, ItemStack leftover) {
        super(id, toolRequirement, requirements, requirementsError, result, maxLevel, upgradeSlots, abilitySlots);
        this.input = input;
        this.amountPerInput = amountPerInput;
        this.neededPerLevel = neededPerLevel;
        this.leftover = leftover;
        ModifierRecipeLookup.addIngredient(input);
        ModifierRecipeLookup.setNeededPerLevel(result.getModifier(), neededPerLevel);
    }

    public IncrementalModifierRecipe(ResourceLocation id, Ingredient input, int amountPerInput, int neededPerLevel, Ingredient toolRequirement, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots, ItemStack leftover) {
        super(id, toolRequirement, requirements, requirementsError, result, maxLevel, slots);
        this.input = input;
        this.amountPerInput = amountPerInput;
        this.neededPerLevel = neededPerLevel;
        this.leftover = leftover;
        ModifierRecipeLookup.addIngredient(input);
        ModifierRecipeLookup.setNeededPerLevel(result.getModifier(), neededPerLevel);
    }

    @Override
    public boolean matches(ITinkerStationInventory inv, World world) {
        if (!this.toolRequirement.test(inv.getTinkerableStack())) {
            return false;
        }
        return IncrementalModifierRecipe.containsOnlyIngredient(inv, this.input);
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationInventory inv) {
        ValidatedResult commonError;
        ToolStack tool = ToolStack.from(inv.getTinkerableStack());
        Modifier modifier = this.result.getModifier();
        int current = tool.getUpgrades().getLevel(modifier) == 0 ? this.neededPerLevel : IncrementalModifier.getAmount(tool, modifier);
        if (current >= this.neededPerLevel && (commonError = this.validatePrerequisites(tool)).hasError()) {
            return commonError;
        }
        int available = IncrementalModifierRecipe.getAvailableAmount(inv, this.input, this.amountPerInput);
        tool = tool.copy();
        ModDataNBT persistentData = tool.getPersistentData();
        if (current >= this.neededPerLevel) {
            SlotType.SlotCount slots = this.getSlots();
            if (slots != null) {
                persistentData.addSlots(slots.getType(), -slots.getCount());
            }
            IncrementalModifier.setAmount(persistentData, modifier, Math.min(available + current - this.neededPerLevel, this.neededPerLevel));
            tool.addModifier(this.result.getModifier(), this.result.getLevel());
        } else {
            IncrementalModifier.setAmount(persistentData, modifier, Math.min(current + available, this.neededPerLevel));
            tool.rebuildStats();
        }
        return ValidatedResult.success(tool.createStack());
    }

    @Override
    public void updateInputs(ItemStack result, IMutableTinkerStationInventory inv) {
        ToolStack inputTool = ToolStack.from(inv.getTinkerableStack());
        ToolStack resultTool = ToolStack.from(result);
        Modifier modifier = this.result.getModifier();
        int needed = IncrementalModifier.getAmount(resultTool, modifier);
        int originalLevel = inputTool.getModifierLevel(modifier);
        needed = originalLevel > 0 ? (needed -= IncrementalModifier.getAmount(inputTool, modifier)) : (needed -= this.neededPerLevel);
        int levelChange = resultTool.getModifierLevel(modifier) - originalLevel;
        if (levelChange > 0) {
            needed += levelChange * this.neededPerLevel / this.result.getLevel();
        }
        if (needed > 0) {
            IncrementalModifierRecipe.updateInputs(inv, this.input, needed, this.amountPerInput, this.leftover);
        }
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerModifiers.incrementalModifierSerializer.get();
    }

    @Override
    public boolean isIncremental() {
        return true;
    }

    @Override
    protected void addIngredients(Consumer<List<ItemStack>> builder) {
        List<ItemStack> items = Arrays.asList(this.input.func_193365_a());
        int maxStackSize = items.stream().mapToInt(ItemStack::func_77976_d).min().orElse(64);
        int needed = this.neededPerLevel / this.amountPerInput;
        if (this.neededPerLevel % this.amountPerInput > 0) {
            ++needed;
        }
        Lazy fullSize = Lazy.of(() -> items.stream().map(stack -> ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)maxStackSize)).collect(Collectors.toList()));
        while (needed > maxStackSize) {
            builder.accept((List<ItemStack>)fullSize.get());
            needed -= maxStackSize;
        }
        if (needed > 0) {
            int remaining = needed;
            builder.accept(items.stream().map(stack -> ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)remaining)).collect(Collectors.toList()));
        }
    }

    public static boolean containsOnlyIngredient(ITinkerStationInventory inv, Ingredient ingredient) {
        boolean found = false;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.func_190926_b()) continue;
            if (ingredient.test(stack)) {
                found = true;
                continue;
            }
            return false;
        }
        return found;
    }

    public static int getAvailableAmount(ITinkerStationInventory inv, Ingredient ingredient, int amountPerItem) {
        int available = 0;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.func_190926_b() || !ingredient.test(stack)) continue;
            available += stack.func_190916_E() * amountPerItem;
        }
        return available;
    }

    public static void updateInputs(IMutableTinkerStationInventory inv, Ingredient ingredient, int amountNeeded, int amountPerInput, ItemStack leftover) {
        int itemsNeeded = amountNeeded / amountPerInput;
        int leftoverAmount = amountNeeded % amountPerInput;
        if (leftoverAmount > 0) {
            ++itemsNeeded;
            if (!leftover.func_190926_b()) {
                inv.giveItem(ItemHandlerHelper.copyStackWithSize((ItemStack)leftover, (int)(leftoverAmount * leftover.func_190916_E())));
            }
        }
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.func_190926_b() || !ingredient.test(stack)) continue;
            int count = stack.func_190916_E();
            if (count > itemsNeeded) {
                inv.shrinkInput(i, itemsNeeded);
                break;
            }
            inv.shrinkInput(i, count);
            itemsNeeded -= count;
        }
    }

    public static ItemStack deseralizeResultItem(JsonObject parent, String name) {
        JsonElement element = JsonHelper.getElement((JsonObject)parent, (String)name);
        if (element.isJsonPrimitive()) {
            return new ItemStack((IItemProvider)JSONUtils.func_188172_b((JsonElement)element, (String)name));
        }
        return CraftingHelper.getItemStack((JsonObject)JSONUtils.func_151210_l((JsonElement)element, (String)name), (boolean)true);
    }

    public static class Serializer
    extends AbstractModifierRecipe.Serializer<IncrementalModifierRecipe> {
        @Override
        public IncrementalModifierRecipe read(ResourceLocation id, JsonObject json, Ingredient toolRequirement, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
            Ingredient input = Ingredient.func_199802_a((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"input"));
            int amountPerInput = JSONUtils.func_151208_a((JsonObject)json, (String)"amount_per_item", (int)1);
            if (amountPerInput < 1) {
                throw new JsonSyntaxException("amount_per_item must be positive");
            }
            int neededPerLevel = JSONUtils.func_151203_m((JsonObject)json, (String)"needed_per_level");
            if (neededPerLevel <= amountPerInput) {
                throw new JsonSyntaxException("needed_per_level must be greater than amount_per_item");
            }
            ItemStack leftover = ItemStack.field_190927_a;
            if (amountPerInput > 1 && json.has("leftover")) {
                leftover = IncrementalModifierRecipe.deseralizeResultItem(json, "leftover");
            }
            return new IncrementalModifierRecipe(id, input, amountPerInput, neededPerLevel, toolRequirement, requirements, requirementsError, result, maxLevel, slots, leftover);
        }

        @Override
        public IncrementalModifierRecipe read(ResourceLocation id, PacketBuffer buffer, Ingredient toolRequirement, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            int amountPerInput = buffer.func_150792_a();
            int neededPerLevel = buffer.func_150792_a();
            ItemStack leftover = buffer.func_150791_c();
            return new IncrementalModifierRecipe(id, input, amountPerInput, neededPerLevel, toolRequirement, requirements, requirementsError, result, maxLevel, slots, leftover);
        }

        @Override
        public IncrementalModifierRecipe read(ResourceLocation id, JsonObject json, Ingredient toolRequirement, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, int upgradeSlots, int abilitySlots) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IncrementalModifierRecipe read(ResourceLocation id, PacketBuffer buffer, Ingredient toolRequirement, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, int upgradeSlots, int abilitySlots) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void writeSafe(PacketBuffer buffer, IncrementalModifierRecipe recipe) {
            super.writeSafe(buffer, recipe);
            recipe.input.func_199564_a(buffer);
            buffer.func_150787_b(recipe.amountPerInput);
            buffer.func_150787_b(recipe.neededPerLevel);
            buffer.func_150788_a(recipe.leftover);
        }
    }
}

