/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.fluid.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.client.modifiers.FluidModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TankModifier;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;

public class TankModifierModel
extends FluidModifierModel {
    public static final IUnbakedModifierModel UNBAKED_INSTANCE = (smallGetter, largeGetter) -> {
        RenderMaterial smallTexture = (RenderMaterial)smallGetter.apply("");
        RenderMaterial largeTexture = (RenderMaterial)largeGetter.apply("");
        RenderMaterial smallPartial = (RenderMaterial)smallGetter.apply("_partial");
        RenderMaterial largePartial = (RenderMaterial)largeGetter.apply("_partial");
        RenderMaterial smallFull = (RenderMaterial)smallGetter.apply("_full");
        RenderMaterial largeFull = (RenderMaterial)largeGetter.apply("_full");
        if (smallTexture != null || largeTexture != null) {
            return new TankModifierModel(smallTexture, largeTexture, smallPartial, largePartial, smallFull, largeFull);
        }
        return null;
    };

    public TankModifierModel(@Nullable RenderMaterial smallTexture, @Nullable RenderMaterial largeTexture, @Nullable RenderMaterial smallPartial, @Nullable RenderMaterial largePartial, @Nullable RenderMaterial smallFull, @Nullable RenderMaterial largeFull) {
        super(smallTexture, largeTexture, new RenderMaterial[]{smallPartial, largePartial, smallFull, largeFull});
    }

    @Override
    @Nullable
    public Object getCacheKey(IModifierToolStack tool, ModifierEntry entry) {
        TankModifier tank;
        FluidStack fluid;
        if (entry.getModifier() instanceof TankModifier && !(fluid = (tank = (TankModifier)entry.getModifier()).getFluid(tool)).isEmpty()) {
            return new TankModifierCacheKey(tank, fluid.getFluid(), fluid.getAmount() < tank.getCapacity(tool));
        }
        return entry.getModifier();
    }

    @Override
    @Nullable
    protected RenderMaterial getTemplate(TankModifier tank, IModifierToolStack tool, FluidStack fluid, boolean isLarge) {
        boolean isFull = fluid.getAmount() == tank.getCapacity(tool);
        return this.fluidTextures[(isFull ? 2 : 0) | (isLarge ? 1 : 0)];
    }

    private static class TankModifierCacheKey {
        private final Modifier modifier;
        private final Fluid fluid;
        private final boolean isPartial;

        public TankModifierCacheKey(Modifier modifier, Fluid fluid, boolean isPartial) {
            this.modifier = modifier;
            this.fluid = fluid;
            this.isPartial = isPartial;
        }

        public Modifier getModifier() {
            return this.modifier;
        }

        public Fluid getFluid() {
            return this.fluid;
        }

        public boolean isPartial() {
            return this.isPartial;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TankModifierCacheKey)) {
                return false;
            }
            TankModifierCacheKey other = (TankModifierCacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Modifier this$modifier = this.getModifier();
            Modifier other$modifier = other.getModifier();
            if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
                return false;
            }
            Fluid this$fluid = this.getFluid();
            Fluid other$fluid = other.getFluid();
            if (this$fluid == null ? other$fluid != null : !this$fluid.equals(other$fluid)) {
                return false;
            }
            return this.isPartial() == other.isPartial();
        }

        protected boolean canEqual(Object other) {
            return other instanceof TankModifierCacheKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Modifier $modifier = this.getModifier();
            result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
            Fluid $fluid = this.getFluid();
            result = result * 59 + ($fluid == null ? 43 : $fluid.hashCode());
            result = result * 59 + (this.isPartial() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "TankModifierModel.TankModifierCacheKey(modifier=" + this.getModifier() + ", fluid=" + this.getFluid() + ", isPartial=" + this.isPartial() + ")";
        }
    }
}

