/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.tools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.shared.TinkerClient;

public class MaterialModel
implements IModelGeometry<MaterialModel> {
    private static final Logger log = LogManager.getLogger(MaterialModel.class);
    private static final Set<ResourceLocation> SKIPPED_TEXTURES = new HashSet<ResourceLocation>();
    public static final Loader LOADER = new Loader();
    @Nullable
    private final MaterialId material;
    private final int index;
    private final Vector2f offset;

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet allTextures = Sets.newHashSet();
        MaterialModel.getMaterialTextures(allTextures, owner, "texture", this.material);
        return allTextures;
    }

    public static Predicate<RenderMaterial> getTextureAdder(ResourceLocation textureLocation, Collection<RenderMaterial> allTextures, boolean logMissingTextures) {
        if (textureLocation.func_110623_a().startsWith("item/tool")) {
            return mat -> {
                ResourceLocation loc = mat.func_229313_b_();
                if (!PlayerContainer.field_226615_c_.equals((Object)mat.func_229310_a_()) || TinkerClient.textureValidator.test(loc)) {
                    allTextures.add((RenderMaterial)mat);
                    return true;
                }
                if (logMissingTextures && !SKIPPED_TEXTURES.contains(loc)) {
                    SKIPPED_TEXTURES.add(loc);
                    log.debug("Skipping loading texture '{}' as it does not exist in the resource pack", (Object)loc);
                }
                return false;
            };
        }
        log.error("Texture '{}' is not in item/tool, unable to safely validate optional material textures", (Object)textureLocation);
        return mat -> {
            allTextures.add((RenderMaterial)mat);
            return true;
        };
    }

    public static void getMaterialTextures(Collection<RenderMaterial> allTextures, IModelConfiguration owner, String textureName, @Nullable MaterialId material) {
        RenderMaterial texture = owner.resolveTexture(textureName);
        allTextures.add(texture);
        if (!MissingTextureSprite.func_195675_b().equals((Object)texture.func_229313_b_())) {
            Predicate<RenderMaterial> textureAdder = MaterialModel.getTextureAdder(texture.func_229313_b_(), allTextures, (Boolean)Config.CLIENT.logMissingMaterialTextures.get());
            if (material == null) {
                MaterialRenderInfoLoader.INSTANCE.getAllRenderInfos().forEach(info -> info.getTextureDependencies(textureAdder, texture));
            } else {
                MaterialRenderInfoLoader.INSTANCE.getRenderInfo(material).ifPresent(info -> info.getTextureDependencies(textureAdder, texture));
            }
        }
    }

    public static TextureAtlasSprite getPartQuads(Consumer<ImmutableList<BakedQuad>> quadConsumer, IModelConfiguration owner, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, TransformationMatrix transform, String name, int index, @Nullable MaterialId material) {
        return MaterialModel.getPartQuads(quadConsumer, owner, spriteGetter, transform, name, index, material, null);
    }

    public static TextureAtlasSprite getPartQuads(Consumer<ImmutableList<BakedQuad>> quadConsumer, IModelConfiguration owner, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, TransformationMatrix transform, String name, int index, @Nullable MaterialId material, @Nullable ItemLayerPixels pixels) {
        Optional<MaterialRenderInfo> optional;
        RenderMaterial texture = owner.resolveTexture(name);
        int color = -1;
        int light = 0;
        TextureAtlasSprite finalSprite = null;
        if (material != null && (optional = MaterialRenderInfoLoader.INSTANCE.getRenderInfo(material)).isPresent()) {
            MaterialRenderInfo info = optional.get();
            MaterialRenderInfo.TintedSprite sprite = info.getSprite(texture, spriteGetter);
            finalSprite = sprite.getSprite();
            color = sprite.getColor();
            light = info.getLuminosity();
        }
        if (finalSprite == null) {
            finalSprite = spriteGetter.apply(texture);
        }
        quadConsumer.accept((ImmutableList<BakedQuad>)MantleItemLayerModel.getQuadsForSprite((int)color, (int)-1, (TextureAtlasSprite)finalSprite, (TransformationMatrix)transform, (int)light, (ItemLayerPixels)pixels));
        return finalSprite;
    }

    private static IBakedModel bakeInternal(IModelConfiguration owner, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, TransformationMatrix transform, @Nullable MaterialId material, int index, ItemOverrideList overrides) {
        MutableObject mutableList = new MutableObject();
        TextureAtlasSprite particle = MaterialModel.getPartQuads(arg_0 -> ((MutableObject)mutableList).setValue(arg_0), owner, spriteGetter, transform, "texture", index, material);
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((IModelTransform)owner.getCombinedTransform());
        return new BakedItemModel((ImmutableList)mutableList.getValue(), particle, Maps.immutableEnumMap((Map)transformMap), overrides, true, owner.isSideLit());
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList vanillaOverrides, ResourceLocation modelLocation) {
        TransformationMatrix transforms = Vector2f.field_189974_a.func_201069_c(this.offset) ? TransformationMatrix.func_227983_a_() : new TransformationMatrix(new Vector3f(this.offset.field_189982_i / 16.0f, -this.offset.field_189983_j / 16.0f, 0.0f), null, null, null);
        ItemOverrideList overrides = ItemOverrideList.field_188022_a;
        if (this.material == null) {
            overrides = new MaterialOverrideHandler(owner, this.index, transforms);
        }
        return MaterialModel.bakeInternal(owner, spriteGetter, transforms, this.material, this.index, overrides);
    }

    public static Vector2f arrayToObject(JsonObject json, String name) {
        JsonArray array = JSONUtils.func_151214_t((JsonObject)json, (String)name);
        if (array.size() != 2) {
            throw new JsonParseException("Expected 2 " + name + " values, found: " + array.size());
        }
        float[] vec = new float[2];
        for (int i = 0; i < 2; ++i) {
            vec[i] = JSONUtils.func_151220_d((JsonElement)array.get(i), (String)(name + "[" + i + "]"));
        }
        return new Vector2f(vec[0], vec[1]);
    }

    public MaterialModel(@Nullable MaterialId material, int index, Vector2f offset) {
        this.material = material;
        this.index = index;
        this.offset = offset;
    }

    private static class Loader
    implements IModelLoader<MaterialModel> {
        private Loader() {
        }

        public void func_195410_a(IResourceManager resourceManager) {
            SKIPPED_TEXTURES.clear();
        }

        public MaterialModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            int index = JSONUtils.func_151208_a((JsonObject)modelContents, (String)"index", (int)0);
            MaterialId material = null;
            if (modelContents.has("material")) {
                material = new MaterialId(JSONUtils.func_151200_h((JsonObject)modelContents, (String)"material"));
            }
            Vector2f offset = Vector2f.field_189974_a;
            if (modelContents.has("offset")) {
                offset = MaterialModel.arrayToObject(modelContents, "offset");
            }
            return new MaterialModel(material, index, offset);
        }
    }

    private static final class MaterialOverrideHandler
    extends ItemOverrideList {
        private final Map<MaterialId, IBakedModel> cache = new HashMap<MaterialId, IBakedModel>();
        private final IModelConfiguration owner;
        private final int index;
        private final TransformationMatrix itemTransform;

        private MaterialOverrideHandler(IModelConfiguration owner, int index, TransformationMatrix itemTransform) {
            this.owner = owner;
            this.index = index;
            this.itemTransform = itemTransform;
        }

        public IBakedModel func_239290_a_(IBakedModel originalModel, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
            MaterialId material = IMaterialItem.getMaterialIdFromStack(stack);
            return this.cache.computeIfAbsent(material, this::bakeDynamic);
        }

        private IBakedModel bakeDynamic(MaterialId material) {
            return MaterialModel.bakeInternal(this.owner, ModelLoader.defaultTextureGetter(), this.itemTransform, material, this.index, ItemOverrideList.field_188022_a);
        }
    }
}

