/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct;

import java.util.Locale;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.SlimeBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.registration.RegistrationHelper;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.common.data.AdvancementsProvider;
import slimeknights.tconstruct.common.data.loot.GlobalLootModifiersProvider;
import slimeknights.tconstruct.common.data.loot.TConstructLootTableProvider;
import slimeknights.tconstruct.common.data.tags.BlockTagProvider;
import slimeknights.tconstruct.common.data.tags.EntityTypeTagProvider;
import slimeknights.tconstruct.common.data.tags.FluidTagProvider;
import slimeknights.tconstruct.common.data.tags.ItemTagProvider;
import slimeknights.tconstruct.common.data.tags.TileEntityTypeTagProvider;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.gadgets.entity.FrameType;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionLoader;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayoutLoader;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.plugin.crt.CRTHelper;
import slimeknights.tconstruct.shared.TinkerClient;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.TinkerWorld;

@Mod(value="tconstruct")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TConstruct {
    public static final String MOD_ID = "tconstruct";
    public static final Logger LOG = LogManager.getLogger((String)"tconstruct");
    public static final Random RANDOM = new Random();
    public static TConstruct instance;

    public TConstruct() {
        instance = this;
        Config.init();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.register((Object)new TinkerCommons());
        bus.register((Object)new TinkerFluids());
        bus.register((Object)new TinkerGadgets());
        bus.register((Object)new TinkerWorld());
        bus.register((Object)new TinkerStructures());
        bus.register((Object)new TinkerTables());
        bus.register((Object)new TinkerMaterials());
        bus.register((Object)new TinkerModifiers());
        bus.register((Object)new TinkerToolParts());
        bus.register((Object)new TinkerTools());
        bus.register((Object)new TinkerSmeltery());
        TinkerModule.initRegisters();
        TinkerNetwork.setup();
        TinkerTags.init();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> TinkerClient::onConstruct);
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (ModList.get().isLoaded("crafttweaker")) {
            MinecraftForge.EVENT_BUS.register((Object)new CRTHelper());
        }
    }

    @SubscribeEvent
    static void commonSetup(FMLCommonSetupEvent event) {
        MaterialRegistry.init();
        ToolDefinitionLoader.init();
        StationSlotLayoutLoader.init();
    }

    @SubscribeEvent
    static void gatherData(GatherDataEvent event) {
        if (event.includeServer()) {
            DataGenerator datagenerator = event.getGenerator();
            ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
            BlockTagProvider blockTags = new BlockTagProvider(datagenerator, existingFileHelper);
            datagenerator.func_200390_a((IDataProvider)blockTags);
            datagenerator.func_200390_a((IDataProvider)new ItemTagProvider(datagenerator, blockTags, existingFileHelper));
            datagenerator.func_200390_a((IDataProvider)new FluidTagProvider(datagenerator, existingFileHelper));
            datagenerator.func_200390_a((IDataProvider)new EntityTypeTagProvider(datagenerator, existingFileHelper));
            datagenerator.func_200390_a((IDataProvider)new TileEntityTypeTagProvider(datagenerator, existingFileHelper));
            datagenerator.func_200390_a((IDataProvider)new TConstructLootTableProvider(datagenerator));
            datagenerator.func_200390_a((IDataProvider)new AdvancementsProvider(datagenerator));
            datagenerator.func_200390_a((IDataProvider)new GlobalLootModifiersProvider(datagenerator));
        }
    }

    @Nullable
    private static Block missingBlock(String name) {
        switch (name) {
            case "faucet": {
                return (Block)TinkerSmeltery.searedFaucet.get();
            }
            case "channel": {
                return (Block)TinkerSmeltery.searedChannel.get();
            }
            case "casting_table": {
                return (Block)TinkerSmeltery.searedTable.get();
            }
            case "casting_basin": {
                return (Block)TinkerSmeltery.searedBasin.get();
            }
            case "melter": {
                return (Block)TinkerSmeltery.searedMelter.get();
            }
            case "seared_tank": {
                return (Block)TinkerSmeltery.searedTank.get((Enum)SearedTankBlock.TankType.FUEL_TANK);
            }
            case "seared_gauge": {
                return (Block)TinkerSmeltery.searedTank.get((Enum)SearedTankBlock.TankType.INGOT_GAUGE);
            }
            case "seared_window": {
                return (Block)TinkerSmeltery.searedTank.get((Enum)SearedTankBlock.TankType.INGOT_TANK);
            }
            case "scorched_tank": {
                return (Block)TinkerSmeltery.scorchedTank.get((Enum)SearedTankBlock.TankType.FUEL_TANK);
            }
            case "scorched_gauge": {
                return (Block)TinkerSmeltery.scorchedTank.get((Enum)SearedTankBlock.TankType.INGOT_GAUGE);
            }
            case "scorched_window": {
                return (Block)TinkerSmeltery.scorchedTank.get((Enum)SearedTankBlock.TankType.INGOT_TANK);
            }
            case "magma_cream_fluid": {
                return TinkerFluids.magma.getBlock();
            }
            case "molten_blaze_fluid": {
                return TinkerFluids.blazingBlood.getBlock();
            }
            case "stone_ladder": {
                return Blocks.field_150468_ap;
            }
            case "stone_torch": {
                return Blocks.field_150478_aa;
            }
            case "wall_stone_torch": {
                return Blocks.field_196591_bQ;
            }
            case "wooden_rail": 
            case "wooden_dropper_rail": {
                return Blocks.field_150448_aq;
            }
            case "dried_clay": {
                return Blocks.field_150405_ch;
            }
            case "dried_clay_bricks": {
                return Blocks.field_196584_bK;
            }
            case "dried_clay_slab": 
            case "dried_clay_bricks_slab": {
                return Blocks.field_196571_bA;
            }
            case "dried_clay_stairs": 
            case "dried_clay_bricks_stairs": {
                return Blocks.field_150389_bf;
            }
            case "modifier_chest": {
                return (Block)TinkerTables.tinkersChest.get();
            }
        }
        return null;
    }

    @SubscribeEvent
    void missingItems(RegistryEvent.MissingMappings<Item> event) {
        RegistrationHelper.handleMissingMappings(event, (String)MOD_ID, name -> {
            switch (name) {
                case "sword_blade": {
                    return (Item)TinkerToolParts.smallBlade.get();
                }
                case "sword_blade_cast": {
                    return (Item)TinkerSmeltery.smallBladeCast.get();
                }
                case "sword_blade_sand_cast": {
                    return TinkerSmeltery.smallBladeCast.getSand();
                }
                case "sword_blade_red_sand_cast": {
                    return TinkerSmeltery.smallBladeCast.getRedSand();
                }
                case "reinforcement": {
                    return (Item)TinkerModifiers.ironReinforcement.get();
                }
                case "magma_cream_bucket": {
                    return TinkerFluids.magma.func_199767_j();
                }
                case "molten_blaze_bucket": {
                    return TinkerFluids.blazingBlood.func_199767_j();
                }
                case "monster_jerky": {
                    return Items.field_151078_bh;
                }
                case "beef_jerky": {
                    return Items.field_151083_be;
                }
                case "chicken_jerky": {
                    return Items.field_151077_bg;
                }
                case "pork_jerky": {
                    return Items.field_151157_am;
                }
                case "mutton_jerky": {
                    return Items.field_179557_bn;
                }
                case "rabbit_jerky": {
                    return Items.field_179559_bp;
                }
                case "fish_jerky": {
                    return Items.field_196102_ba;
                }
                case "salmon_jerky": {
                    return Items.field_196104_bb;
                }
                case "clownfish_jerky": {
                    return Items.field_196088_aY;
                }
                case "pufferfish_jerky": {
                    return Items.field_196089_aZ;
                }
                case "earth_slime_drop": {
                    return Items.field_151123_aH;
                }
                case "sky_slime_drop": {
                    return (Item)TinkerCommons.slimeball.get((Enum)SlimeType.SKY);
                }
                case "ichor_slime_drop": {
                    return (Item)TinkerCommons.slimeball.get((Enum)SlimeType.ICHOR);
                }
                case "blood_slime_drop": {
                    return (Item)TinkerCommons.slimeball.get((Enum)SlimeType.BLOOD);
                }
                case "ender_slime_drop": {
                    return (Item)TinkerCommons.slimeball.get((Enum)SlimeType.ENDER);
                }
                case "stone_stick": {
                    return Blocks.field_150347_e.func_199767_j();
                }
                case "dried_brick": {
                    return Items.field_151118_aC;
                }
                case "ancient_axe_head": 
                case "ancient_shovel_head": 
                case "ancient_hoe_head": {
                    return Items.field_234760_kn_;
                }
                case "creative_upgrade": 
                case "creative_ability": {
                    return (Item)TinkerModifiers.creativeSlotItem.get();
                }
                case "cobalt_item_frame": {
                    return (Item)TinkerGadgets.itemFrame.get((Enum)FrameType.DIAMOND);
                }
                case "jewel_item_frame": {
                    return (Item)TinkerGadgets.itemFrame.get((Enum)FrameType.GOLD);
                }
                case "earth_slime_boots": {
                    return ((SlimeBlock)TinkerWorld.slime.get((Enum)SlimeType.EARTH)).func_199767_j();
                }
                case "sky_slime_boots": {
                    return ((SlimeBlock)TinkerWorld.slime.get((Enum)SlimeType.SKY)).func_199767_j();
                }
                case "ichor_slime_boots": {
                    return ((SlimeBlock)TinkerWorld.slime.get((Enum)SlimeType.ICHOR)).func_199767_j();
                }
                case "ender_slime_boots": {
                    return ((SlimeBlock)TinkerWorld.slime.get((Enum)SlimeType.ENDER)).func_199767_j();
                }
                case "blood_slime_boots": {
                    return ((SlimeBlock)TinkerWorld.slime.get((Enum)SlimeType.BLOOD)).func_199767_j();
                }
            }
            Block block = TConstruct.missingBlock(name);
            return block == null ? null : block.func_199767_j();
        });
    }

    @SubscribeEvent
    void missingBlocks(RegistryEvent.MissingMappings<Block> event) {
        RegistrationHelper.handleMissingMappings(event, (String)MOD_ID, TConstruct::missingBlock);
    }

    @SubscribeEvent
    void missingFluids(RegistryEvent.MissingMappings<Fluid> event) {
        RegistrationHelper.handleMissingMappings(event, (String)MOD_ID, name -> {
            switch (name) {
                case "magma_cream": {
                    return TinkerFluids.magma.get();
                }
                case "flowing_magma_cream": {
                    return TinkerFluids.magma.getFlowing();
                }
                case "molten_blaze": {
                    return TinkerFluids.blazingBlood.get();
                }
                case "flowing_molten_blaze": {
                    return TinkerFluids.blazingBlood.getFlowing();
                }
            }
            return null;
        });
    }

    @SubscribeEvent
    void missingModifiers(RegistryEvent.MissingMappings<Modifier> event) {
        RegistrationHelper.handleMissingMappings(event, (String)MOD_ID, name -> {
            switch (name) {
                case "beheading": {
                    return (Modifier)TinkerModifiers.severing.get();
                }
                case "bane_of_arthropods": {
                    return (Modifier)TinkerModifiers.baneOfSssss.get();
                }
                case "duel_wielding": {
                    return (Modifier)TinkerModifiers.dualWielding.get();
                }
                case "creative_upgrade": {
                    return (Modifier)TinkerModifiers.redExtraUpgrade.get();
                }
                case "creative_ability": {
                    return (Modifier)TinkerModifiers.extraAbility.get();
                }
            }
            return null;
        });
    }

    public static ResourceLocation getResource(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static <T> TinkerDataCapability.TinkerDataKey<T> createKey(String name) {
        return TinkerDataCapability.TinkerDataKey.of(TConstruct.getResource(name));
    }

    public static <T> TinkerDataCapability.ComputableDataKey<T> createKey(String name, Supplier<T> constructor) {
        return TinkerDataCapability.ComputableDataKey.of(TConstruct.getResource(name), constructor);
    }

    public static String resourceString(String res) {
        return String.format("%s:%s", MOD_ID, res);
    }

    public static String prefix(String name) {
        return String.format("%s.%s", MOD_ID, name.toLowerCase(Locale.US));
    }

    public static String makeTranslationKey(String base, String name) {
        return Util.makeTranslationKey(base, TConstruct.getResource(name));
    }

    public static IFormattableTextComponent makeTranslation(String base, String name) {
        return new TranslationTextComponent(TConstruct.makeTranslationKey(base, name));
    }

    public static IFormattableTextComponent makeTranslation(String base, String name, Object ... arguments) {
        return new TranslationTextComponent(TConstruct.makeTranslationKey(base, name), arguments);
    }
}

