/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.world.structures;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public class RoadSignFeature
extends Feature<NoFeatureConfig> {
    private final BlockState cobble = Blocks.field_150347_e.func_176223_P();
    private final BlockState mossyCobble = Blocks.field_150341_Y.func_176223_P();
    private final BlockState fence = Blocks.field_180408_aP.func_176223_P();
    private final BlockState wall = Blocks.field_150463_bK.func_176223_P();
    private final BlockState mossyWall = Blocks.field_196723_eg.func_176223_P();
    private final BlockState diamond = Blocks.field_150484_ah.func_176223_P();

    public RoadSignFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    private static boolean canGoThrough(IWorld world, BlockPos pos) {
        try {
            if (!world.func_204610_c(pos).func_206888_e()) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return world.func_217375_a(pos, state -> {
            Material material = state.func_185904_a();
            return material.func_76222_j() || material == Material.field_151584_j || material == Material.field_151585_k;
        });
    }

    public static boolean isReplaceable(IWorld world, BlockPos pos) {
        return world.func_217375_a(pos, state -> {
            Material material = state.func_185904_a();
            return material.func_76222_j() && material != Material.field_151584_j;
        });
    }

    public static boolean isNotSolid(IWorld world, BlockPos pos) {
        return !world.func_217375_a(pos, state -> state.func_215686_e((IBlockReader)world, pos));
    }

    public boolean place(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (!reader.func_201672_e().func_234923_W_().equals(World.field_234918_g_)) {
            return false;
        }
        if (pos.func_177956_o() > 90 || pos.func_177956_o() < 50) {
            return false;
        }
        if (!reader.func_201672_e().func_72863_F().field_186029_c.func_202090_b().func_205004_a(Structure.field_236381_q_)) {
            return false;
        }
        pos = pos.func_177984_a();
        while (RoadSignFeature.canGoThrough((IWorld)reader, pos) && pos.func_177956_o() > 2) {
            pos = pos.func_177977_b();
        }
        if (RoadSignFeature.isNotSolid((IWorld)reader, pos)) {
            return false;
        }
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                for (int h = 2; h <= 5; ++h) {
                    if (RoadSignFeature.isReplaceable((IWorld)reader, pos.func_177982_a(i, h, j))) continue;
                    return false;
                }
                if (!RoadSignFeature.canGoThrough((IWorld)reader, pos.func_177982_a(i, 1, j))) {
                    return false;
                }
                if (RoadSignFeature.isNotSolid((IWorld)reader, pos.func_177982_a(i, 0, j))) {
                    return false;
                }
                if (!RoadSignFeature.isNotSolid((IWorld)reader, pos.func_177982_a(i, -1, j))) continue;
                return false;
            }
        }
        float humidity = reader.func_226691_t_(pos).func_76727_i();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                reader.func_180501_a(pos.func_177982_a(i, -1, j), this.cobble, 2);
                if (j != 0 && i != 0 && 0.55 > (double)rand.nextFloat()) continue;
                BlockPos p1 = pos.func_177982_a(i, 0, j);
                boolean m = (double)humidity * 0.75 > (double)rand.nextFloat();
                reader.func_180501_a(p1, m ? this.mossyCobble : this.cobble, 2);
            }
        }
        boolean m = (double)humidity * 0.75 > (double)rand.nextFloat();
        pos = pos.func_177984_a();
        reader.func_180501_a(pos, m ? this.mossyWall : this.wall, 2);
        pos = pos.func_177984_a();
        reader.func_180501_a(pos, this.fence, 2);
        pos = pos.func_177984_a();
        reader.func_180501_a(pos, this.fence, 2);
        reader.func_180501_a(pos.func_177984_a(), ((Block)Registry.BLOCK_GENERATOR.get()).func_176223_P(), 2);
        return true;
    }

    private boolean isNearVillage(ChunkGenerator generator, long idk, SharedSeedRandom seed, int p_242782_5_, int p_242782_6_) {
        StructureSeparationSettings structureseparationsettings = generator.func_235957_b_().func_236197_a_(Structure.field_236381_q_);
        if (structureseparationsettings != null) {
            for (int i = p_242782_5_ - 10; i <= p_242782_5_ + 10; ++i) {
                for (int j = p_242782_6_ - 10; j <= p_242782_6_ + 10; ++j) {
                    ChunkPos chunkpos = Structure.field_236381_q_.func_236392_a_(structureseparationsettings, idk, seed, i, j);
                    if (i != chunkpos.field_77276_a || j != chunkpos.field_77275_b) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

