/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.world.data;

import net.mehvahdjukaar.supplementaries.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.network.SyncGlobeDataPacket;
import net.mehvahdjukaar.supplementaries.world.data.GlobeDataGenerator;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GlobeData
extends WorldSavedData {
    public static final String DATA_NAME = "supplementariesGlobeData";
    public byte[][] globePixels;
    public long seed;
    public static GlobeData clientSide = new GlobeData();

    public GlobeData() {
        super(DATA_NAME);
        this.globePixels = new byte[32][16];
    }

    public GlobeData(long seed) {
        super(DATA_NAME);
        this.seed = seed;
        this.updateData();
    }

    public void updateData() {
        this.globePixels = GlobeDataGenerator.generate(this.seed);
        this.func_76185_a();
    }

    public void func_76184_a(CompoundNBT nbt) {
        for (int i = 0; i < this.globePixels.length; ++i) {
            this.globePixels[i] = nbt.func_74770_j("colors_" + i);
        }
        this.seed = nbt.func_74763_f("seed");
    }

    public CompoundNBT func_189551_b(CompoundNBT nbt) {
        for (int i = 0; i < this.globePixels.length; ++i) {
            nbt.func_74773_a("colors_" + i, this.globePixels[i]);
        }
        nbt.func_74772_a("seed", this.seed);
        return nbt;
    }

    public void syncData(World world) {
        this.func_76185_a();
        if (!world.field_72995_K) {
            NetworkHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SyncGlobeDataPacket(this));
        }
    }

    public static GlobeData get(World world) {
        if (world instanceof ServerWorld) {
            return (GlobeData)world.func_73046_m().func_71218_a(World.field_234918_g_).func_217481_x().func_215752_a(() -> new GlobeData(((ISeedReader)world).func_72905_C()), DATA_NAME);
        }
        return clientSide;
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        IWorld world = event.getWorld();
        if (world instanceof ServerWorld && ((World)world).func_234923_W_() == World.field_234918_g_) {
            GlobeData.get((World)world).updateData();
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        GlobeData data;
        if (!event.getPlayer().field_70170_p.field_72995_K && (data = GlobeData.get(event.getPlayer().field_70170_p)) != null) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new SyncGlobeDataPacket(data));
        }
    }
}

