/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.items;

import java.util.List;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.block.util.MobHolder;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;

public class EmptyCageItem
extends BlockItem {
    public final Supplier<Item> full;
    public final CageWhitelist cageType;

    public EmptyCageItem(Block blockIn, Item.Properties properties, Supplier<Item> full, CageWhitelist whitelist) {
        super(blockIn, properties);
        this.full = full;
        this.cageType = whitelist;
    }

    private static List<MobEntity> getEntitiesInRange(MobEntity e) {
        double d0 = e.func_233637_b_(Attributes.field_233819_b_);
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_241549_a_((Vector3d)e.func_213303_ch()).func_72314_b(d0, 10.0, d0);
        return e.field_70170_p.func_225317_b(e.getClass(), axisalignedbb);
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity2) {
        if (player.func_184600_cs() == null) {
            return false;
        }
        return this.doInteract(stack, player, entity2, player.func_184600_cs()).func_226246_a_();
    }

    public ActionResultType doInteract(ItemStack stack, PlayerEntity player, Entity entity2, Hand hand) {
        ResourceLocation n = entity2.func_200600_R().getRegistryName();
        if (n == null) {
            return ActionResultType.PASS;
        }
        String name = n.toString();
        boolean isFirefly = false;
        boolean canBeCaught = false;
        switch (this.cageType) {
            case CAGE: {
                canBeCaught = ServerConfigs.cached.CAGE_ALL_MOBS || entity2 instanceof LivingEntity && ServerConfigs.cached.CAGE_ALL_BABIES && ((LivingEntity)entity2).func_70631_g_() || ServerConfigs.cached.CAGE_ALLOWED_MOBS.contains(name) || entity2 instanceof LivingEntity && ServerConfigs.cached.CAGE_ALLOWED_BABY_MOBS.contains(name) && ((LivingEntity)entity2).func_70631_g_();
                break;
            }
            case JAR: {
                isFirefly = entity2.func_200600_R().getRegistryName().func_110623_a().toLowerCase().contains("firefl");
                canBeCaught = ServerConfigs.cached.CAGE_ALL_MOBS || isFirefly || ServerConfigs.cached.MOB_JAR_ALLOWED_MOBS.contains(name);
                break;
            }
            case TINTED_JAR: {
                boolean bl = canBeCaught = ServerConfigs.cached.CAGE_ALL_MOBS || ServerConfigs.cached.MOB_JAR_TINTED_ALLOWED_MOBS.contains(name);
            }
        }
        if (!canBeCaught) {
            return ActionResultType.PASS;
        }
        if (!entity2.func_70089_S() || entity2 instanceof LivingEntity && ((LivingEntity)entity2).func_233643_dh_()) {
            return ActionResultType.PASS;
        }
        if (entity2 instanceof SlimeEntity && ((SlimeEntity)entity2).func_70809_q() > 1) {
            return ActionResultType.PASS;
        }
        if (player.field_70170_p.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ItemStack returnStack = new ItemStack(isFirefly ? (IItemProvider)Registry.FIREFLY_JAR_ITEM.get() : (IItemProvider)this.full.get());
        if (!isFirefly) {
            CompoundNBT cmp;
            if (stack.func_82837_s()) {
                returnStack.func_200302_a(stack.func_200301_q());
            }
            if ((cmp = MobHolder.createMobHolderItemNBT(entity2, this.cageType.height, this.cageType.width)) != null) {
                returnStack.func_77983_a("BlockEntityTag", (INBT)cmp);
            }
        }
        CommonUtil.swapItem(player, hand, stack, returnStack);
        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187719_p, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (entity2 instanceof IAngerable && entity2 instanceof MobEntity) {
            EmptyCageItem.getEntitiesInRange((MobEntity)entity2).stream().filter(mob -> mob != entity2).map(mob -> (IAngerable)mob).forEach(mob -> {
                mob.func_241355_J__();
                mob.func_230259_a_(player.func_110124_au());
                mob.func_70604_c((LivingEntity)player);
            });
        }
        if (entity2 instanceof PiglinEntity) {
            entity2.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 0.0f);
        }
        entity2.func_70106_y();
        return ActionResultType.CONSUME;
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity entity2, Hand hand) {
        return this.doInteract(stack, player, (Entity)entity2, hand);
    }

    public static enum CageWhitelist {
        CAGE(1.0f, 0.875f),
        JAR(0.875f, 0.625f),
        TINTED_JAR(0.875f, 0.625f);

        public final float width;
        public final float height;

        private CageWhitelist(float blockH, float blockW) {
            this.width = blockW;
            this.height = blockH;
        }

        public boolean isJar() {
            return this != CAGE;
        }
    }
}

