/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.fluids;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.client.renderers.FluidColors;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.fluids.SoftFluid;
import net.mehvahdjukaar.supplementaries.fluids.SoftFluidList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MilkBucketItem;
import net.minecraft.item.PotionItem;
import net.minecraft.item.SuspiciousStewItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.stats.Stats;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SoftFluidHolder {
    public static final int BOTTLE_COUNT = 1;
    public static final int BOWL_COUNT = 2;
    public static final int BUCKET_COUNT = 4;
    @Nullable
    private World world = null;
    @Nullable
    private BlockPos pos = null;
    private int count = 0;
    private final int capacity;
    private CompoundNBT nbt = new CompoundNBT();
    private SoftFluid fluid = SoftFluidList.EMPTY;
    private int specialColor = 0;

    public SoftFluidHolder(int capacity) {
        this.capacity = capacity;
    }

    public void setWorldAndPos(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    private void applyNBT(ItemStack stack) {
        if (this.nbt != null && !this.nbt.isEmpty()) {
            stack.func_77982_d(this.nbt.func_74737_b());
        }
    }

    private boolean addSpecial(SoftFluid s, int count, CompoundNBT com) {
        if (this.isEmpty()) {
            this.setFluid(s, com.func_74737_b());
            this.grow(count);
            return true;
        }
        if (this.fluid == s && this.canAdd(count) && this.nbt.equals((Object)com)) {
            this.grow(count);
            return true;
        }
        return false;
    }

    @Nullable
    private ItemStack handleNBTItems(ItemStack stack) {
        Item item2 = stack.func_77973_b();
        CompoundNBT com = stack.func_77978_p();
        if (com != null) {
            if (item2 instanceof PotionItem) {
                Potion potion = PotionUtils.func_185191_c((ItemStack)stack);
                if (potion == Potions.field_185230_b && this.addSpecial(SoftFluidList.WATER, 1, new CompoundNBT())) {
                    return new ItemStack((IItemProvider)Items.field_151069_bo);
                }
                if (potion != Potions.field_185229_a && com.func_74764_b("Potion")) {
                    CompoundNBT newCom = new CompoundNBT();
                    newCom.func_74778_a("Potion", com.func_74779_i("Potion"));
                    if (this.addSpecial(SoftFluidList.POTION, 1, newCom)) {
                        return new ItemStack((IItemProvider)Items.field_151069_bo);
                    }
                }
                return ItemStack.field_190927_a;
            }
            if (item2 instanceof SuspiciousStewItem && com.func_150297_b("Effects", 9)) {
                ListNBT listnbt = com.func_150295_c("Effects", 10);
                CompoundNBT newCom = new CompoundNBT();
                newCom.func_218657_a("Effects", (INBT)listnbt);
                if (this.addSpecial(SoftFluidList.SUS_STEW, 2, newCom)) {
                    return new ItemStack((IItemProvider)Items.field_151054_z);
                }
            }
        }
        return null;
    }

    private void applyFluidNBT(FluidStack fluidStack) {
        if (this.nbt != null && !this.nbt.isEmpty()) {
            fluidStack.setTag(this.nbt.func_74737_b());
        }
    }

    public boolean interactWithPlayer(PlayerEntity player, Hand hand) {
        ItemStack handStack = player.func_184586_b(hand);
        ItemStack returnStack = this.interactWithItem(handStack);
        if (returnStack == null) {
            CommonUtil.swapItem(player, hand, ItemStack.field_190927_a);
            return true;
        }
        if (!returnStack.func_190926_b()) {
            CommonUtil.swapItem(player, hand, returnStack);
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)handStack.func_77973_b()));
            return true;
        }
        return false;
    }

    @Nullable
    public ItemStack interactWithItem(ItemStack stack) {
        ItemStack returnStack;
        SoundEvent sound;
        ItemStack specialCase = this.handleNBTItems(stack);
        if (specialCase != null) {
            if (this.world != null && !this.world.field_72995_K && this.pos != null && !specialCase.func_190926_b()) {
                this.world.func_184133_a(null, this.pos, SoundEvents.field_191241_J, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return specialCase;
        }
        Item i = stack.func_77973_b();
        if (i == this.fluid.getEmptyBottle()) {
            sound = SoundEvents.field_187615_H;
            returnStack = this.fillBottle();
        } else if (i == Items.field_151054_z) {
            sound = SoundEvents.field_187615_H;
            returnStack = this.fillBowl();
        } else if (i == Items.field_151133_ar) {
            sound = this.fluid.getFillSound();
            returnStack = this.fillBucket();
        } else {
            returnStack = this.drainItem(stack);
            SoundEvent soundEvent = sound = returnStack == null || returnStack.func_77973_b() == Items.field_151133_ar ? this.fluid.getEmptySound() : SoundEvents.field_191241_J;
        }
        if (!(this.world == null || this.world.field_72995_K || returnStack != null && returnStack.func_190926_b() || i == Items.field_190931_a)) {
            this.world.func_184133_a(null, this.pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return returnStack;
    }

    @Nonnull
    public ItemStack fillBottle() {
        if (this.canRemove(1) && (this.fluid.hasBottle() || this.fluid == SoftFluidList.WATER)) {
            ItemStack stack = new ItemStack((IItemProvider)this.fluid.getBottle());
            if (this.fluid == SoftFluidList.WATER) {
                stack = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b);
            }
            this.applyNBT(stack);
            this.shrink(1);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack fillBucket() {
        if (this.canRemove(4) && this.fluid.hasBucket()) {
            ItemStack stack = new ItemStack((IItemProvider)this.fluid.getBucket());
            this.applyNBT(stack);
            this.shrink(4);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack fillBowl() {
        if (this.canRemove(2) && this.fluid.hasBowl()) {
            ItemStack stack = new ItemStack((IItemProvider)this.fluid.getBowl());
            this.applyNBT(stack);
            this.shrink(2);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    public ItemStack drainItem(ItemStack stack) {
        Item i = stack.func_77973_b();
        if (this.isEmpty()) {
            SoftFluid s = SoftFluidList.fromItem(i);
            if (PotionUtils.func_185191_c((ItemStack)stack) == Potions.field_185230_b) {
                s = SoftFluidList.WATER;
            }
            if (s.isEmpty()) {
                return ItemStack.field_190927_a;
            }
            this.setFluid(s);
        }
        if (this.fluid.hasBottle(i) && this.canAdd(1)) {
            this.grow(1);
            ItemStack returnStack = new ItemStack((IItemProvider)this.fluid.getEmptyBottle());
            if (returnStack.func_190926_b()) {
                return null;
            }
            return returnStack;
        }
        if (this.fluid.hasBowl(i) && this.canAdd(2)) {
            this.grow(2);
            return new ItemStack((IItemProvider)Items.field_151054_z);
        }
        if (this.fluid.hasBucket(i) && this.canAdd(4)) {
            this.grow(4);
            return new ItemStack((IItemProvider)Items.field_151133_ar);
        }
        if (this.canAdd(1) && PotionUtils.func_185191_c((ItemStack)stack) == Potions.field_185230_b) {
            this.grow(1);
            return new ItemStack((IItemProvider)Items.field_151069_bo);
        }
        return ItemStack.field_190927_a;
    }

    public boolean isSameFluidAs(FluidStack fluidStack, CompoundNBT com) {
        return this.fluid.isEquivalent(fluidStack.getFluid()) && com.equals((Object)this.nbt);
    }

    public boolean isSameFluidAs(FluidStack fluidStack) {
        return this.fluid.isEquivalent(fluidStack.getFluid()) && fluidStack.getOrCreateTag().equals((Object)this.nbt);
    }

    public boolean isSameAs(SoftFluid other) {
        return this.fluid.equals(other) && this.nbt.isEmpty();
    }

    public boolean isSameAs(SoftFluidHolder other) {
        return this.fluid.equals(other.getFluid()) && this.nbt.equals((Object)other.getNbt());
    }

    public boolean tryAddingFluid(SoftFluid s) {
        if (this.canAdd(1)) {
            if (this.isEmpty()) {
                this.setFluid(s);
                this.grow(1);
                return true;
            }
            if (this.isSameAs(s)) {
                this.grow(1);
                return true;
            }
        }
        return false;
    }

    public boolean tryTransferFluid(SoftFluidHolder other) {
        return this.tryTransferFluid(other, 1);
    }

    public boolean tryTransferFluid(SoftFluidHolder other, int amount) {
        if (other.canAdd(amount) && this.canRemove(amount)) {
            if (other.isEmpty()) {
                other.setFluid(this.getFluid(), this.getNbt());
                this.shrink(amount);
                other.grow(amount);
                return true;
            }
            if (this.isSameAs(other)) {
                this.shrink(amount);
                other.grow(amount);
                return true;
            }
        }
        return false;
    }

    public boolean fillFluidTank(IFluidHandler fluidDestination, int bottles) {
        int fillableAmount;
        if (!this.canRemove(bottles)) {
            return false;
        }
        int milliBuckets = bottles * 250;
        FluidStack stack = this.toFluid(milliBuckets);
        if (!stack.isEmpty() && (fillableAmount = fluidDestination.fill(stack, IFluidHandler.FluidAction.SIMULATE)) == milliBuckets) {
            fluidDestination.fill(stack, IFluidHandler.FluidAction.EXECUTE);
            this.shrink(bottles);
            return true;
        }
        return false;
    }

    public boolean fillFluidTank(IFluidHandler fluidDestination) {
        return this.fillFluidTank(fluidDestination, 1);
    }

    public boolean drainFluidTank(IFluidHandler fluidSource, int bottles) {
        if (!this.canAdd(bottles)) {
            return false;
        }
        int milliBuckets = bottles * 250;
        FluidStack drainable = fluidSource.drain(milliBuckets, IFluidHandler.FluidAction.SIMULATE);
        if (!drainable.isEmpty() && drainable.getAmount() == milliBuckets) {
            boolean transfer = false;
            CompoundNBT fsTag = drainable.getOrCreateTag();
            if (this.fluid.isEmpty()) {
                this.setFluid(SoftFluidList.fromFluid(drainable.getFluid()), drainable.getOrCreateTag());
                transfer = true;
            } else if (this.isSameFluidAs(drainable, fsTag)) {
                transfer = true;
            }
            if (transfer) {
                fluidSource.drain(milliBuckets, IFluidHandler.FluidAction.EXECUTE);
                this.grow(bottles);
                return true;
            }
        }
        return false;
    }

    public boolean drainFluidTank(IFluidHandler fluidSource) {
        return this.drainFluidTank(fluidSource, 1);
    }

    public FluidStack toFluid(int mb) {
        FluidStack stack = new FluidStack(this.fluid.getFluid(), mb);
        this.applyFluidNBT(stack);
        return stack;
    }

    public boolean canRemove(int i) {
        return this.count >= i && !this.isEmpty();
    }

    public boolean canAdd(int i) {
        return this.count + i <= this.capacity;
    }

    public boolean isFull() {
        return this.count == this.capacity;
    }

    public boolean isEmpty() {
        return this.fluid.isEmpty() || this.count <= 0;
    }

    public void lossyAdd(int inc) {
        this.count = Math.min(this.capacity, this.count + inc);
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int inc) {
        this.count = inc;
    }

    public void fillCount() {
        this.count = this.capacity;
    }

    public void grow(int inc) {
        this.setCount(this.count + inc);
    }

    public void shrink(int inc) {
        this.grow(-inc);
        if (this.count == 0) {
            this.fluid = SoftFluidList.EMPTY;
        }
    }

    public float getHeight() {
        return 0.75f * (float)this.count / (float)this.capacity;
    }

    public int getComparator() {
        float f = (float)this.count / (float)this.capacity;
        return MathHelper.func_76141_d((float)(f * 14.0f)) + 1;
    }

    @Nonnull
    public SoftFluid getFluid() {
        return this.fluid;
    }

    public CompoundNBT getNbt() {
        return this.nbt;
    }

    public void setNbt(CompoundNBT nbt) {
        this.nbt = nbt;
    }

    public void clear() {
        this.fluid = SoftFluidList.EMPTY;
        this.setCount(0);
        this.nbt = new CompoundNBT();
        this.specialColor = 0;
    }

    public void copy(SoftFluidHolder other) {
        this.setFluid(other.getFluid(), other.getNbt());
        this.setCount(Math.min(this.capacity, other.getCount()));
    }

    public void fill(FluidStack fluidStack) {
        this.setFluid(fluidStack);
        this.setCount(this.capacity);
    }

    public void fill(SoftFluid fluid) {
        this.fill(fluid, new CompoundNBT());
    }

    public void fill(SoftFluid fluid, CompoundNBT nbt) {
        this.setFluid(fluid, nbt);
        this.setCount(this.capacity);
    }

    public void setFluid(FluidStack fluidStack) {
        SoftFluid s = SoftFluidList.fromFluid(fluidStack.getFluid());
        this.setFluid(s, fluidStack.getOrCreateTag());
    }

    public void setFluid(SoftFluid fluid) {
        this.setFluid(fluid, new CompoundNBT());
    }

    public void setFluid(SoftFluid fluid, CompoundNBT nbt) {
        this.fluid = fluid;
        this.nbt = nbt;
        this.specialColor = 0;
        if (fluid == SoftFluidList.WATER) {
            if (this.world != null && this.world.field_72995_K && this.pos != null) {
                this.specialColor = BiomeColors.func_228363_c_((IBlockDisplayReader)this.world, (BlockPos)this.pos);
            }
        } else if (fluid == SoftFluidList.POTION) {
            Potion potion = PotionUtils.func_185187_c((CompoundNBT)this.nbt);
            this.specialColor = PotionUtils.func_185183_a((Potion)potion);
        }
    }

    public boolean isFood() {
        return this.fluid.isFood();
    }

    public ItemStack getFood() {
        ItemStack stack = new ItemStack((IItemProvider)this.fluid.getFoodItem());
        this.applyNBT(stack);
        return stack;
    }

    public int getTintColor() {
        if (this.specialColor != 0) {
            return this.specialColor;
        }
        return this.fluid.getTintColor();
    }

    public int getParticleColor() {
        if (this.isEmpty()) {
            return -1;
        }
        int tintColor = this.getTintColor();
        if (tintColor == -1) {
            return FluidColors.get(this.fluid.getID());
        }
        return tintColor;
    }

    public void read(CompoundNBT compound) {
        if (compound.func_74764_b("FluidHolder")) {
            CompoundNBT cmp = compound.func_74775_l("FluidHolder");
            this.count = cmp.func_74762_e("Count");
            this.nbt = cmp.func_74775_l("NBT");
            this.setFluid(SoftFluidList.fromID(cmp.func_74779_i("Fluid")), this.nbt);
        }
    }

    public CompoundNBT write(CompoundNBT compound) {
        CompoundNBT cmp = new CompoundNBT();
        cmp.func_74768_a("Count", this.count);
        cmp.func_74778_a("Fluid", this.fluid.getID());
        cmp.func_74768_a("CachedColor", this.getTintColor());
        if (!this.nbt.isEmpty()) {
            cmp.func_218657_a("NBT", (INBT)this.nbt);
        }
        compound.func_218657_a("FluidHolder", (INBT)cmp);
        return compound;
    }

    public boolean drinkUpFluid(PlayerEntity player, World world, Hand hand) {
        if (this.isEmpty()) {
            return false;
        }
        ItemStack stack = this.getFood();
        Item item2 = stack.func_77973_b();
        boolean success = false;
        Food food = item2.func_219967_s();
        int div = this.fluid.getFoodDivider();
        if (div == 1) {
            stack.func_77973_b().func_77654_b(stack.func_77946_l(), world, (LivingEntity)player);
            if (world.field_72995_K) {
                return true;
            }
            this.shrink(1);
            if (food == null || stack.func_77973_b().func_219971_r()) {
                player.func_213823_a(item2.func_225520_U__(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            return true;
        }
        if (food != null && player.func_71043_e(false)) {
            if (item2 instanceof SuspiciousStewItem) {
                SoftFluidHolder.susStewBehavior(player, stack, div);
            }
            if (world.field_72995_K) {
                return true;
            }
            player.func_71024_bL().func_75122_a(food.func_221466_a() / div, food.func_221469_b() / (float)div);
            success = true;
        } else if (item2 instanceof PotionItem) {
            if (world.field_72995_K) {
                return true;
            }
            for (EffectInstance effectinstance : PotionUtils.func_185189_a((ItemStack)stack)) {
                if (effectinstance.func_188419_a().func_76403_b()) {
                    effectinstance.func_188419_a().func_180793_a((Entity)player, (Entity)player, (LivingEntity)player, effectinstance.func_76458_c(), 1.0);
                    continue;
                }
                player.func_195064_c(new EffectInstance(effectinstance));
            }
            success = true;
        } else if (item2 instanceof MilkBucketItem || item2.getRegistryName().toString().equals("farmersdelight:hot_cocoa")) {
            if (world.field_72995_K) {
                return true;
            }
            SoftFluidHolder.milkBottleBehavior(player, stack);
            success = true;
        }
        if (success) {
            this.shrink(1);
            player.func_213823_a(item2.func_225520_U__(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public static void susStewBehavior(PlayerEntity player, ItemStack stack, int div) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("Effects", 9)) {
            ListNBT listnbt = compoundnbt.func_150295_c("Effects", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                Effect effect;
                int j = 160;
                CompoundNBT compoundnbt1 = listnbt.func_150305_b(i);
                if (compoundnbt1.func_150297_b("EffectDuration", 3)) {
                    j = compoundnbt1.func_74762_e("EffectDuration") / div;
                }
                if ((effect = Effect.func_188412_a((int)compoundnbt1.func_74771_c("EffectId"))) == null) continue;
                player.func_195064_c(new EffectInstance(effect, j));
            }
        }
    }

    public static boolean milkBottleBehavior(PlayerEntity player, ItemStack stack) {
        for (EffectInstance effect : player.func_193076_bZ().values()) {
            if (!effect.isCurativeItem(stack)) continue;
            player.func_195063_d(effect.func_188419_a());
            return true;
        }
        return false;
    }

    public static void honeyBehavior(PlayerEntity player) {
        player.func_195063_d(Effects.field_76436_u);
    }

    public static int getLiquidCountFromItem(Item i) {
        if (i == Items.field_151069_bo) {
            return 1;
        }
        if (i == Items.field_151054_z) {
            return 2;
        }
        if (i == Items.field_151133_ar) {
            return 4;
        }
        return 0;
    }
}

