/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.fluids;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.client.renderers.FluidColors;
import net.mehvahdjukaar.supplementaries.fluids.SoftFluidList;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class SoftFluid {
    private final ResourceLocation stillTexture;
    private final ResourceLocation flowingTexture;
    private final int tintColor;
    private final List<Fluid> equivalentFluids;
    private final int luminosity;
    private final List<Item> filledBottles;
    private final List<Item> filledBuckets;
    private final List<Item> filledBowls;
    private final Item bottleReturnItem;
    private final Item foodItem;
    private final int foodDivider;
    private final SoundEvent fillSound;
    private final SoundEvent emptySound;
    private final String id;
    private final String translationKey;
    private final boolean isEmptyHand;

    public SoftFluid(Builder builder) {
        this.stillTexture = builder.stillTexture;
        this.flowingTexture = builder.flowingTexture;
        this.tintColor = builder.tintColor;
        this.equivalentFluids = builder.equivalentFluids;
        this.luminosity = builder.luminosity;
        this.filledBottles = builder.filledBottles;
        this.filledBuckets = builder.filledBuckets;
        this.filledBowls = builder.filledBowls;
        this.foodItem = builder.getOrCreateFood();
        this.foodDivider = Math.max(0, builder.foodDivider);
        this.fillSound = builder.fillSound;
        this.emptySound = builder.emptySound;
        this.id = builder.id;
        this.translationKey = builder.translationKey;
        this.bottleReturnItem = builder.bottleReturnItem;
        this.isEmptyHand = this.bottleReturnItem == Items.field_190931_a;
    }

    public int getFoodDivider() {
        return this.foodDivider;
    }

    public Item getFoodItem() {
        return this.foodItem;
    }

    public TranslationTextComponent getTranslatedName() {
        return new TranslationTextComponent(this.translationKey);
    }

    public String getName() {
        return this.getID();
    }

    public String toString() {
        return this.getID();
    }

    public String getString() {
        return this.getID();
    }

    public Fluid getFluid() {
        Iterator<Fluid> iterator = this.equivalentFluids.iterator();
        if (iterator.hasNext()) {
            Fluid fluid = iterator.next();
            return fluid;
        }
        return Fluids.field_204541_a;
    }

    public boolean isEquivalent(Fluid fluid) {
        return this.equivalentFluids.contains(fluid);
    }

    public String getID() {
        return this.id;
    }

    public boolean isEmpty() {
        return this == SoftFluidList.EMPTY;
    }

    public boolean hasBucket(Item item2) {
        return this.filledBuckets.contains(item2);
    }

    public boolean hasBowl(Item item2) {
        return this.filledBowls.contains(item2);
    }

    public boolean hasBottle(Item item2) {
        return this.filledBottles.contains(item2);
    }

    public boolean hasBucket() {
        return !this.filledBuckets.isEmpty();
    }

    public boolean hasBowl() {
        return !this.filledBowls.isEmpty();
    }

    public boolean hasBottle() {
        return !this.filledBottles.isEmpty();
    }

    public int getLuminosity() {
        return this.luminosity;
    }

    public int getTintColor() {
        return this.tintColor;
    }

    public boolean isColored() {
        return this.tintColor != -1;
    }

    public int getParticleColor() {
        if (!this.isColored()) {
            return FluidColors.get(this.id);
        }
        return this.tintColor;
    }

    public Item getEmptyBottle() {
        return this.bottleReturnItem;
    }

    public Collection<Item> getBowls() {
        return this.filledBowls;
    }

    public Collection<Item> getBuckets() {
        return this.filledBuckets;
    }

    public Collection<Item> getBottles() {
        return this.filledBottles;
    }

    @Nullable
    public Item getBottle() {
        Iterator<Item> iterator = this.filledBottles.iterator();
        if (iterator.hasNext()) {
            Item item2 = iterator.next();
            return item2;
        }
        return null;
    }

    @Nullable
    public Item getBowl() {
        Iterator<Item> iterator = this.filledBowls.iterator();
        if (iterator.hasNext()) {
            Item item2 = iterator.next();
            return item2;
        }
        return null;
    }

    @Nullable
    public Item getBucket() {
        Iterator<Item> iterator = this.filledBuckets.iterator();
        if (iterator.hasNext()) {
            Item item2 = iterator.next();
            return item2;
        }
        return null;
    }

    public ResourceLocation getFlowingTexture() {
        return this.flowingTexture;
    }

    public ResourceLocation getStillTexture() {
        return this.stillTexture;
    }

    public SoundEvent getEmptySound() {
        return this.emptySound;
    }

    public SoundEvent getFillSound() {
        return this.fillSound;
    }

    public boolean isFood() {
        return this.foodItem != Items.field_190931_a;
    }

    public static class Builder {
        private ResourceLocation stillTexture;
        private ResourceLocation flowingTexture;
        private String translationKey = "fluid.supplementaries.jar_fluid";
        private int tintColor = -1;
        private int luminosity = 0;
        private final List<Item> filledBottles = new ArrayList<Item>();
        private final List<Item> filledBuckets = new ArrayList<Item>();
        private final List<Item> filledBowls = new ArrayList<Item>();
        private Item bottleReturnItem = Items.field_151069_bo;
        private Item foodItem = Items.field_190931_a;
        private int foodDivider = 1;
        private SoundEvent fillSound = SoundEvents.field_187630_M;
        private SoundEvent emptySound = SoundEvents.field_187624_K;
        private String id;
        public boolean isDisabled = false;
        private final List<Fluid> equivalentFluids = new ArrayList<Fluid>();

        public Builder(ResourceLocation stillTexture, ResourceLocation flowingTexture, String id) {
            this.stillTexture = stillTexture;
            this.flowingTexture = flowingTexture;
            this.id = "supplementaries:" + id;
        }

        public Builder(Fluid fluid) {
            FluidAttributes att = fluid.getAttributes();
            this.stillTexture = att.getStillTexture();
            this.flowingTexture = att.getFlowingTexture();
            this.color(att.getColor());
            this.bucket(fluid.func_204524_b());
            this.luminosity = att.getLuminosity();
            this.translationKey = att.getTranslationKey();
            this.addEqFluid(fluid);
            this.id = fluid.getRegistryName().toString();
        }

        public Builder(String fluidRes) {
            if (ForgeRegistries.FLUIDS.containsKey(new ResourceLocation(fluidRes))) {
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidRes));
                if (fluid != null && fluid != Fluids.field_204541_a) {
                    FluidAttributes att = fluid.getAttributes();
                    this.stillTexture = att.getStillTexture();
                    this.flowingTexture = att.getFlowingTexture();
                    this.color(att.getColor());
                    this.bucket(fluid.func_204524_b());
                    this.luminosity = att.getLuminosity();
                    this.translationKey = att.getTranslationKey();
                    this.addEqFluid(fluid);
                    this.id = fluid.getRegistryName().toString();
                } else {
                    this.isDisabled = true;
                }
            } else {
                this.isDisabled = true;
            }
        }

        public final Builder textures(ResourceLocation still, ResourceLocation flow) {
            this.stillTexture = still;
            this.flowingTexture = flow;
            return this;
        }

        public final Builder translationKey(String translationKey) {
            this.translationKey = translationKey == null ? "fluid.supplementaries.jar_fluid" : translationKey;
            return this;
        }

        public final Builder color(int tintColor) {
            this.tintColor = tintColor;
            return this;
        }

        public final Builder luminosity(int luminosity) {
            this.luminosity = luminosity;
            return this;
        }

        public final Builder addEqFluid(ResourceLocation fluidRes) {
            Fluid f;
            if (ForgeRegistries.FLUIDS.containsKey(fluidRes) && (f = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidRes)) != null && f != Fluids.field_204541_a) {
                this.equivalentFluids.add(f);
                Item i = f.func_204524_b();
                if (i != null && i != Items.field_190931_a) {
                    this.bucket(i);
                }
            }
            return this;
        }

        public final Builder addEqFluid(String res) {
            this.addEqFluid(new ResourceLocation(res));
            return this;
        }

        public final Builder addEqFluid(Fluid fluid) {
            this.addEqFluid(fluid.getRegistryName());
            return this;
        }

        public final Builder textureOverrideF(String fluidRes) {
            Fluid f;
            if (ForgeRegistries.FLUIDS.containsKey(new ResourceLocation(fluidRes)) && (f = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidRes))) != null && f != Fluids.field_204541_a) {
                this.flowingTexture = f.getAttributes().getFlowingTexture();
            }
            return this;
        }

        public final Builder condition(String modId) {
            boolean bl = this.isDisabled = !ModList.get().isLoaded(modId);
            if (this.id == null) {
                this.id = modId;
            } else if (this.id.contains("supplementaries")) {
                this.id = this.id.replace("supplementaries", modId);
            }
            return this;
        }

        public final Builder textureOverride(String fluidRes, int newColor) {
            Fluid f;
            if (ForgeRegistries.FLUIDS.containsKey(new ResourceLocation(fluidRes)) && (f = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidRes))) != null && f != Fluids.field_204541_a) {
                this.flowingTexture = f.getAttributes().getFlowingTexture();
                this.stillTexture = f.getAttributes().getStillTexture();
                this.color(newColor);
            }
            return this;
        }

        public final Builder textureOverride(String fluidRes) {
            Fluid f;
            if (ForgeRegistries.FLUIDS.containsKey(new ResourceLocation(fluidRes)) && (f = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidRes))) != null && f != Fluids.field_204541_a) {
                this.flowingTexture = f.getAttributes().getFlowingTexture();
                this.stillTexture = f.getAttributes().getStillTexture();
            }
            return this;
        }

        public final Builder bottle(Item item2) {
            if (item2 != null && item2 != Items.field_190931_a) {
                this.filledBottles.add(item2);
            }
            return this;
        }

        public final Builder bottle(ResourceLocation itemRes) {
            Item i;
            if (ForgeRegistries.ITEMS.containsKey(itemRes) && (i = (Item)ForgeRegistries.ITEMS.getValue(itemRes)) != null) {
                this.bottle(i);
            }
            return this;
        }

        public final Builder bottle(String res) {
            return this.bottle(new ResourceLocation(res));
        }

        public final Builder drink(String res) {
            return this.bottle(res).food(res);
        }

        public final Builder bucket(Item item2) {
            if (item2 != null && item2 != Items.field_190931_a) {
                this.filledBuckets.add(item2);
            }
            return this;
        }

        public final Builder bucket(ResourceLocation itemRes) {
            Item i;
            if (ForgeRegistries.ITEMS.containsKey(itemRes) && (i = (Item)ForgeRegistries.ITEMS.getValue(itemRes)) != null) {
                this.bucket(i);
            }
            return this;
        }

        public final Builder bucket(String res) {
            return this.bucket(new ResourceLocation(res));
        }

        public final Builder bowl(Item item2) {
            if (item2 != null && item2 != Items.field_190931_a) {
                this.filledBowls.add(item2);
                this.translationKey(item2.func_77658_a());
            }
            return this;
        }

        public final Builder bowl(ResourceLocation itemRes) {
            Item i;
            if (ForgeRegistries.ITEMS.containsKey(itemRes) && (i = (Item)ForgeRegistries.ITEMS.getValue(itemRes)) != null) {
                this.bowl(i);
            }
            return this;
        }

        public final Builder bowl(String res) {
            return this.bowl(new ResourceLocation(res));
        }

        public final Builder fillSound(SoundEvent sound) {
            this.fillSound = sound;
            return this;
        }

        public final Builder emptySound(SoundEvent sound) {
            this.emptySound = sound;
            return this;
        }

        public final Builder sound(SoundEvent fill, SoundEvent empty) {
            this.emptySound = empty;
            this.fillSound = fill;
            return this;
        }

        public final Builder specialEmptyBottle(Item item2) {
            this.bottleReturnItem = item2;
            return this;
        }

        public final Builder food(Item item2) {
            if (item2 != null && item2 != Items.field_190931_a) {
                this.foodItem = item2;
            }
            return this;
        }

        public final Builder food(ResourceLocation itemRes) {
            Item i;
            if (ForgeRegistries.ITEMS.containsKey(itemRes) && (i = (Item)ForgeRegistries.ITEMS.getValue(itemRes)) != null) {
                this.food(i);
            }
            return this;
        }

        public final Builder food(String res) {
            return this.food(new ResourceLocation(res));
        }

        public final Builder food(Item item2, int divider) {
            this.foodDivider = divider;
            return this.food(item2);
        }

        public final Builder food(String res, int divider) {
            this.foodDivider = divider;
            return this.food(res);
        }

        protected Item getOrCreateFood() {
            for (Item i : this.filledBuckets) {
                if (!i.func_219971_r()) continue;
                this.foodItem = i;
                this.foodDivider = 4;
                break;
            }
            for (Item i : this.filledBowls) {
                if (!i.func_219971_r()) continue;
                this.foodItem = i;
                this.foodDivider = 2;
                break;
            }
            for (Item i : this.filledBottles) {
                if (!i.func_219971_r()) continue;
                this.foodItem = i;
                this.foodDivider = 1;
                break;
            }
            return this.foodItem;
        }
    }
}

