/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.entities;

import java.util.Random;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.BlockState;
import net.minecraft.block.TNTBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class BombEntity
extends ProjectileItemEntity
implements IRendersAsItem,
IEntityAdditionalSpawnData {
    private double prevX = 0.0;
    private double prevY = 0.0;
    private double prevZ = 0.0;
    private int age = 0;
    private boolean active = true;
    private boolean superCharged = false;
    private int changeTimer = -1;
    private boolean blue = false;

    public BombEntity(EntityType<? extends BombEntity> type, World world) {
        super(type, world);
        this.prevX = this.func_226277_ct_();
        this.prevY = this.func_226278_cu_();
        this.prevZ = this.func_226281_cx_();
    }

    public BombEntity(World worldIn, LivingEntity throwerIn, boolean blue) {
        super((EntityType)Registry.BOMB.get(), throwerIn, worldIn);
        this.prevX = this.func_226277_ct_();
        this.prevY = this.func_226278_cu_();
        this.prevZ = this.func_226281_cx_();
        this.blue = blue;
    }

    public BombEntity(World worldIn, double x, double y, double z) {
        super((EntityType)Registry.BOMB.get(), x, y, z, worldIn);
    }

    public BombEntity(FMLPlayMessages.SpawnEntity packet, World world) {
        super((EntityType)Registry.BOMB.get(), world);
        this.prevX = this.func_226277_ct_();
        this.prevY = this.func_226278_cu_();
        this.prevZ = this.func_226281_cx_();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Active", this.active);
        compound.func_74768_a("Age", this.age);
        compound.func_74757_a("Blue", this.blue);
        compound.func_74768_a("Timer", this.changeTimer);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.active = compound.func_74767_n("Active");
        this.age = compound.func_74762_e("Age");
        this.blue = compound.func_74767_n("Blue");
        this.changeTimer = compound.func_74762_e("Timer");
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.blue = buffer.readBoolean();
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeBoolean(this.blue);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected Item func_213885_i() {
        return Items.field_221840_ed;
    }

    public ItemStack func_184543_l() {
        return new ItemStack(this.active ? (IItemProvider)Registry.BOMB_ITEM_ON.get() : (IItemProvider)Registry.BOMB_ITEM.get());
    }

    private IParticleData makeParticle() {
        return new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)Registry.BOMB_ITEM.get()));
    }

    public void func_70103_a(byte id) {
        if (id == 3) {
            IParticleData iparticledata = this.makeParticle();
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_195594_a(iparticledata, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
    }

    public double r() {
        return ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.3;
    }

    public void func_70071_h_() {
        if (this.changeTimer == 0) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_195594_a((IParticleData)Registry.BOMB_EXPLOSION_PARTICLE_EMITTER.get(), this.func_213303_ch().field_72450_a, this.func_213303_ch().field_72448_b + 1.0, this.func_213303_ch().field_72449_c, 6.0, 0.0, 0.0);
            } else {
                this.explodeOrBreak();
            }
            return;
        }
        if (this.changeTimer > 0) {
            --this.changeTimer;
        }
        if (this.active && this.func_70090_H() && !this.blue) {
            this.turnOff();
        }
        if (this.field_70170_p.field_72995_K && this.active) {
            if (this.field_70146_Z.nextFloat() < 1.0f) {
                double x = this.func_226277_ct_();
                double y = this.func_226278_cu_();
                double z = this.func_226281_cx_();
                double x2 = x - this.prevX;
                double y2 = y - this.prevY;
                double z2 = z - this.prevZ;
                this.field_70170_p.func_195594_a((IParticleData)Registry.BOMB_SMOKE_PARTICLE.get(), x + this.r(), y + 0.5 + this.r(), z + this.r(), 0.0, 0.01, 0.0);
                this.field_70170_p.func_195594_a((IParticleData)Registry.BOMB_SMOKE_PARTICLE.get(), x + x2 / 2.0 + this.r(), 0.5 + y + y2 / 2.0, z + z2 / 2.0 + this.r(), 0.0, 0.0, 0.0);
                this.field_70170_p.func_195594_a((IParticleData)Registry.BOMB_SMOKE_PARTICLE.get(), x + x2 / 4.0 + this.r(), 0.5 + y + y2 / 4.0, z + z2 / 4.0 + this.r(), 0.0, 0.0, 0.0);
                this.field_70170_p.func_195594_a((IParticleData)Registry.BOMB_SMOKE_PARTICLE.get(), x + x2 * 0.75 + this.r(), 0.5 + y + y2 * 0.75, z + z2 * 0.75 + this.r(), 0.0, 0.0, 0.0);
            }
            this.prevX = this.func_226277_ct_();
            this.prevY = this.func_226278_cu_();
            this.prevZ = this.func_226281_cx_();
        } else {
            ++this.age;
            if (this.age >= 200) {
                this.explode();
            }
        }
        super.func_70071_h_();
    }

    protected float func_70185_h() {
        return 0.05f;
    }

    public static boolean canBreakBlock(IBlockReader world, BlockPos pos, BlockState state, float power) {
        return state.func_227032_a_((Fluid)Fluids.field_204546_a) || state.func_177230_c() instanceof TNTBlock;
    }

    public void explode() {
        Explosion explosion = new Explosion(this.field_70170_p, (Entity)this, null, new ExplosionContext(){

            public boolean func_230311_a_(Explosion explosion, IBlockReader reader, BlockPos pos, BlockState state, float power) {
                return BombEntity.canBreakBlock(reader, pos, state, power);
            }
        }, this.func_226277_ct_(), this.func_226278_cu_() + 0.25, this.func_226281_cx_(), this.blue ? 6.0f : 2.0f, false, Explosion.Mode.BREAK);
        explosion.func_77278_a();
        explosion.func_77279_a(false);
        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)Registry.BOMB_SOUND.get(), SoundCategory.NEUTRAL, this.blue ? 5.0f : 3.0f, 1.2f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f);
    }

    public void explodeOrBreak() {
        if (this.active) {
            this.explode();
        }
        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_232775_jf_, SoundCategory.NEUTRAL, 1.5f, 1.5f);
        this.field_70170_p.func_72960_a((Entity)this, (byte)3);
        this.func_70106_y();
    }

    protected void func_213868_a(EntityRayTraceResult hit) {
        super.func_213868_a(hit);
        hit.func_216348_a().func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_234616_v_()), 1.0f);
        if (hit.func_216348_a() instanceof FireballEntity) {
            this.superCharged = true;
            hit.func_216348_a().func_70106_y();
        }
    }

    public void turnOff() {
        if (!this.field_70170_p.func_201670_d()) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 0.5f, 1.5f);
        } else {
            Random random = this.field_70170_p.func_201674_k();
            for (int i = 0; i < 10; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() + 0.25 - (double)(random.nextFloat() * 0.5f), this.func_226278_cu_() + (double)0.45f - (double)(random.nextFloat() * 0.5f), this.func_226281_cx_() + 0.25 - (double)(random.nextFloat() * 0.5f), 0.0, 0.005, 0.0);
            }
        }
        this.active = false;
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        if (!this.field_70170_p.field_72995_K && !this.active && entityIn.field_71071_by.func_70441_a(this.getItemStack())) {
            entityIn.func_71001_a((Entity)this, 1);
            this.func_70106_y();
        }
    }

    private ItemStack getItemStack() {
        return new ItemStack((IItemProvider)Registry.BOMB_ITEM.get());
    }

    protected void func_230299_a_(BlockRayTraceResult hit) {
        super.func_230299_a_(hit);
        Vector3d vector3d = hit.func_216347_e().func_178786_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        this.func_213317_d(vector3d);
        Vector3d vector3d1 = vector3d.func_72432_b().func_186678_a((double)0.05f);
        this.func_226288_n_(this.func_226277_ct_() - vector3d1.field_72450_a, this.func_226278_cu_() - vector3d1.field_72448_b, this.func_226281_cx_() - vector3d1.field_72449_c);
    }

    protected void func_70227_a(RayTraceResult result) {
        super.func_70227_a(result);
        Vector3d v = result.func_216347_e();
        if (this.blue && this.changeTimer == -1) {
            this.changeTimer = 10;
            this.func_213317_d(Vector3d.field_186680_a);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.superCharged) {
                boolean flag = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.func_234616_v_());
                this.field_70170_p.func_217398_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 6.0f, flag, flag ? Explosion.Mode.DESTROY : Explosion.Mode.NONE);
                this.func_70106_y();
            } else if (!this.field_70128_L && !this.blue) {
                this.explodeOrBreak();
            }
        } else if (this.active) {
            if (this.changeTimer == 10) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218419_B, v.field_72450_a, v.field_72448_b + 0.5, v.field_72449_c, 0.0, 0.0, 0.0);
            } else if (!this.blue) {
                this.field_70170_p.func_195594_a((IParticleData)Registry.BOMB_EXPLOSION_PARTICLE_EMITTER.get(), v.field_72450_a, v.field_72448_b + 0.5, v.field_72449_c, 2.2, 0.0, 0.0);
            }
        }
    }
}

