/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.datagen;

import java.util.function.Consumer;
import net.mehvahdjukaar.supplementaries.datagen.RecipeCondition;
import net.mehvahdjukaar.supplementaries.datagen.types.IWoodType;
import net.mehvahdjukaar.supplementaries.datagen.types.WoodTypes;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.registries.ForgeRegistries;

public class ModRecipeProvider
extends RecipeProvider {
    public ModRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumerIn) {
        for (IWoodType wood : WoodTypes.TYPES.values()) {
            ModRecipeProvider.makeSignPostRecipe(wood, consumerIn);
            ModRecipeProvider.makeHangingSignRecipe(wood, consumerIn);
        }
    }

    public static void makeConditionalRec(IFinishedRecipe r, IWoodType wood, Consumer<IFinishedRecipe> consumer, String name) {
        ConditionalRecipe.builder().addCondition((ICondition)new RecipeCondition(name, RecipeCondition.MY_FLAG)).addCondition((ICondition)new ModLoadedCondition(wood.getNamespace())).addRecipe(r).generateAdvancement().build(consumer, "supplementaries", name + "_" + wood.getRegName());
    }

    private static void makeSignPostRecipe(IWoodType wood, Consumer<IFinishedRecipe> consumer) {
        try {
            Item plank = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(wood.getPlankRegName()));
            Item sign = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(wood.getSignRegName()));
            if (plank == null || plank == Items.field_190931_a) {
                return;
            }
            if (sign != null && sign != Items.field_190931_a) {
                ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)Registry.SIGN_POST_ITEMS.get(wood).get()), (int)2).func_200487_b((IItemProvider)sign).func_200490_a("sign_post").func_200483_a("has_plank", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{plank})).func_200482_a(s -> ModRecipeProvider.makeConditionalRec(s, wood, consumer, "sign_post"));
            } else {
                ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)Registry.SIGN_POST_ITEMS.get(wood).get()), (int)3).func_200472_a("   ").func_200472_a("222").func_200472_a(" 1 ").func_200462_a(Character.valueOf('1'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('2'), (IItemProvider)plank).func_200473_b("sign_post").func_200465_a("has_plank", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{plank})).func_200464_a(s -> ModRecipeProvider.makeConditionalRec(s, wood, consumer, "sign_post"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void makeHangingSignRecipe(IWoodType wood, Consumer<IFinishedRecipe> consumer) {
        Item plank = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(wood.getPlankRegName()));
        if (plank == null || plank == Items.field_190931_a) {
            return;
        }
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)Registry.HANGING_SIGNS.get(wood).get()), (int)2).func_200472_a("010").func_200472_a("222").func_200472_a("222").func_200462_a(Character.valueOf('0'), (IItemProvider)Items.field_191525_da).func_200462_a(Character.valueOf('1'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('2'), (IItemProvider)plank).func_200473_b("hanging_sign").func_200465_a("has_plank", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{plank})).func_200464_a(s -> ModRecipeProvider.makeConditionalRec(s, wood, consumer, "hanging_sign"));
    }
}

