/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.datagen.BlockLootTableAccessor;
import net.mehvahdjukaar.supplementaries.datagen.types.IWoodType;
import net.mehvahdjukaar.supplementaries.datagen.types.WoodTypes;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.LootTableProvider;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class ModLootTableProvider
extends LootTableProvider {
    private final DataGenerator generator;
    protected final Map<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public ModLootTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
        this.generator = dataGeneratorIn;
    }

    public void func_200398_a(DirectoryCache cache) {
        for (IWoodType wood : WoodTypes.TYPES.values()) {
            this.addBlockLoot((Block)Registry.HANGING_SIGNS.get(wood).get());
        }
        this.saveTables(cache, this.tables);
    }

    public void saveTables(DirectoryCache cache, Map<ResourceLocation, LootTable> tables) {
        Path outputFolder = this.generator.func_200391_b();
        tables.forEach((key, lootTable) -> {
            Path path = outputFolder.resolve("data/" + key.func_110624_b() + "/loot_tables/" + key.func_110623_a() + ".json");
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)lootTable), (Path)path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    public void addBlockLoot(Block block2) {
        this.tables.put(block2.func_220068_i(), BlockLootTableAccessor.dropping((IItemProvider)block2).func_216039_a(LootParameterSets.field_216267_h).func_216038_b());
    }
}

