/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class FlowerPotHelper {
    private static Map<Block, Map<ResourceLocation, Supplier<? extends Block>>> FULL_POTS;

    public static Block getFullPot(FlowerPotBlock emptyPot, Block flowerBlock) {
        return FULL_POTS.get(emptyPot.getEmptyPot()).getOrDefault(flowerBlock.getRegistryName(), (Supplier<? extends Block>)Blocks.field_150350_a.delegate).get();
    }

    public static boolean isEmptyPot(Block b) {
        return FULL_POTS != null && b != null && FULL_POTS.containsKey(b);
    }

    public static void init() {
        HashSet<Object> emptyPots = new HashSet<Object>();
        for (Block block2 : ForgeRegistries.BLOCKS) {
            if (!(block2 instanceof FlowerPotBlock)) continue;
            emptyPots.add(((FlowerPotBlock)block2).getEmptyPot());
        }
        FULL_POTS = Maps.newHashMap();
        for (Block block3 : emptyPots) {
            try {
                Field f = ObfuscationReflectionHelper.findField(FlowerPotBlock.class, (String)"fullPots");
                f.setAccessible(true);
                FULL_POTS.put(block3, (Map)f.get(block3));
            }
            catch (Exception ignored) {
                Supplementaries.LOGGER.info("Failed to create flower pots");
            }
        }
        emptyPots.removeIf(pot -> !FULL_POTS.containsKey(pot));
    }
}

