/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.mehvahdjukaar.supplementaries.block.blocks.HourGlassBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.HourGlassBlockTile;
import net.mehvahdjukaar.supplementaries.client.renderers.RendererUtil;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;

public class HourGlassBlockTileRenderer
extends TileEntityRenderer<HourGlassBlockTile> {
    public HourGlassBlockTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public static void renderSand(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn, TextureAtlasSprite sprite, float height, Direction dir) {
        IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228639_c_());
        int color = 0xFFFFFF;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
        Quaternion q = dir.func_229384_a_();
        matrixStackIn.func_227863_a_(q);
        q.func_195892_e();
        if (height != 0.0f) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, -0.25, 0.0);
            matrixStackIn.func_227863_a_(q);
            matrixStackIn.func_227861_a_(0.0, -0.125, 0.0);
            float h1 = height * 0.25f;
            RendererUtil.addCube(builder, matrixStackIn, 0.375f, 0.3125f, 0.25f, h1, sprite, combinedLightIn, color, 1.0f, combinedOverlayIn, true, true, true, true);
            if (dir == Direction.DOWN) {
                matrixStackIn.func_227861_a_(0.0, (double)(-h1 - 0.25f), 0.0);
                RendererUtil.addCube(builder, matrixStackIn, 0.375f, 0.3125f, 0.0625f, h1 + 0.25f, sprite, combinedLightIn, color, 1.0f, combinedOverlayIn, true, true, true, false);
            }
            matrixStackIn.func_227865_b_();
        }
        if (height != 1.0f) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, 0.25, 0.0);
            matrixStackIn.func_227863_a_(q);
            matrixStackIn.func_227861_a_(0.0, -0.125, 0.0);
            float h2 = (1.0f - height) * 0.25f;
            RendererUtil.addCube(builder, matrixStackIn, 0.375f, 0.3125f, 0.25f, h2, sprite, combinedLightIn, color, 1.0f, combinedOverlayIn, true, true, true, true);
            if (dir == Direction.UP) {
                matrixStackIn.func_227861_a_(0.0, (double)(-h2) - 0.25, 0.0);
                RendererUtil.addCube(builder, matrixStackIn, 0.375f, 0.3125f, 0.0625f, h2 + 0.25f, sprite, combinedLightIn, color, 1.0f, combinedOverlayIn, true, true, true, false);
            }
            matrixStackIn.func_227865_b_();
        }
        matrixStackIn.func_227865_b_();
    }

    public void render(HourGlassBlockTile tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (tile.sandType.isEmpty()) {
            return;
        }
        TextureAtlasSprite sprite = tile.getOrCreateSprite();
        float h = MathHelper.func_219799_g((float)partialTicks, (float)tile.prevProgress, (float)tile.progress);
        Direction dir = (Direction)tile.func_195044_w().func_177229_b((Property)HourGlassBlock.FACING);
        HourGlassBlockTileRenderer.renderSand(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, sprite, h, dir);
    }
}

