/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.mehvahdjukaar.supplementaries.block.tiles.FlagBlockTile;
import net.mehvahdjukaar.supplementaries.client.renderers.Const;
import net.mehvahdjukaar.supplementaries.client.renderers.RendererUtil;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;

public class FlagBlockTileRenderer
extends TileEntityRenderer<FlagBlockTile> {
    public FlagBlockTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(FlagBlockTile tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228634_a_((ResourceLocation)new ResourceLocation("supplementaries:textures/entity/flag.png")));
        int lu = combinedLightIn & 0xFFFF;
        int lv = combinedLightIn >> 16 & 0xFFFF;
        int w = 24;
        int h = 16;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 0.0, 0.5);
        matrixStackIn.func_227863_a_(tile.getDirection().func_229384_a_());
        matrixStackIn.func_227863_a_(Const.XN90);
        matrixStackIn.func_227861_a_(0.0, 0.0, 0.0625);
        if (Minecraft.func_71410_x().field_71474_y.field_238330_f_.func_238162_a_() < 1) {
            float ang = 2.0f * MathHelper.func_76126_a((float)((tile.counter + partialTicks) / 35.0f % ((float)Math.PI * 2)));
            FlagBlockTileRenderer.renderCurvedSegment(builder, matrixStackIn, ang, 0, w, h, lu, lv, true, false);
        } else {
            boolean zAxis = tile.getDirection().func_176740_k().equals((Object)Direction.Axis.Z);
            float t = (tile.counter + partialTicks) / 20.0f;
            double l = (Double)ClientConfigs.block.FLAG_WAVELENGTH.get();
            double speed = (Double)ClientConfigs.block.FLAG_SPEED.get();
            double wavyness = (Double)ClientConfigs.block.FLAG_AMPLITUDE.get();
            double invdamping = (Double)ClientConfigs.block.FLAG_AMPLITUDE_INCREMENT.get();
            int segmentlen = 1;
            for (int z = 0; z < w; z += segmentlen) {
                float ang = (float)((wavyness + invdamping * (double)z) * (double)MathHelper.func_76126_a((float)((float)(((double)z / l - speed * (double)t) * 3.1415927410125732 % 6.2831854820251465))));
                FlagBlockTileRenderer.renderCurvedSegment(builder, matrixStackIn, ang, z, segmentlen, h, lu, lv, z + segmentlen >= w, zAxis);
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(ang));
                matrixStackIn.func_227861_a_(0.0, 0.0, (double)((float)segmentlen / 16.0f));
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-ang));
            }
        }
        matrixStackIn.func_227865_b_();
    }

    private static void renderCurvedSegment(IVertexBuilder builder, MatrixStack matrixStackIn, float angle, int posz, int lenght, int height, int lu, int lv, boolean end, boolean zAxis) {
        float textw = 32.0f;
        float u = (float)posz / textw;
        float v = 0.0f;
        float maxv = (float)height / 16.0f;
        float maxu = u + (float)lenght / textw;
        float w = 0.0625f;
        float hw = w / 2.0f;
        float l = (float)lenght / 16.0f;
        float h = (float)height / 16.0f;
        Quaternion rotation = Vector3f.field_229181_d_.func_229187_a_(angle);
        Quaternion rotation2 = Vector3f.field_229181_d_.func_229187_a_(-angle);
        int lus = (int)((float)lu * (zAxis ? 0.8f : 1.0f));
        int lvs = (int)((float)lv * (zAxis ? 0.8f : 1.0f));
        int nx = zAxis ? 0 : 1;
        boolean nz = zAxis;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_((double)hw, 0.0, 0.0);
        RendererUtil.addVert(builder, matrixStackIn, 0.0f, 0.0f, 0.0f, u, maxv, 1.0f, 1.0f, 1.0f, 1.0f, lus, lvs, nx, 0.0f, (float)nz);
        RendererUtil.addVert(builder, matrixStackIn, 0.0f, h, 0.0f, u, v, 1.0f, 1.0f, 1.0f, 1.0f, lus, lvs, nx, 0.0f, (float)nz);
        matrixStackIn.func_227863_a_(rotation);
        matrixStackIn.func_227861_a_(0.0, 0.0, (double)l);
        RendererUtil.addVert(builder, matrixStackIn, 0.0f, h, 0.0f, maxu, v, 1.0f, 1.0f, 1.0f, 1.0f, lus, lvs, nx, 0.0f, (float)nz);
        RendererUtil.addVert(builder, matrixStackIn, 0.0f, 0.0f, 0.0f, maxu, maxv, 1.0f, 1.0f, 1.0f, 1.0f, lus, lvs, nx, 0.0f, (float)nz);
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_((double)(-hw), 0.0, 0.0);
        RendererUtil.addVert(builder, matrixStackIn, 0.0f, h, 0.0f, u, v, 1.0f, 1.0f, 1.0f, 1.0f, lus, lvs, -nx, 0.0f, (float)nz);
        RendererUtil.addVert(builder, matrixStackIn, 0.0f, 0.0f, 0.0f, u, maxv, 1.0f, 1.0f, 1.0f, 1.0f, lus, lvs, -nx, 0.0f, (float)nz);
        matrixStackIn.func_227863_a_(rotation);
        matrixStackIn.func_227861_a_(0.0, 0.0, (double)l);
        RendererUtil.addVert(builder, matrixStackIn, 0.0f, 0.0f, 0.0f, maxu, maxv, 1.0f, 1.0f, 1.0f, 1.0f, lus, lvs, -nx, 0.0f, (float)nz);
        RendererUtil.addVert(builder, matrixStackIn, 0.0f, h, 0.0f, maxu, v, 1.0f, 1.0f, 1.0f, 1.0f, lus, lvs, -nx, 0.0f, (float)nz);
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_((double)hw, 0.0, 0.0);
        RendererUtil.addVert(builder, matrixStackIn, 0.0f, h, 0.0f, u, v, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
        matrixStackIn.func_227861_a_((double)(-w), 0.0, 0.0);
        RendererUtil.addVert(builder, matrixStackIn, 0.0f, h, 0.0f, u, w, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
        matrixStackIn.func_227863_a_(rotation);
        matrixStackIn.func_227861_a_(0.0, 0.0, (double)l);
        RendererUtil.addVert(builder, matrixStackIn, 0.0f, h, 0.0f, maxu, w, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
        matrixStackIn.func_227863_a_(rotation2);
        matrixStackIn.func_227861_a_((double)w, 0.0, 0.0);
        RendererUtil.addVert(builder, matrixStackIn, 0.0f, h, 0.0f, maxu, v, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_((double)(-hw), 0.0, 0.0);
        RendererUtil.addVert(builder, matrixStackIn, 0.0f, 0.0f, 0.0f, u, h - w, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, -1.0f, 0.0f, 0.0f);
        matrixStackIn.func_227861_a_((double)w, 0.0, 0.0);
        RendererUtil.addVert(builder, matrixStackIn, 0.0f, 0.0f, 0.0f, u, h, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, -1.0f, 0.0f);
        matrixStackIn.func_227863_a_(rotation);
        matrixStackIn.func_227861_a_(0.0, 0.0, (double)l);
        RendererUtil.addVert(builder, matrixStackIn, 0.0f, 0.0f, 0.0f, maxu, h, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, -1.0f, 0.0f);
        matrixStackIn.func_227863_a_(rotation2);
        matrixStackIn.func_227861_a_((double)(-w), 0.0, 0.0);
        RendererUtil.addVert(builder, matrixStackIn, 0.0f, 0.0f, 0.0f, maxu, h - w, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, -1.0f, 0.0f);
        matrixStackIn.func_227865_b_();
        if (end) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227863_a_(rotation);
            matrixStackIn.func_227861_a_(0.0, 0.0, (double)l);
            matrixStackIn.func_227863_a_(rotation2);
            matrixStackIn.func_227861_a_((double)(-hw), 0.0, 0.0);
            RendererUtil.addVert(builder, matrixStackIn, 0.0f, h, 0.0f, maxu - 1.0f / textw, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 0.0f, 1.0f);
            RendererUtil.addVert(builder, matrixStackIn, 0.0f, 0.0f, 0.0f, maxu - 1.0f / textw, maxv, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 0.0f, 1.0f);
            matrixStackIn.func_227861_a_((double)w, 0.0, 0.0);
            RendererUtil.addVert(builder, matrixStackIn, 0.0f, 0.0f, 0.0f, maxu, maxv, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 0.0f, 1.0f);
            RendererUtil.addVert(builder, matrixStackIn, 0.0f, h, 0.0f, maxu, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 0.0f, 1.0f);
            matrixStackIn.func_227865_b_();
        }
    }
}

