/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class CapturedMobs {
    public static final List<List<String>> DEFAULT_CONFIG = new ArrayList<List<String>>();
    public static final Map<String, CapturedMobProperties> TYPES = new HashMap<String, CapturedMobProperties>();
    public static final Map<Item, String> VALID_BUCKETS = new HashMap<Item, String>();
    public static final CapturedMobProperties DEFAULT = new CapturedMobProperties("69", 0.0f, 0.0f, 0, 0, Category.DEFAULT);
    public static final CapturedMobProperties MODDED_FISH = new CapturedMobProperties("420", 0.0f, 0.0f, 0, 1, Category.DEFAULT);

    private static List<String> addDef(String id, int fish) {
        return CapturedMobs.addDef(id, 0.0f, 0.125f, 0, fish);
    }

    private static List<String> addDef(String id, float h, float w, int l, int f) {
        return Arrays.asList(id, "" + h, "" + w, "" + l, "" + f);
    }

    private static List<String> addDef(String id, float h, float w, int l, Category c) {
        return Arrays.asList(id, "" + h, "" + w, "" + l, c.toString());
    }

    private static List<String> addDef(String id, float h, float w, int l) {
        return Arrays.asList(id, "" + h, "" + w, "" + l);
    }

    private static List<String> addDef(String id, float h, float w) {
        return Arrays.asList(id, "" + h, "" + w);
    }

    public static String getDefaultNameFromBucket(Item bucket) {
        String def = "Mob";
        String mobId = VALID_BUCKETS.getOrDefault(bucket, def);
        if (mobId.equals(def)) {
            return def;
        }
        EntityType en = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(mobId));
        if (en == null) {
            return def;
        }
        return en.func_212546_e().getString();
    }

    public static CapturedMobProperties getTypeFromBucket(Item bucket) {
        return CapturedMobs.getType(VALID_BUCKETS.getOrDefault(bucket, "minecraft:fish"));
    }

    public static CapturedMobProperties getType(Entity mob) {
        return CapturedMobs.getType(mob.func_200600_R().getRegistryName().toString());
    }

    public static CapturedMobProperties getType(String mobId) {
        return TYPES.getOrDefault(mobId, DEFAULT);
    }

    public static List<String> getFishes() {
        ArrayList<String> l = new ArrayList<String>();
        for (List<String> d : DEFAULT_CONFIG) {
            int f;
            if (d.size() != 5 || (f = CapturedMobs.strToInt(d.get(4))) <= 0 || d.get(0).equals("")) continue;
            l.add(d.get(0));
        }
        return l;
    }

    public static boolean isFishBucket(Item item2) {
        return VALID_BUCKETS.containsKey(item2);
    }

    private static float strToFloat(String s) {
        if (s != null && s.matches("[0-9.]+")) {
            return Float.parseFloat(s);
        }
        return 0.0f;
    }

    private static int strToInt(String s) {
        if (s != null && s.matches("[0-9.]+")) {
            return Integer.parseInt(s);
        }
        return 0;
    }

    public static void refresh() {
        TYPES.clear();
        List config = (List)ClientConfigs.block.CAPTURED_MOBS_PROPERTIES.get();
        for (List l : config) {
            try {
                Object type;
                int size = l.size();
                if (size < 2) continue;
                String id = (String)l.get(0);
                float h = CapturedMobs.strToFloat((String)l.get(1));
                float w = 0.0f;
                int light = 0;
                int fish = 0;
                Category cat = Category.DEFAULT;
                if (size > 2) {
                    w = CapturedMobs.strToFloat((String)l.get(2));
                }
                if (size > 3) {
                    light = CapturedMobs.strToInt((String)l.get(3));
                }
                if (size > 4) {
                    type = ((String)l.get(4)).toLowerCase();
                    switch (type) {
                        case "air": {
                            cat = Category.AIR;
                            break;
                        }
                        case "land": {
                            cat = Category.LAND;
                            break;
                        }
                        case "floating": {
                            cat = Category.FLOATING;
                            break;
                        }
                        default: {
                            fish = CapturedMobs.strToInt((String)type);
                            if (fish <= 0) break;
                            cat = Category.FISH;
                        }
                    }
                }
                type = new CapturedMobProperties(id, h, w, light, fish, cat);
                TYPES.put(id, (CapturedMobProperties)type);
            }
            catch (Exception e) {
                Supplementaries.LOGGER.warn("failed to load captured mob configs");
            }
        }
        List jarCatchable = (List)ServerConfigs.block.MOB_JAR_ALLOWED_MOBS.get();
        List jarCatchableTinted = (List)ServerConfigs.block.MOB_JAR_TINTED_ALLOWED_MOBS.get();
        for (String id : jarCatchable) {
            CapturedMobs.tryAddingValidBucket(id);
        }
        for (String id : jarCatchableTinted) {
            CapturedMobs.tryAddingValidBucket(id);
        }
    }

    public static void tryAddingValidBucket(String mobId) {
        ResourceLocation res = new ResourceLocation(mobId);
        Item bucket = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(res.func_110624_b(), res.func_110623_a() + "_bucket"));
        if (bucket != null && bucket != Items.field_190931_a) {
            VALID_BUCKETS.put(bucket, mobId);
        } else {
            bucket = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(res.func_110624_b(), "bucket_" + res.func_110623_a()));
            if (bucket != null && bucket != Items.field_190931_a) {
                VALID_BUCKETS.put(bucket, mobId);
            } else {
                bucket = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(res.func_110624_b(), "bucket_of_" + res.func_110623_a()));
                if (bucket != null && bucket != Items.field_190931_a) {
                    VALID_BUCKETS.put(bucket, mobId);
                }
            }
        }
    }

    public String toString() {
        return super.toString().toLowerCase();
    }

    static {
        int fishIndex = 0;
        DEFAULT_CONFIG.add(CapturedMobs.addDef("minecraft:bee", 0.3125f, 0.0f));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("minecraft:vex", 0.0f, 0.125f, 0, Category.FLOATING));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("minecraft:silverfish", 0.0f, 0.25f));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("minecraft:chicken", 0.25f, 0.3125f));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("minecraft:endermite", 0.0f, 0.0f, 5));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("supplementaries:firefly", 0.0f, 0.0f, 9, Category.FLOATING));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("druidcraft:lunar_moth", 0.375f, 0.1375f, 10, Category.FLOATING));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("iceandfire:pixie", 0.0f, 0.0f, 10));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("minecraft:fish", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("minecraft:tropical_fish", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("minecraft:salmon", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("minecraft:cod", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("minecraft:pufferfish", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("minecraft:axolotl", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("fins:pea_wee", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("fins:wee_wee", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("fins:vibra_wee", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("fins:blu_wee", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("fins:ornate_bugfish", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("fins:spindly_gem_crab", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("fins:phantom_nudibranch", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("fins:high_finned_blue", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("fins:teal_arrowfish", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("fins:midnight_squid", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("fins:banded_redback_shrimp", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("fins:flatback_sucker", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("fins:swamp_mucker", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("upgrade_aquatic:lionfish", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("upgrade_aquatic:nautilus", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("upgrade_aquatic:pike", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("alexsmobs:stradpole", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("alexsmobs:blobfish", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("unnamedanimalmod:flashlight_fish", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("unnamedanimalmod:elephantnose_fish", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("unnamedanimalmod:black_diamond_stingray", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("unnamedanimalmod:humphead_parrotfish", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("unnamedanimalmod:tomato_frog", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("unnamedanimalmod:pacman_frog", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("bettas:betta_fish", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("pogfish:pogfish", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("undergarden:gwibling", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("environmental:koi", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("betterendforge:end_fish", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("betteranimalsplus:flying_fish", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("betteranimalsplus:nautilus", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("betteranimalsplus:eel_freshwater", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("betteranimalsplus:eel_saltwater", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("betteranimalsplus:lamprey", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("betteranimalsplus:piranha", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("betteranimalsplus:barracuda", ++fishIndex));
        DEFAULT_CONFIG.add(CapturedMobs.addDef("rediscovered:fish", 1));
    }

    private static enum Category {
        DEFAULT,
        FISH,
        LAND,
        AIR,
        FLOATING;

    }

    public static class CapturedMobProperties {
        private final String id;
        private final float extraWidth;
        private final float extraHeight;
        private final int lightLevel;
        private final int fishTexture;
        private final Category category;

        private CapturedMobProperties(String id, float h, float w, int light, int fish, Category c) {
            this.id = id;
            this.extraWidth = w;
            this.extraHeight = h;
            this.lightLevel = light;
            this.fishTexture = fish - 1;
            this.category = c;
        }

        public boolean canHaveWater() {
            return this.isFlying() || this.isFish();
        }

        public String getId() {
            return this.id;
        }

        public float getHeight() {
            return this.extraHeight;
        }

        public float getWidth() {
            return this.extraWidth;
        }

        public int getFishTexture() {
            return this.fishTexture;
        }

        public int getLightLevel() {
            return this.lightLevel;
        }

        public boolean isFish() {
            return this.category == Category.FISH;
        }

        public boolean isFlying() {
            return this.category == Category.AIR || this.category == Category.FLOATING;
        }

        public boolean isLand() {
            return this.category == Category.LAND;
        }

        public boolean isFloating() {
            return this.category == Category.FLOATING;
        }
    }
}

