/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import net.mehvahdjukaar.supplementaries.block.util.IBlockHolder;
import net.mehvahdjukaar.supplementaries.block.util.ITextHolder;
import net.mehvahdjukaar.supplementaries.block.util.TextHolder;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.datagen.types.IWoodType;
import net.mehvahdjukaar.supplementaries.datagen.types.VanillaWoodTypes;
import net.mehvahdjukaar.supplementaries.datagen.types.WoodTypes;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class SignPostBlockTile
extends TileEntity
implements ITextHolder,
IBlockHolder {
    public TextHolder textHolder;
    public BlockState fenceBlock = Blocks.field_150350_a.func_176223_P();
    public float yawUp = 0.0f;
    public float yawDown = 0.0f;
    public boolean leftUp = true;
    public boolean leftDown = false;
    public boolean up = false;
    public boolean down = false;
    public IWoodType woodTypeUp = VanillaWoodTypes.OAK;
    public IWoodType woodTypeDown = VanillaWoodTypes.OAK;

    public SignPostBlockTile() {
        super((TileEntityType)Registry.SIGN_POST_TILE.get());
        this.textHolder = new TextHolder(2);
    }

    @Override
    public BlockState getHeldBlock() {
        return this.fenceBlock;
    }

    @Override
    public boolean setHeldBlock(BlockState state) {
        this.fenceBlock = state;
        return true;
    }

    @Override
    public TextHolder getTextHolder() {
        return this.textHolder;
    }

    public double func_145833_n() {
        return 128.0;
    }

    public void func_70296_d() {
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        super.func_70296_d();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v().func_177963_a(-0.25, 0.0, -0.25), this.func_174877_v().func_177963_a(1.25, 1.0, 1.25));
    }

    public void pointToward(BlockPos targetPos, boolean up) {
        float yaw = (float)(Math.atan2(targetPos.func_177958_n() - this.field_174879_c.func_177958_n(), targetPos.func_177952_p() - this.field_174879_c.func_177952_p()) * 180.0 / Math.PI);
        if (up) {
            this.yawUp = MathHelper.func_76142_g((float)(yaw - (float)(this.leftUp ? 180 : 0)));
        } else {
            this.yawDown = MathHelper.func_76142_g((float)(yaw - (float)(this.leftDown ? 180 : 0)));
        }
    }

    public float getPointingYaw(boolean up) {
        if (up) {
            return MathHelper.func_76142_g((float)(-this.yawUp - (float)(this.leftUp ? 180 : 0)));
        }
        return MathHelper.func_76142_g((float)(-this.yawDown - (float)(this.leftDown ? 180 : 0)));
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.textHolder.read(compound);
        this.fenceBlock = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("Fence"));
        this.yawUp = compound.func_74760_g("YawUp");
        this.yawDown = compound.func_74760_g("YawDown");
        this.leftUp = compound.func_74767_n("LeftUp");
        this.leftDown = compound.func_74767_n("LeftDown");
        this.up = compound.func_74767_n("Up");
        this.down = compound.func_74767_n("Down");
        this.woodTypeUp = WoodTypes.fromNBT(compound.func_74779_i("TypeUp"));
        this.woodTypeDown = WoodTypes.fromNBT(compound.func_74779_i("TypeDown"));
        if (compound.func_74764_b("WoodTypeUp")) {
            this.woodTypeUp = CommonUtil.TempWoodType.values()[compound.func_74762_e("WoodTypeUp")].convertWoodType();
        }
        if (compound.func_74764_b("WoodTypeDown")) {
            this.woodTypeDown = CommonUtil.TempWoodType.values()[compound.func_74762_e("WoodTypeDown")].convertWoodType();
        }
        if (compound.func_74764_b("Wood_type_up")) {
            this.woodTypeUp = CommonUtil.TempWoodType.values()[compound.func_74762_e("Wood_type_up")].convertWoodType();
        }
        if (compound.func_74764_b("Wood_type_down")) {
            this.woodTypeDown = CommonUtil.TempWoodType.values()[compound.func_74762_e("Wood_type_down")].convertWoodType();
        }
        if (compound.func_74764_b("Left_up")) {
            this.leftUp = compound.func_74767_n("Left_up");
        }
        if (compound.func_74764_b("Left_down")) {
            this.leftDown = compound.func_74767_n("Left_down");
        }
        if (compound.func_74764_b("Yaw_up")) {
            this.yawUp = compound.func_74760_g("Yaw_up");
        }
        if (compound.func_74764_b("Yaw_down")) {
            this.yawDown = compound.func_74760_g("Yaw_down");
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.textHolder.write(compound);
        compound.func_218657_a("Fence", (INBT)NBTUtil.func_190009_a((BlockState)this.fenceBlock));
        compound.func_74776_a("YawUp", this.yawUp);
        compound.func_74776_a("YawDown", this.yawDown);
        compound.func_74757_a("LeftUp", this.leftUp);
        compound.func_74757_a("LeftDown", this.leftDown);
        compound.func_74757_a("Up", this.up);
        compound.func_74757_a("Down", this.down);
        compound.func_74778_a("TypeUp", this.woodTypeUp.toNBT());
        compound.func_74778_a("TypeDown", this.woodTypeDown.toNBT());
        return compound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }
}

