/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.block.blocks.SackBlock;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.inventories.SackContainer;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import vazkii.quark.api.ITransferManager;

public class SackBlockTile
extends LockableLootTileEntity
implements INameable,
ISidedInventory,
ICapabilityProvider,
ITransferManager {
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    private int numPlayersUsing;
    private ITextComponent customName;
    private final LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])Direction.values());

    public SackBlockTile() {
        super((TileEntityType)Registry.SACK_TILE.get());
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public void func_213903_a(ITextComponent name) {
        this.customName = name;
    }

    public ITextComponent func_200201_e() {
        return this.customName;
    }

    public ITextComponent func_213907_g() {
        return new TranslationTextComponent("block.supplementaries.sack");
    }

    public void func_174889_b(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            BlockState blockstate = this.func_195044_w();
            boolean flag = (Boolean)blockstate.func_177229_b((Property)SackBlock.OPEN);
            if (!flag) {
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187546_ae, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.55f);
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187748_db, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.7f);
                this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)blockstate.func_206870_a((Property)SackBlock.OPEN, (Comparable)Boolean.valueOf(true)), 3);
            }
            this.field_145850_b.func_205220_G_().func_205360_a(this.func_174877_v(), (Object)this.func_195044_w().func_177230_c(), 5);
        }
    }

    public static int calculatePlayersUsing(World world, LockableTileEntity tile, int x, int y, int z) {
        int i = 0;
        for (PlayerEntity playerentity : world.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)((float)x - 5.0f), (double)((float)y - 5.0f), (double)((float)z - 5.0f), (double)((float)(x + 1) + 5.0f), (double)((float)(y + 1) + 5.0f), (double)((float)(z + 1) + 5.0f)))) {
            IInventory iinventory;
            if (!(playerentity.field_71070_bA instanceof SackContainer) || (iinventory = ((SackContainer)playerentity.field_71070_bA).inventory) != tile) continue;
            ++i;
        }
        return i;
    }

    public void barrelTick() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        this.numPlayersUsing = SackBlockTile.calculatePlayersUsing(this.field_145850_b, (LockableTileEntity)this, i, j, k);
        if (this.numPlayersUsing > 0) {
            this.field_145850_b.func_205220_G_().func_205360_a(this.func_174877_v(), (Object)this.func_195044_w().func_177230_c(), 5);
        } else {
            BlockState blockstate = this.func_195044_w();
            boolean flag = (Boolean)blockstate.func_177229_b((Property)SackBlock.OPEN);
            if (flag) {
                this.field_145850_b.func_184148_a((PlayerEntity)null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187546_ae, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.5f);
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187748_db, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.6f);
                this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)blockstate.func_206870_a((Property)SackBlock.OPEN, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    public void func_174886_c(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.numPlayersUsing;
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.loadFromNbt(nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        return this.saveToNbt(compound);
    }

    public void loadFromNbt(CompoundNBT compound) {
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(compound) && compound.func_150297_b("Items", 9)) {
            ItemStackHelper.func_191283_b((CompoundNBT)compound, this.items);
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName"));
        }
    }

    public CompoundNBT saveToNbt(CompoundNBT compound) {
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191281_a((CompoundNBT)compound, this.items, (boolean)false);
        }
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        return compound;
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.items;
    }

    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    public Container func_213906_a(int id, PlayerInventory player) {
        return new SackContainer(id, player, (IInventory)this);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public boolean isSlotUnlocked(int ind) {
        int add = ServerConfigs.cached.SACK_SLOTS;
        return ind < this.func_70302_i_() - 4 + 2 * add;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.isSlotUnlocked(index) && CommonUtil.isAllowedInShulker(stack);
    }

    public int[] func_180463_a(Direction side) {
        return IntStream.range(0, this.func_70302_i_()).toArray();
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return this.isSlotUnlocked(index);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handlers[facing.ordinal()].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    @Override
    public boolean acceptsTransfer(PlayerEntity player) {
        return false;
    }
}

