/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.blocks.ClockBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.block.util.IMobHolder;
import net.mehvahdjukaar.supplementaries.block.util.MobHolder;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.fluids.SoftFluidHolder;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.FishBucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class JarBlockTile
extends ItemDisplayTile
implements ITickableTileEntity,
IMobHolder {
    private final int CAPACITY = ServerConfigs.cached.JAR_CAPACITY;
    public MobHolder mobHolder = new MobHolder(this.field_145850_b, this.field_174879_c);
    public SoftFluidHolder fluidHolder = new SoftFluidHolder(this.CAPACITY);

    public JarBlockTile() {
        super((TileEntityType)Registry.JAR_TILE.get());
    }

    @Override
    public MobHolder getMobHolder() {
        return this.mobHolder;
    }

    public double func_145833_n() {
        return 80.0;
    }

    public void onLoad() {
        this.mobHolder.setWorldAndPos(this.field_145850_b, this.field_174879_c);
        this.fluidHolder.setWorldAndPos(this.field_145850_b, this.field_174879_c);
    }

    @Override
    public void func_70296_d() {
        this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
        int light = this.fluidHolder.getFluid().getLuminosity();
        if (light != (Integer)this.func_195044_w().func_177229_b((Property)BlockProperties.LIGHT_LEVEL_0_15)) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockProperties.LIGHT_LEVEL_0_15, (Comparable)Integer.valueOf(light)), 2);
        }
        super.func_70296_d();
    }

    public boolean handleInteraction(PlayerEntity player, Hand hand) {
        ItemStack handStack = player.func_184586_b(hand);
        ItemStack displayedStack = this.getDisplayedItem();
        if (this.func_191420_l() && this.mobHolder.isEmpty() && this.fluidHolder.interactWithPlayer(player, hand)) {
            return true;
        }
        if (this.mobHolder.isEmpty() && this.func_94041_b(0, handStack)) {
            this.handleAddItem(handStack, player, hand);
            return true;
        }
        if (this.func_191420_l() && this.fluidHolder.isEmpty() && this.mobHolder.interactWithBucketItem(handStack, player, hand)) {
            return true;
        }
        if (!player.func_225608_bj_() && ServerConfigs.cached.JAR_EAT) {
            if (this.fluidHolder.isFood() && this.fluidHolder.drinkUpFluid(player, this.field_145850_b, hand)) {
                return true;
            }
            if (displayedStack.func_222117_E() && player.func_71043_e(false)) {
                player.func_213357_a(this.field_145850_b, displayedStack);
                return true;
            }
        }
        return this.handleExtractItem(player, hand);
    }

    public ItemStack extractItem() {
        ItemStack myStack = this.getDisplayedItem();
        if (myStack.func_190916_E() > 0) {
            return myStack.func_77979_a(1);
        }
        return ItemStack.field_190927_a;
    }

    public boolean handleExtractItem(PlayerEntity player, Hand hand) {
        if (this.getDisplayedItem().func_77973_b() instanceof FishBucketItem) {
            if (player.func_184586_b(hand).func_77973_b() != Items.field_151133_ar) {
                return false;
            }
            this.field_145850_b.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_203814_aa, SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else if (!player.func_184586_b(hand).func_190926_b()) {
            return false;
        }
        ItemStack extracted = this.extractItem();
        if (!extracted.func_190926_b()) {
            CommonUtil.swapItem(player, hand, extracted);
            return true;
        }
        return false;
    }

    public void handleAddItem(ItemStack stack, @Nullable PlayerEntity player, Hand handIn) {
        ItemStack handStack = stack.func_77946_l();
        handStack.func_190920_e(1);
        Item item2 = handStack.func_77973_b();
        this.addItem(handStack);
        if (player != null) {
            ItemStack returnStack = ItemStack.field_190927_a;
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)item2));
            if (!player.func_184812_l_()) {
                CommonUtil.swapItem(player, handIn, returnStack);
            }
        }
    }

    public void addItem(ItemStack itemstack) {
        if (this.func_191420_l()) {
            NonNullList stacks = NonNullList.func_191197_a((int)1, (Object)itemstack);
            this.func_199721_a((NonNullList<ItemStack>)stacks);
        } else {
            this.getDisplayedItem().func_190917_f(Math.min(1, this.func_70297_j_() - this.getDisplayedItem().func_190916_E()));
        }
    }

    public void resetHolders() {
        this.fluidHolder.clear();
        this.mobHolder.clear();
        this.setDisplayedItem(ItemStack.field_190927_a);
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        if (this.fluidHolder.isEmpty() && this.mobHolder.isEmpty()) {
            Item i = stack.func_77973_b();
            if (!this.isFull() && CommonUtil.isCookie(i)) {
                return this.func_191420_l() || i == this.getDisplayedItem().func_77973_b();
            }
        }
        return false;
    }

    public boolean convertOldJars(CompoundNBT compound) {
        if (compound == null) {
            return false;
        }
        NonNullList oldStacks = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, (NonNullList)oldStacks);
        ItemStack oldStack = (ItemStack)oldStacks.get(0);
        if (!oldStacks.isEmpty() && !oldStack.func_190926_b()) {
            this.fluidHolder.clear();
            if (!this.fluidHolder.interactWithItem(oldStack).func_190926_b()) {
                if (compound.func_74764_b("LiquidHolder")) {
                    this.fluidHolder.setCount((int)(compound.func_74775_l("LiquidHolder").func_74760_g("Level") * 16.0f));
                } else {
                    this.fluidHolder.lossyAdd(oldStack.func_190916_E());
                }
                this.stacks = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
                return true;
            }
        }
        return false;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (!compound.func_74764_b("LiquidHolder") || !this.convertOldJars(compound)) {
            this.fluidHolder.read(compound);
        }
        this.mobHolder.read(compound);
        this.onLoad();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.mobHolder.write(compound);
        this.fluidHolder.write(compound);
        return compound;
    }

    public boolean hasContent() {
        return !this.func_191420_l() || !this.mobHolder.isEmpty() || !this.fluidHolder.isEmpty();
    }

    public boolean isFull() {
        return this.getDisplayedItem().func_190916_E() >= this.func_70297_j_();
    }

    @Override
    public int func_70297_j_() {
        return this.CAPACITY;
    }

    public ITextComponent func_213907_g() {
        return new TranslationTextComponent("block.supplementaries.jar");
    }

    @Override
    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return CommonUtil.isCookie(stack.func_77973_b()) && (this.func_191420_l() || stack.func_77973_b() == this.getDisplayedItem().func_77973_b());
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    @Override
    public Direction getDirection() {
        return (Direction)this.func_195044_w().func_177229_b((Property)ClockBlock.FACING);
    }

    public void func_73660_a() {
        this.mobHolder.tick();
    }
}

