/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import java.util.Random;
import java.util.stream.IntStream;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.blocks.FaucetBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.JarBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.JarBlockTile;
import net.mehvahdjukaar.supplementaries.fluids.SoftFluid;
import net.mehvahdjukaar.supplementaries.fluids.SoftFluidHolder;
import net.mehvahdjukaar.supplementaries.fluids.SoftFluidList;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class FaucetBlockTile
extends TileEntity
implements ITickableTileEntity {
    private int transferCooldown = 0;
    protected final Random rand = new Random();
    public final SoftFluidHolder fluidHolder = new SoftFluidHolder(1);

    public FaucetBlockTile() {
        super((TileEntityType)Registry.FAUCET_TILE.get());
    }

    public void onLoad() {
        this.fluidHolder.setWorldAndPos(this.field_145850_b, this.field_174879_c);
    }

    public void func_70296_d() {
        int light = this.fluidHolder.getFluid().getLuminosity();
        if (light != (Integer)this.func_195044_w().func_177229_b((Property)BlockProperties.LIGHT_LEVEL_0_15)) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockProperties.LIGHT_LEVEL_0_15, (Comparable)Integer.valueOf(light)), 2);
        }
        super.func_70296_d();
    }

    public boolean updateDisplayedFluid(BlockState state) {
        FluidStack fluid;
        Direction dir = ((Direction)state.func_177229_b((Property)FaucetBlock.FACING)).func_176734_d();
        BlockPos backPos = this.field_174879_c.func_177972_a(dir);
        BlockState backState = this.field_145850_b.func_180495_p(backPos);
        Block b = backState.func_177230_c();
        if (b instanceof JarBlock) {
            TileEntity te = this.field_145850_b.func_175625_s(backPos);
            if (te instanceof JarBlockTile && !((JarBlockTile)te).fluidHolder.isEmpty()) {
                this.fluidHolder.copy(((JarBlockTile)te).fluidHolder);
                return true;
            }
            return false;
        }
        if (b instanceof BeehiveBlock) {
            if ((Integer)backState.func_177229_b((Property)BeehiveBlock.field_226873_c_) > 0) {
                this.fluidHolder.fill(SoftFluidList.HONEY);
                return true;
            }
            return false;
        }
        if (b instanceof CauldronBlock) {
            if (this.field_145850_b instanceof World && backState.func_185888_a(this.field_145850_b, backPos) > 0) {
                this.fluidHolder.fill(SoftFluidList.WATER);
                return true;
            }
            return false;
        }
        FluidState fluidState = this.field_145850_b.func_204610_c(backPos);
        if (!fluidState.func_206888_e()) {
            this.fluidHolder.fill(SoftFluidList.fromFluid(fluidState.func_206886_c()));
            return true;
        }
        IFluidHandler handler = (IFluidHandler)FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)backPos, (Direction)dir.func_176734_d()).orElse(null);
        if (handler != null && !(fluid = handler.getFluidInTank(0)).isEmpty()) {
            this.fluidHolder.fill(fluid);
            return true;
        }
        return false;
    }

    public double func_145833_n() {
        return 80.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v().func_177982_a(0, -1, 0), this.func_174877_v().func_177982_a(1, 1, 1));
    }

    private boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            boolean flag;
            if (this.isOnTransferCooldown()) {
                --this.transferCooldown;
            } else if (this.isOpen() && (flag = this.tryExtract())) {
                this.transferCooldown = 20;
            }
        }
    }

    private boolean tryFillingBlockBelow(SoftFluid softFluid) {
        FluidStack honeyStack;
        TileEntity tileDown = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (tileDown instanceof JarBlockTile) {
            if (((JarBlockTile)tileDown).fluidHolder.tryAddingFluid(softFluid)) {
                tileDown.func_70296_d();
                return true;
            }
            return false;
        }
        IFluidHandler handlerDown = (IFluidHandler)FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177977_b(), (Direction)Direction.UP).orElse(null);
        if (handlerDown != null && !(honeyStack = new FluidStack(softFluid.getFluid(), 250)).isEmpty() && handlerDown.fill(honeyStack, IFluidHandler.FluidAction.SIMULATE) > 0) {
            handlerDown.fill(honeyStack, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    private static boolean isSapLog(Block block2) {
        String name = block2.getRegistryName().toString();
        return name.equals("autumnity:sappy_maple_log") || name.equals("autumnity:sappy_maple_wood");
    }

    private boolean tryExtract() {
        SoftFluidHolder holder;
        TileEntity te;
        Direction dir = (Direction)this.func_195044_w().func_177229_b((Property)FaucetBlock.FACING);
        BlockPos behind = this.field_174879_c.func_177972_a(dir.func_176734_d());
        BlockState backState = this.field_145850_b.func_180495_p(behind);
        Block backBlock = backState.func_177230_c();
        if (this.hasFluidTankBelow()) {
            if (backBlock instanceof BeehiveBlock && (Integer)backState.func_177229_b((Property)BlockStateProperties.field_227036_ao_) > 0) {
                if (this.tryFillingBlockBelow(SoftFluidList.HONEY)) {
                    this.field_145850_b.func_180501_a(behind, (BlockState)backState.func_206870_a((Property)BlockStateProperties.field_227036_ao_, (Comparable)Integer.valueOf((Integer)backState.func_177229_b((Property)BlockStateProperties.field_227036_ao_) - 1)), 3);
                    return true;
                }
                return false;
            }
            if (FaucetBlockTile.isSapLog(backBlock)) {
                if (this.tryFillingBlockBelow(SoftFluidList.SAP)) {
                    Block log = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(backBlock.getRegistryName().toString().replace("sappy", "stripped")));
                    if (log != null) {
                        this.field_145850_b.func_180501_a(behind, (BlockState)log.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208148_A, backState.func_177229_b((Property)BlockStateProperties.field_208148_A)), 3);
                    }
                    return true;
                }
                return false;
            }
            if (backBlock instanceof CauldronBlock && (Integer)backState.func_177229_b((Property)BlockStateProperties.field_208130_ae) > 0) {
                if (this.field_145850_b.func_175625_s(behind) == null && this.tryFillingBlockBelow(SoftFluidList.WATER)) {
                    this.field_145850_b.func_180501_a(behind, (BlockState)backState.func_206870_a((Property)BlockStateProperties.field_208130_ae, (Comparable)Integer.valueOf((Integer)backState.func_177229_b((Property)BlockStateProperties.field_208130_ae) - 1)), 3);
                    return true;
                }
                return false;
            }
            IFluidHandler handlerDown = (IFluidHandler)FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177977_b(), (Direction)Direction.UP).orElse(null);
            if (backBlock instanceof JarBlock) {
                TileEntity tileBack = this.field_145850_b.func_175625_s(behind);
                if (tileBack instanceof JarBlockTile) {
                    if (handlerDown != null && ((JarBlockTile)tileBack).fluidHolder.fillFluidTank(handlerDown)) {
                        tileBack.func_70296_d();
                        return true;
                    }
                    TileEntity tileDown = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
                    if (tileDown instanceof JarBlockTile && ((IInventory)tileBack).func_191420_l() && ((JarBlockTile)tileBack).fluidHolder.tryTransferFluid(((JarBlockTile)tileDown).fluidHolder)) {
                        tileBack.func_70296_d();
                        tileDown.func_70296_d();
                        return true;
                    }
                }
                return false;
            }
            IFluidHandler handlerBack = (IFluidHandler)FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)behind, (Direction)dir).orElse(null);
            if (handlerBack != null) {
                if (handlerDown != null) {
                    return FluidUtil.tryFluidTransfer((IFluidHandler)handlerDown, (IFluidHandler)handlerBack, (int)250, (boolean)true) != null;
                }
                TileEntity tileDown = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
                if (tileDown instanceof JarBlockTile && ((JarBlockTile)tileDown).fluidHolder.drainFluidTank(handlerBack)) {
                    tileDown.func_70296_d();
                    return true;
                }
            }
        } else if (backBlock instanceof JarBlock && (te = this.field_145850_b.func_175625_s(behind)) instanceof JarBlockTile && ((IInventory)te).func_191420_l() && (holder = ((JarBlockTile)te).fluidHolder).canRemove(1)) {
            if (holder.getFluid() == SoftFluidList.XP) {
                ((JarBlockTile)te).fluidHolder.shrink(1);
                this.dropXP();
                te.func_70296_d();
                return true;
            }
            return false;
        }
        return this.pullItems();
    }

    private void dropXP() {
        int xp;
        for (int i = 3 + this.field_145850_b.field_73012_v.nextInt(5) + this.field_145850_b.field_73012_v.nextInt(5); i > 0; i -= xp) {
            xp = ExperienceOrbEntity.func_70527_a((int)i);
            ExperienceOrbEntity orb = new ExperienceOrbEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)((float)this.field_174879_c.func_177956_o() - 0.125f), (double)this.field_174879_c.func_177952_p() + 0.5, xp);
            orb.func_213317_d(new Vector3d(0.0, 0.0, 0.0));
            this.field_145850_b.func_217376_c((Entity)orb);
        }
        float f = (this.rand.nextFloat() - 0.5f) / 4.0f;
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187665_Y, SoundCategory.BLOCKS, 0.3f, 0.5f + f);
    }

    public boolean isOpen() {
        return (Boolean)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208194_u) ^ (Boolean)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208180_g);
    }

    public boolean hasWater() {
        return (Boolean)this.func_195044_w().func_177229_b((Property)FaucetBlock.HAS_WATER);
    }

    public boolean hasFluidTankBelow() {
        return (Boolean)this.func_195044_w().func_177229_b((Property)FaucetBlock.HAS_JAR);
    }

    private static boolean canExtractItemFromSlot(IInventory inventoryIn, ItemStack stack, int index, Direction side) {
        return !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180461_b(index, stack, side);
    }

    private boolean pullItemFromSlot(IInventory inventoryIn, int index, Direction direction) {
        ItemStack itemstack = inventoryIn.func_70301_a(index);
        if (this.hasFluidTankBelow()) {
            return false;
        }
        if (!itemstack.func_190926_b() && FaucetBlockTile.canExtractItemFromSlot(inventoryIn, itemstack, index, direction)) {
            ItemStack it = itemstack.func_77946_l();
            itemstack.func_190918_g(1);
            inventoryIn.func_70296_d();
            it.func_190920_e(1);
            ItemEntity drop = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, it);
            drop.func_213317_d(new Vector3d(0.0, 0.0, 0.0));
            this.field_145850_b.func_217376_c((Entity)drop);
            float f = (this.rand.nextFloat() - 0.5f) / 4.0f;
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187665_Y, SoundCategory.BLOCKS, 0.3f, 0.5f + f);
            return true;
        }
        return false;
    }

    public boolean pullItems() {
        IInventory iinventory = this.getSourceInventory();
        if (iinventory != null) {
            Direction direction = (Direction)this.func_195044_w().func_177229_b((Property)HorizontalBlock.field_185512_D);
            return FaucetBlockTile.getSlots(iinventory, direction).anyMatch(p_213971_3_ -> this.pullItemFromSlot(iinventory, p_213971_3_, direction));
        }
        return false;
    }

    public IInventory getSourceInventory() {
        BlockPos behind = this.field_174879_c.func_177967_a((Direction)this.func_195044_w().func_177229_b((Property)HorizontalBlock.field_185512_D), -1);
        IInventory firstinv = HopperTileEntity.func_195484_a((World)this.func_145831_w(), (BlockPos)behind);
        if (firstinv != null) {
            return firstinv;
        }
        if (this.field_145850_b.func_180495_p(behind).func_215686_e((IBlockReader)this.field_145850_b, this.field_174879_c)) {
            return HopperTileEntity.func_195484_a((World)this.func_145831_w(), (BlockPos)this.field_174879_c.func_177967_a((Direction)this.func_195044_w().func_177229_b((Property)HorizontalBlock.field_185512_D), -2));
        }
        return null;
    }

    private static IntStream getSlots(IInventory inv, Direction dir) {
        return inv instanceof ISidedInventory ? IntStream.of(((ISidedInventory)inv).func_180463_a(dir)) : IntStream.range(0, inv.func_70302_i_());
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.transferCooldown = compound.func_74762_e("TransferCooldown");
        this.fluidHolder.read(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("TransferCooldown", this.transferCooldown);
        this.fluidHolder.write(compound);
        return compound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }
}

