/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.mehvahdjukaar.supplementaries.block.blocks.NoticeBoardBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.mehvahdjukaar.supplementaries.world.structures.RoadSignFeature;
import net.mehvahdjukaar.supplementaries.world.structures.StructureLocator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockGeneratorBlockTile
extends TileEntity
implements ITickableTileEntity {
    private boolean firstTick = true;
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)SixWayBlock.field_196491_B.entrySet().stream().filter(prop -> ((Direction)prop.getKey()).func_176740_k().func_176722_c()).collect(Util.func_199749_a());
    private final BlockState trapdoor = Blocks.field_196638_cX.func_176223_P();
    private final BlockState lantern = (BlockState)Blocks.field_222432_lU.func_176223_P().func_206870_a((Property)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(true));
    private final BlockState lanternDown = Blocks.field_222432_lU.func_176223_P();
    private final BlockState fence = Blocks.field_180408_aP.func_176223_P();
    private final BlockState jar = ((Block)Registry.FIREFLY_JAR.get()).func_176223_P();
    private final BlockState slab = Blocks.field_196624_br.func_176223_P();
    private final BlockState stoneSlab = Blocks.field_150333_U.func_176223_P();
    private final BlockState stone = Blocks.field_150348_b.func_176223_P();
    private final BlockState stair = Blocks.field_222438_lb.func_176223_P();

    public BlockGeneratorBlockTile() {
        super((TileEntityType)Registry.BLOCK_GENERATOR_TILE.get());
    }

    private double averageAngles(float a, float b) {
        a = (float)((double)a * Math.PI / 180.0);
        b = (float)((double)b * Math.PI / 180.0);
        return 57.29577951308232 * MathHelper.func_181159_b((double)(MathHelper.func_76126_a((float)a) + MathHelper.func_76126_a((float)b)), (double)(MathHelper.func_76134_b((float)a) + MathHelper.func_76134_b((float)b)));
    }

    public void func_73660_a() {
        if (this.field_145850_b instanceof ServerWorld) {
            if (!this.firstTick) {
                this.field_145850_b.func_217377_a(this.field_174879_c, false);
                return;
            }
            this.firstTick = false;
            ServerWorld world = (ServerWorld)this.field_145850_b;
            BlockPos pos = this.field_174879_c.func_177979_c(2);
            BlockState topState = this.trapdoor;
            Map<Integer, BlockPos> villages = StructureLocator.find(world, pos, Structure.field_236381_q_, 25, 2);
            if (villages.size() >= 1) {
                BlockPos village2;
                BlockPos village1;
                ArrayList lampDir = Direction.Plane.HORIZONTAL.func_239636_a_().collect(Collectors.toCollection(ArrayList::new));
                ArrayList<Integer> v = new ArrayList<Integer>(villages.keySet());
                Random rand = this.field_145850_b.field_73012_v;
                boolean twoSigns = true;
                boolean inv = rand.nextBoolean();
                if (villages.size() == 1 || 0.3 > (double)rand.nextFloat() && v.get(0) > 192) {
                    village2 = village1 = villages.get(v.get(0));
                    twoSigns = false;
                } else {
                    village1 = villages.get(v.get(inv ? 0 : 1));
                    village2 = villages.get(v.get(inv ? 1 : 0));
                }
                this.field_145850_b.func_180501_a(pos, ((Block)Registry.SIGN_POST.get()).func_176223_P(), 3);
                TileEntity te = this.field_145850_b.func_175625_s(pos);
                if (te instanceof SignPostBlockTile) {
                    SignPostBlockTile sign = (SignPostBlockTile)te;
                    sign.setHeldBlock(Blocks.field_180408_aP.func_176223_P());
                    boolean left = rand.nextBoolean();
                    sign.up = true;
                    sign.leftUp = left;
                    sign.pointToward(village1, true);
                    sign.textHolder.setText(0, (ITextComponent)new StringTextComponent("" + v.get(0)));
                    sign.down = twoSigns;
                    sign.leftDown = left;
                    sign.pointToward(village2, false);
                    if (Math.abs(sign.yawUp - sign.yawDown) > 90.0f) {
                        sign.leftDown = !sign.leftDown;
                        sign.pointToward(village2, false);
                    }
                    sign.textHolder.setText(1, (ITextComponent)new StringTextComponent("" + v.get(1)));
                    float yaw = MathHelper.func_76142_g((float)(90.0f + (float)this.averageAngles(-sign.yawUp + 180.0f, -sign.yawDown + 180.0f)));
                    Direction backDir = Direction.func_176733_a((double)yaw);
                    float diff = MathHelper.func_203302_c((float)yaw, (float)backDir.func_185119_l());
                    Direction sideDir = diff < 0.0f ? backDir.func_176746_e() : backDir.func_176735_f();
                    lampDir.remove(backDir);
                    lampDir.add(backDir.func_176734_d());
                    lampDir.add(backDir.func_176734_d());
                    lampDir.add(backDir.func_176734_d());
                    if (Math.abs(diff) > 30.0f) {
                        lampDir.add(sideDir.func_176734_d());
                        lampDir.remove(sideDir);
                    }
                    boolean hasGroundLantern = false;
                    if (0.3 > (double)rand.nextFloat() && MathHelper.func_203301_d((float)(sign.getPointingYaw(true) + 180.0f), (float)yaw) > 70.0f) {
                        BlockPos stonePos = pos.func_177977_b().func_177971_a(backDir.func_176730_m());
                        if (rand.nextBoolean()) {
                            world.func_180501_a(stonePos, this.stoneSlab, 2);
                        } else {
                            world.func_180501_a(stonePos, (BlockState)this.stair.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)sideDir), 2);
                        }
                        stonePos = stonePos.func_177971_a(sideDir.func_176730_m());
                        world.func_180501_a(stonePos, this.stone, 2);
                        if (0.35 > (double)rand.nextFloat()) {
                            world.func_180501_a(stonePos.func_177984_a(), this.lanternDown, 3);
                            hasGroundLantern = true;
                        }
                        if (!RoadSignFeature.isNotSolid((IWorld)world, (stonePos = stonePos.func_177971_a(sideDir.func_176730_m())).func_177977_b()) && RoadSignFeature.isReplaceable((IWorld)world, stonePos)) {
                            if (rand.nextBoolean()) {
                                world.func_180501_a(stonePos, this.stoneSlab, 2);
                            } else {
                                world.func_180501_a(stonePos, (BlockState)this.stair.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)sideDir.func_176734_d()), 2);
                            }
                        }
                    }
                    if (!hasGroundLantern) {
                        boolean isTrapdoor;
                        boolean doubleSided;
                        RegistryKey biome = RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)world.func_226691_t_(pos = pos.func_177981_b(2)).getRegistryName());
                        float chance = BiomeDictionary.hasType((RegistryKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL) || BiomeDictionary.hasType((RegistryKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) || BiomeDictionary.hasType((RegistryKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY) ? 0.2f : 0.02f;
                        BlockState light = chance > rand.nextFloat() ? this.jar : this.lantern;
                        Direction dir = (Direction)lampDir.get(rand.nextInt(lampDir.size()));
                        boolean bl = doubleSided = 0.2 > (double)rand.nextFloat();
                        if (doubleSided) {
                            dir = dir.func_176746_e();
                        }
                        boolean bl2 = isTrapdoor = 0.35 > (double)rand.nextFloat();
                        if (!isTrapdoor) {
                            topState = this.fence;
                        }
                        if (doubleSided) {
                            BlockPos backPos = pos.func_177971_a(dir.func_176734_d().func_176730_m());
                            if (isTrapdoor) {
                                world.func_180501_a(backPos, this.trapdoor, 2);
                                if (0.25 > (double)rand.nextFloat()) {
                                    topState = this.slab;
                                }
                            } else {
                                world.func_180501_a(backPos, this.fence, 2);
                            }
                            world.func_180501_a(backPos.func_177977_b(), light, 3);
                        }
                        pos = pos.func_177971_a(dir.func_176730_m());
                        BlockState frontState = isTrapdoor ? this.trapdoor : this.fence;
                        world.func_180501_a(pos, frontState, 2);
                        world.func_180501_a(pos.func_177977_b(), light, 3);
                    }
                }
            } else {
                this.field_145850_b.func_180501_a(this.field_174879_c.func_177984_a(), (BlockState)((Block)Registry.NOTICE_BOARD.get()).func_176223_P().func_206870_a((Property)NoticeBoardBlock.FACING, (Comparable)Direction.Plane.HORIZONTAL.func_179518_a(this.func_145831_w().field_73012_v)), 3);
            }
            world.func_180501_a(this.field_174879_c, topState, 3);
        }
    }
}

