/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.block.tiles.NoticeBoardBlockTile;
import net.mehvahdjukaar.supplementaries.block.tiles.PulleyBlockTile;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SoundType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class PulleyBlock
extends RotatedPillarBlock {
    public static final EnumProperty<BlockProperties.Winding> TYPE = BlockProperties.WINDING;
    public static final BooleanProperty FLIPPED = BlockProperties.FLIPPED;

    public PulleyBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_176298_M, (Comparable)Direction.Axis.Y)).func_206870_a(TYPE, (Comparable)((Object)BlockProperties.Winding.NONE))).func_206870_a((Property)FLIPPED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{TYPE, FLIPPED});
    }

    public boolean axisRotate(BlockState state, BlockPos pos, World world, Rotation rot) {
        world.func_175656_a(pos, (BlockState)state.func_235896_a_((Property)FLIPPED));
        if (rot == Rotation.CLOCKWISE_90) {
            return this.pullUp(pos, (IWorld)world, 1);
        }
        return this.pullDown(pos, (IWorld)world, 1);
    }

    public boolean pullUp(BlockPos pos, IWorld world, int rot) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof PulleyBlockTile) {
            if (!(world instanceof World)) {
                return false;
            }
            ItemStack stack = ((ItemDisplayTile)tile).getDisplayedItem();
            boolean flag = false;
            if (stack.func_190926_b()) {
                stack = new ItemStack((IItemProvider)world.func_180495_p(pos.func_177977_b()).func_177230_c().func_199767_j());
                flag = true;
            }
            if (stack.func_190916_E() + rot > stack.func_77976_d() || !(stack.func_77973_b() instanceof BlockItem)) {
                return false;
            }
            Block ropeBlock = ((BlockItem)stack.func_77973_b()).func_179223_d();
            boolean success = RopeBlock.removeRope(pos.func_177977_b(), (World)world, ropeBlock);
            if (success) {
                SoundType soundtype = ropeBlock.func_176223_P().getSoundType((IWorldReader)world, pos, null);
                world.func_184133_a(null, pos, soundtype.func_185845_c(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                if (flag) {
                    ((ItemDisplayTile)tile).setDisplayedItem(stack);
                } else {
                    stack.func_190917_f(1);
                }
                tile.func_70296_d();
            }
            return success;
        }
        return false;
    }

    public boolean pullDown(BlockPos pos, IWorld world, int rot) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof PulleyBlockTile) {
            if (!(world instanceof World)) {
                return false;
            }
            ItemStack stack = ((ItemDisplayTile)tile).getDisplayedItem();
            if (stack.func_190916_E() < rot || !(stack.func_77973_b() instanceof BlockItem)) {
                return false;
            }
            Block ropeBlock = ((BlockItem)stack.func_77973_b()).func_179223_d();
            boolean success = RopeBlock.addRope(pos.func_177977_b(), (World)world, null, Hand.MAIN_HAND, ropeBlock);
            if (success) {
                SoundType soundtype = ropeBlock.func_176223_P().getSoundType((IWorldReader)world, pos, null);
                world.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                stack.func_190918_g(1);
                tile.func_70296_d();
            }
            return success;
        }
        return false;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return super.func_196258_a(context);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof PulleyBlockTile) {
            if (!(!(player instanceof ServerPlayerEntity) || player.func_225608_bj_() && this.axisRotate(state, pos, worldIn, Rotation.COUNTERCLOCKWISE_90))) {
                player.func_213829_a((INamedContainerProvider)tileentity);
            }
            return ActionResultType.func_233537_a_((boolean)worldIn.func_201670_d());
        }
        return ActionResultType.PASS;
    }

    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        return tileEntity instanceof INamedContainerProvider ? (INamedContainerProvider)tileEntity : null;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PulleyBlockTile();
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof IInventory) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileentity));
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof NoticeBoardBlockTile) {
            return Container.func_94526_b((IInventory)((IInventory)tileentity));
        }
        return 0;
    }
}

