/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.FireChargeItem;
import net.minecraft.item.FlintAndSteelItem;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class LightUpBlock
extends Block
implements IWaterLoggable {
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public LightUpBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true)));
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue() && fluidStateIn.func_206886_c() == Fluids.field_204546_a) {
            boolean flag = (Boolean)state.func_177229_b((Property)LIT);
            if (flag) {
                LightUpBlock.extinguish(state, pos, worldIn);
            }
            worldIn.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
            worldIn.func_205219_F_().func_205360_a(pos, (Object)fluidStateIn.func_206886_c(), fluidStateIn.func_206886_c().func_205569_a((IWorldReader)worldIn));
            return true;
        }
        return false;
    }

    public boolean func_225541_a_(BlockState state, Fluid fluid) {
        return this.field_149764_J.func_76222_j();
    }

    public void onChange(BlockState state, IWorld world, BlockPos pos) {
    }

    public static boolean lightUp(BlockState state, BlockPos pos, IWorld world, FireSound sound) {
        if (!((Boolean)state.func_177229_b((Property)LIT)).booleanValue() && !((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            if (!world.func_201670_d()) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true)), 11);
                sound.playSound(world, pos);
            }
            return true;
        }
        return false;
    }

    public static void extinguish(BlockState state, BlockPos pos, IWorld world) {
        if (!world.func_201670_d()) {
            world.func_184133_a(null, pos, SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 0.5f, 1.5f);
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(false)), 11);
        } else {
            Random random = world.func_201674_k();
            for (int i = 0; i < 10; ++i) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)((float)pos.func_177958_n() + 0.25f + random.nextFloat() * 0.5f), (double)((float)pos.func_177956_o() + 0.35f + random.nextFloat() * 0.5f), (double)((float)pos.func_177952_p() + 0.25f + random.nextFloat() * 0.5f), 0.0, 0.005, 0.0);
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!((Boolean)state.func_177229_b((Property)LIT)).booleanValue() && !((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue() && player.field_71075_bZ.field_75099_e) {
            ItemStack item2 = player.func_184586_b(handIn);
            if (item2.func_77973_b() instanceof FlintAndSteelItem) {
                if (LightUpBlock.lightUp(state, pos, (IWorld)worldIn, FireSound.FLINT_AND_STEEL)) {
                    this.onChange(state, (IWorld)worldIn, pos);
                    item2.func_222118_a(1, (LivingEntity)player, playerIn -> playerIn.func_213334_d(handIn));
                    return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
                }
            } else if (item2.func_77973_b() instanceof FireChargeItem && LightUpBlock.lightUp(state, pos, (IWorld)worldIn, FireSound.FIRE_CHANGE)) {
                this.onChange(state, (IWorld)worldIn, pos);
                item2.func_222118_a(1, (LivingEntity)player, playerIn -> playerIn.func_213334_d(handIn));
                if (!player.func_184812_l_()) {
                    item2.func_190918_g(1);
                }
                return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
            }
        }
        return ActionResultType.PASS;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof ProjectileEntity) {
            ProjectileEntity projectile = (ProjectileEntity)entityIn;
            if (projectile.func_70027_ad()) {
                Entity entity2 = projectile.func_234616_v_();
                if ((entity2 == null || entity2 instanceof PlayerEntity || ForgeEventFactory.getMobGriefingEvent((World)worldIn, (Entity)entity2)) && LightUpBlock.lightUp(state, pos, (IWorld)worldIn, FireSound.FLAMING_ARROW)) {
                    this.onChange(state, (IWorld)worldIn, pos);
                }
            } else if (projectile instanceof PotionEntity && PotionUtils.func_185191_c((ItemStack)((ProjectileItemEntity)projectile).func_184543_l()) == Potions.field_185230_b) {
                boolean flag;
                Entity entity3 = projectile.func_234616_v_();
                boolean bl = flag = entity3 == null || entity3 instanceof PlayerEntity || ForgeEventFactory.getMobGriefingEvent((World)worldIn, (Entity)entity3);
                if (flag && ((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
                    LightUpBlock.extinguish(state, pos, (IWorld)worldIn);
                    this.onChange(state, (IWorld)worldIn, pos);
                }
            }
        }
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return stateIn;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean flag = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        BlockState state = this.func_176223_P();
        return (BlockState)((BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(!flag));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT, WATERLOGGED});
    }

    public static enum FireSound {
        FLINT_AND_STEEL,
        FIRE_CHANGE,
        FLAMING_ARROW;


        public void playSound(IWorld world, BlockPos pos) {
            switch (this) {
                case FIRE_CHANGE: {
                    world.func_184133_a(null, pos, SoundEvents.field_187616_bj, SoundCategory.BLOCKS, 1.0f, (world.func_201674_k().nextFloat() - world.func_201674_k().nextFloat()) * 0.2f + 1.0f);
                    break;
                }
                case FLAMING_ARROW: {
                    world.func_184133_a(null, pos, SoundEvents.field_187616_bj, SoundCategory.BLOCKS, 0.5f, 1.4f);
                    break;
                }
                case FLINT_AND_STEEL: {
                    world.func_184133_a(null, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, world.func_201674_k().nextFloat() * 0.4f + 0.8f);
                }
            }
        }
    }
}

