/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class FlaxBlock
extends CropsBlock {
    private static final int DOUBLE_AGE = 4;
    private static final VoxelShape FULL_BOTTOM = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape[] SHAPES_BOTTOM = new VoxelShape[]{Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), FULL_BOTTOM, FULL_BOTTOM, FULL_BOTTOM};
    private static final VoxelShape[] SHAPES_TOP = new VoxelShape[]{FULL_BOTTOM, FULL_BOTTOM, FULL_BOTTOM, FULL_BOTTOM, Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)};
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;

    public FlaxBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)this.func_185524_e(), (Comparable)Integer.valueOf(0))).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            return SHAPES_BOTTOM[(Integer)state.func_177229_b((Property)field_176488_a)];
        }
        return SHAPES_TOP[(Integer)state.func_177229_b((Property)field_176488_a)];
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        if (!ClientConfigs.cached.TOOLTIP_HINTS) {
            return;
        }
    }

    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.NONE;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)stateIn.func_177229_b(HALF);
        if (facing.func_176740_k() != Direction.Axis.Y || half == DoubleBlockHalf.LOWER != (facing == Direction.UP) || !this.isDouble(stateIn) || facingState.func_203425_a((Block)this) && facingState.func_177229_b(HALF) != half) {
            return half == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public boolean isDouble(BlockState state) {
        return this.func_185527_x(state) >= 4;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            return super.func_196260_a(state, worldIn, pos);
        }
        if (!this.isDouble(state)) {
            return false;
        }
        BlockState blockstate = worldIn.func_180495_p(pos.func_177977_b());
        if (state.func_177230_c() != this) {
            return super.func_196260_a(state, worldIn, pos);
        }
        return blockstate.func_203425_a((Block)this) && blockstate.func_177229_b(HALF) == DoubleBlockHalf.LOWER && this.func_185527_x(state) == this.func_185527_x(blockstate);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!worldIn.field_72995_K) {
            if (player.func_184812_l_()) {
                FlaxBlock.removeBottomHalf(worldIn, pos, state, player);
            } else {
                FlaxBlock.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)player.func_184614_ca());
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, Blocks.field_150350_a.func_176223_P(), te, stack);
    }

    protected static void removeBottomHalf(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.func_177229_b(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = world.func_180495_p(blockpos = pos.func_177977_b())).func_177230_c() == state.func_177230_c() && blockstate.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            world.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{HALF});
    }

    public void placeAt(IWorld worldIn, BlockPos pos, int flags) {
        worldIn.func_180501_a(pos, (BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER), flags);
        worldIn.func_180501_a(pos.func_177984_a(), (BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), flags);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (state.func_177229_b(HALF) == DoubleBlockHalf.UPPER) {
            return;
        }
        if (worldIn.func_226659_b_(pos, 0) >= 9) {
            float f;
            int age = this.func_185527_x(state);
            if (this.func_176473_a((IBlockReader)worldIn, pos, state, worldIn.field_72995_K) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / (f = FlaxBlock.func_180672_a((Block)this, (IBlockReader)worldIn, (BlockPos)pos))) + 1) == 0 ? 1 : 0) != 0)) {
                if (age + 1 >= 4) {
                    worldIn.func_180501_a(pos.func_177984_a(), (BlockState)this.func_185528_e(age + 1).func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
                }
                worldIn.func_180501_a(pos, this.func_185528_e(age + 1), 2);
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public boolean canGrowUp(IBlockReader worldIn, BlockPos downPos) {
        BlockState state = worldIn.func_180495_p(downPos.func_177984_a());
        return state.func_177230_c() instanceof FlaxBlock || state.func_185904_a().func_76222_j();
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return !this.func_185525_y(state) && (this.canGrowUp(worldIn, pos) || this.func_185527_x(state) < 3);
    }

    public void func_176487_g(World worldIn, BlockPos pos, BlockState state) {
        int newAge = this.func_185527_x(state) + this.func_185529_b(worldIn);
        if ((newAge = Math.min(newAge, this.func_185526_g())) >= 4) {
            if (!this.canGrowUp((IBlockReader)worldIn, pos)) {
                return;
            }
            worldIn.func_180501_a(pos.func_177984_a(), (BlockState)this.func_185528_e(newAge).func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        }
        worldIn.func_180501_a(pos, this.func_185528_e(newAge), 2);
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)this.func_199767_j());
    }
}

