/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.block.blocks.SwayingBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.EnhancedLanternBlockTile;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class EnhancedLanternBlock
extends SwayingBlock {
    public static final VoxelShape SHAPE_SOUTH = VoxelShapes.func_197873_a((double)0.6875, (double)0.125, (double)0.625, (double)0.3125, (double)1.0, (double)0.0);
    public static final VoxelShape SHAPE_NORTH = VoxelShapes.func_197873_a((double)0.3125, (double)0.125, (double)0.375, (double)0.6875, (double)1.0, (double)1.0);
    public static final VoxelShape SHAPE_WEST = VoxelShapes.func_197873_a((double)0.375, (double)0.125, (double)0.6875, (double)1.0, (double)1.0, (double)0.3125);
    public static final VoxelShape SHAPE_EAST = VoxelShapes.func_197873_a((double)0.625, (double)0.125, (double)0.3125, (double)0.0, (double)1.0, (double)0.6875);

    public EnhancedLanternBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)EXTENSION, (Comparable)Integer.valueOf(0)));
    }

    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        if (!ClientConfigs.cached.TOOLTIP_HINTS || !Minecraft.func_71410_x().field_71474_y.field_82882_x) {
            return;
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("message.supplementaries.wall_lantern").func_240699_a_(TextFormatting.GRAY).func_240699_a_(TextFormatting.ITALIC));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        if (context.func_196000_l() == Direction.UP || context.func_196000_l() == Direction.DOWN) {
            return null;
        }
        BlockPos blockpos = context.func_195995_a();
        World world = context.func_195991_k();
        BlockPos facingpos = blockpos.func_177972_a(context.func_196000_l().func_176734_d());
        BlockState facingState = world.func_180495_p(facingpos);
        boolean flag = world.func_204610_c(blockpos).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)this.getConnectedState(this.func_176223_P(), facingState, (IWorld)world, facingpos).func_206870_a((Property)FACING, (Comparable)context.func_196000_l())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        return blockstate.func_224755_d((IBlockReader)worldIn, blockpos, direction) || CommonUtil.getPostSize(blockstate, blockpos, worldIn) > 0;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EnhancedLanternBlockTile();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            default: {
                return SHAPE_SOUTH;
            }
            case NORTH: {
                return SHAPE_NORTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case EAST: 
        }
        return SHAPE_EAST;
    }
}

