/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import java.util.Random;
import net.mehvahdjukaar.supplementaries.block.blocks.LightUpBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.RopeBlock;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class CandelabraBlock
extends LightUpBlock {
    protected static final VoxelShape SHAPE_FLOOR = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0);
    protected static final VoxelShape SHAPE_WALL_NORTH = Block.func_208617_a((double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SHAPE_WALL_SOUTH = Block.func_208617_a((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)14.0, (double)5.0);
    protected static final VoxelShape SHAPE_WALL_WEST = Block.func_208617_a((double)11.0, (double)0.0, (double)5.0, (double)16.0, (double)14.0, (double)11.0);
    protected static final VoxelShape SHAPE_WALL_EAST = Block.func_208617_a((double)0.0, (double)0.0, (double)5.0, (double)5.0, (double)14.0, (double)11.0);
    protected static final VoxelShape SHAPE_CEILING = Block.func_208617_a((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.field_208158_K;

    public CandelabraBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true))).func_206870_a(FACE, (Comparable)AttachFace.FLOOR)).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean flag = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        for (Direction direction : context.func_196009_e()) {
            BlockState blockstate = direction.func_176740_k() == Direction.Axis.Y ? (BlockState)((BlockState)this.func_176223_P().func_206870_a(FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).func_206870_a((Property)FACING, (Comparable)context.func_195992_f()) : (BlockState)((BlockState)this.func_176223_P().func_206870_a(FACE, (Comparable)AttachFace.WALL)).func_206870_a((Property)FACING, (Comparable)direction.func_176734_d());
            if (!blockstate.func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) continue;
            return (BlockState)((BlockState)blockstate.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(!flag));
        }
        return null;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACE, FACING});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((AttachFace)state.func_177229_b(FACE)) {
            default: {
                return SHAPE_FLOOR;
            }
            case WALL: {
                switch ((Direction)state.func_177229_b((Property)FACING)) {
                    default: {
                        return SHAPE_WALL_NORTH;
                    }
                    case SOUTH: {
                        return SHAPE_WALL_SOUTH;
                    }
                    case WEST: {
                        return SHAPE_WALL_WEST;
                    }
                    case EAST: 
                }
                return SHAPE_WALL_EAST;
            }
            case CEILING: 
        }
        return SHAPE_CEILING;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        if (state.func_177229_b(FACE) == AttachFace.FLOOR) {
            return CandelabraBlock.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177977_b(), (Direction)Direction.UP);
        }
        if (state.func_177229_b(FACE) == AttachFace.CEILING) {
            return RopeBlock.isSupportingCeiling(pos.func_177984_a(), worldIn);
        }
        return CandelabraBlock.isSideSolidForDirection(worldIn, pos, ((Direction)state.func_177229_b((Property)FACING)).func_176734_d());
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double zr;
        double xr;
        double zl;
        double yl;
        double xl;
        double zm;
        double ym;
        double xm;
        if (!((Boolean)stateIn.func_177229_b((Property)LIT)).booleanValue()) {
            return;
        }
        Direction dir1 = (Direction)stateIn.func_177229_b((Property)FACING);
        Direction dir = dir1.func_176746_e();
        double xOff = (double)dir.func_82601_c() * 0.3125;
        double zOff = (double)dir.func_82599_e() * 0.3125;
        switch ((AttachFace)stateIn.func_177229_b(FACE)) {
            default: {
                xm = (double)pos.func_177958_n() + 0.5;
                ym = (double)pos.func_177956_o() + 1.0;
                zm = (double)pos.func_177952_p() + 0.5;
                xl = (double)pos.func_177958_n() + 0.5 - xOff;
                yl = (double)pos.func_177956_o() + 0.9375;
                zl = (double)pos.func_177952_p() + 0.5 - zOff;
                xr = (double)pos.func_177958_n() + 0.5 + xOff;
                zr = (double)pos.func_177952_p() + 0.5 + zOff;
                break;
            }
            case WALL: {
                double xo1 = (double)(-dir1.func_82601_c()) * 0.3125;
                double zo2 = (double)(-dir1.func_82599_e()) * 0.3125;
                xm = (double)pos.func_177958_n() + 0.5 + xo1;
                ym = pos.func_177956_o() + 1;
                zm = (double)pos.func_177952_p() + 0.5 + zo2;
                xl = (double)pos.func_177958_n() + 0.5 + xo1 - xOff;
                yl = (double)pos.func_177956_o() + 0.9375;
                zl = (double)pos.func_177952_p() + 0.5 + zo2 - zOff;
                xr = (double)pos.func_177958_n() + 0.5 + xo1 + xOff;
                zr = (double)pos.func_177952_p() + 0.5 + zo2 + zOff;
                break;
            }
            case CEILING: {
                xm = (double)pos.func_177958_n() + 0.5 + zOff;
                zm = (double)pos.func_177952_p() + 0.5 - xOff;
                ym = (double)pos.func_177956_o() + 0.875;
                xl = (double)pos.func_177958_n() + 0.5 + xOff;
                zl = (double)pos.func_177952_p() + 0.5 + zOff;
                xr = (double)pos.func_177958_n() + 0.5 - zOff;
                zr = (double)pos.func_177952_p() + 0.5 + xOff;
                yl = (double)pos.func_177956_o() + 0.8125;
                double xs = (double)pos.func_177958_n() + 0.5 - xOff;
                double zs = (double)pos.func_177952_p() + 0.5 - zOff;
                double ys = (double)pos.func_177956_o() + 0.75;
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, xs, ys, zs, 0.0, 0.0, 0.0);
            }
        }
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, xm, ym, zm, 0.0, 0.0, 0.0);
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, xl, yl, zl, 0.0, 0.0, 0.0);
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, xr, yl, zr, 0.0, 0.0, 0.0);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return CandelabraBlock.getFacing(stateIn).func_176734_d() == facing && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected static Direction getFacing(BlockState state) {
        switch ((AttachFace)state.func_177229_b(FACE)) {
            case CEILING: {
                return Direction.DOWN;
            }
            case FLOOR: {
                return Direction.UP;
            }
        }
        return (Direction)state.func_177229_b((Property)FACING);
    }

    public static boolean isSideSolidForDirection(IWorldReader reader, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.func_177972_a(direction);
        return reader.func_180495_p(blockpos).func_224755_d((IBlockReader)reader, blockpos, direction.func_176734_d());
    }
}

