/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.network;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.network.AbstractPacket;

public class PacketHandler {
    private static final Logger logger = LogManager.getLogger();
    private static final String PROTOCOL_VERSION = "1";
    private final SimpleChannel channel;
    private final ArrayList<Class<? extends AbstractPacket>> packets = new ArrayList();

    public PacketHandler(String namespace, String channelId) {
        this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(namespace, channelId), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
    }

    public <T extends AbstractPacket> boolean registerPacket(Class<T> packetClass, Supplier<T> supplier) {
        if (this.packets.size() > 256) {
            logger.warn("Attempted to register packet but packet list is full: " + packetClass.toString());
            return false;
        }
        if (this.packets.contains(packetClass)) {
            logger.warn("Attempted to register packet but packet is already in list: " + packetClass.toString());
            return false;
        }
        this.channel.messageBuilder(packetClass, this.packets.size()).encoder(AbstractPacket::toBytes).decoder(buffer -> {
            AbstractPacket packet = (AbstractPacket)supplier.get();
            packet.fromBytes((PacketBuffer)buffer);
            return packet;
        }).consumer(this::onMessage).add();
        this.packets.add(packetClass);
        return true;
    }

    public AbstractPacket onMessage(AbstractPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                message.handle((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender());
            } else {
                message.handle(TetraMod.proxy.getClientPlayer());
            }
        });
        ctx.get().setPacketHandled(true);
        return null;
    }

    public void sendTo(AbstractPacket message, ServerPlayerEntity player) {
        this.channel.sendTo((Object)message, player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public void sendToAllPlayers(AbstractPacket message) {
        this.channel.send(PacketDistributor.ALL.noArg(), (Object)message);
    }

    public void sendToAllPlayersNear(AbstractPacket message, BlockPos pos, double r2, RegistryKey<World> dim) {
        this.channel.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)r2, dim)), (Object)message);
    }

    public void sendToServer(AbstractPacket message) {
        if (Minecraft.func_71410_x().func_147114_u() != null) {
            this.channel.sendToServer((Object)message);
        }
    }
}

