/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.data;

import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import se.mickelus.tetra.module.data.EffectData;
import se.mickelus.tetra.module.data.MaterialColors;
import se.mickelus.tetra.module.data.ToolData;
import se.mickelus.tetra.module.schematic.OutcomeMaterial;
import se.mickelus.tetra.properties.AttributeHelper;

public class MaterialData {
    public boolean replace = false;
    public String key;
    public String category = "misc";
    public boolean hidden = false;
    public boolean hiddenOutcomes = false;
    public Multimap<Attribute, AttributeModifier> attributes;
    public Float primary;
    public Float secondary;
    public Float tertiary;
    public float durability = 0.0f;
    public float integrityGain = 0.0f;
    public float integrityCost = 0.0f;
    public int magicCapacity = 0;
    public EffectData effects = new EffectData();
    public int toolLevel = 0;
    public float toolEfficiency = 0.0f;
    public MaterialColors tints;
    public String[] textures = new String[0];
    public boolean textureOverride = false;
    public OutcomeMaterial material;
    public ToolData requiredTools;
    public Map<String, Integer> improvements = new HashMap<String, Integer>();
    private static final MaterialData defaultValues = new MaterialData();

    public static void copyFields(MaterialData from, MaterialData to) {
        if (from.key != null) {
            to.key = from.key;
        }
        if (from.hidden != MaterialData.defaultValues.hidden) {
            to.hidden = from.hidden;
        }
        if (from.hiddenOutcomes != MaterialData.defaultValues.hiddenOutcomes) {
            to.hiddenOutcomes = from.hiddenOutcomes;
        }
        if (from.category != null) {
            to.category = from.category;
        }
        if (from.primary != null) {
            to.primary = from.primary;
        }
        if (from.secondary != null) {
            to.secondary = from.secondary;
        }
        if (from.tertiary != null) {
            to.tertiary = from.tertiary;
        }
        if (from.durability != MaterialData.defaultValues.durability) {
            to.durability = from.durability;
        }
        if (from.integrityGain != MaterialData.defaultValues.integrityGain) {
            to.integrityGain = from.integrityGain;
        }
        if (from.integrityCost != MaterialData.defaultValues.integrityCost) {
            to.integrityCost = from.integrityCost;
        }
        if (from.magicCapacity != MaterialData.defaultValues.magicCapacity) {
            to.magicCapacity = from.magicCapacity;
        }
        if (from.toolLevel != MaterialData.defaultValues.toolLevel) {
            to.toolLevel = from.toolLevel;
        }
        if (from.toolEfficiency != MaterialData.defaultValues.toolEfficiency) {
            to.toolEfficiency = from.toolEfficiency;
        }
        if (from.tints != null) {
            to.tints = from.tints;
        }
        if (from.textureOverride != MaterialData.defaultValues.textureOverride) {
            to.textureOverride = from.textureOverride;
        }
        to.attributes = AttributeHelper.overwrite(to.attributes, from.attributes);
        to.effects = EffectData.overwrite(to.effects, from.effects);
        to.requiredTools = ToolData.overwrite(to.requiredTools, from.requiredTools);
        if (from.material != null) {
            to.material = from.material;
        }
        to.textures = (String[])Stream.concat(Arrays.stream(to.textures), Arrays.stream(from.textures)).distinct().toArray(String[]::new);
        if (from.improvements != null) {
            if (to.improvements != null) {
                HashMap<String, Integer> merged = new HashMap<String, Integer>();
                merged.putAll(to.improvements);
                merged.putAll(from.improvements);
                to.improvements = merged;
            } else {
                to.improvements = from.improvements;
            }
        }
    }

    public MaterialData shallowCopy() {
        MaterialData copy = new MaterialData();
        MaterialData.copyFields(this, copy);
        return copy;
    }
}

