/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.data.ImprovementData;
import se.mickelus.tetra.module.data.ModuleData;
import se.mickelus.tetra.module.data.ModuleModel;
import se.mickelus.tetra.module.data.TweakData;
import se.mickelus.tetra.util.Filter;

public class MultiSlotMajorModule
extends ItemModuleMajor {
    protected String slotSuffix;
    protected String unlocalizedName;

    public MultiSlotMajorModule(ResourceLocation identifier, ModuleData data) {
        super(data.slots[0], identifier.func_110623_a());
        this.slotSuffix = data.slotSuffixes[0];
        this.unlocalizedName = identifier.func_110623_a().substring(0, identifier.func_110623_a().length() - data.slotSuffixes[0].length());
        this.renderLayer = data.renderLayer;
        this.variantData = data.variants;
        if (data.improvements.length > 0) {
            this.improvements = (ImprovementData[])Arrays.stream(data.improvements).map(rl -> rl.func_110623_a().endsWith("/") ? DataManager.improvementData.getDataIn((ResourceLocation)rl) : (Collection)Optional.ofNullable(DataManager.improvementData.getData((ResourceLocation)rl)).map(Collections::singletonList).orElseGet(Collections::emptyList)).flatMap(Collection::stream).filter(Objects::nonNull).flatMap(Arrays::stream).filter(Filter.distinct(improvement -> improvement.key + ":" + improvement.level)).toArray(ImprovementData[]::new);
            this.settleMax = Arrays.stream(this.improvements).filter(improvement -> improvement.key.equals("settled")).mapToInt(ImprovementData::getLevel).max().orElse(0);
        }
        if (data.tweakKey != null) {
            TweakData[] tweaks = DataManager.tweakData.getData(data.tweakKey);
            this.tweaks = tweaks != null ? tweaks : new TweakData[0];
        }
    }

    @Override
    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    @Override
    protected ModuleModel[] getImprovementModels(ItemStack itemStack, int tint) {
        return super.getImprovementModels(itemStack, tint);
    }

    @Override
    public ModuleModel[] getModels(ItemStack itemStack) {
        return (ModuleModel[])Arrays.stream(super.getModels(itemStack)).map(model -> new ModuleModel(model.type, new ResourceLocation("tetra", model.location.func_110623_a() + this.slotSuffix), model.tint)).toArray(ModuleModel[]::new);
    }
}

