/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt.suspend;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.BeaconTileEntity;
import net.minecraft.util.math.vector.Vector3d;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltHelper;
import se.mickelus.tetra.items.modular.impl.toolbelt.suspend.SuspendPotionEffect;

public class SuspendEffect {
    private static final Set<Effect> enablingEffects = Stream.concat(Arrays.stream(BeaconTileEntity.field_146009_a).flatMap(Arrays::stream), Stream.of(Effects.field_205136_C)).collect(Collectors.toSet());

    public static void toggleSuspend(PlayerEntity entity, boolean toggleOn) {
        if (toggleOn) {
            if (SuspendEffect.canSuspend(entity)) {
                Vector3d motion = entity.func_213322_ci();
                entity.func_213293_j(motion.field_72450_a, 0.0, motion.field_72449_c);
                entity.field_70133_I = true;
                entity.func_195064_c(new EffectInstance((Effect)SuspendPotionEffect.instance, 100, 0, false, false));
            }
        } else {
            entity.func_195063_d((Effect)SuspendPotionEffect.instance);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canSuspend(PlayerEntity entity) {
        ItemStack itemStack = ToolbeltHelper.findToolbelt(entity);
        if (itemStack.func_190926_b()) return false;
        if (((IModularItem)itemStack.func_77973_b()).getEffectLevel(itemStack, ItemEffect.suspendSelf) <= 0) return false;
        boolean bl = true;
        boolean hasEffect = bl;
        if (!hasEffect) return false;
        if (!entity.func_70651_bq().stream().filter(EffectInstance::func_82720_e).map(EffectInstance::func_188419_a).anyMatch(enablingEffects::contains)) return false;
        return true;
    }
}

