/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiStringSmall;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.gui.stats.sorting.IStatSorter;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloVariantItemGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloVariantMajorItemGui;
import se.mickelus.tetra.module.schematic.OutcomePreview;
import se.mickelus.tetra.module.schematic.SchematicType;

public class HoloVariantGroupGui
extends GuiElement {
    private final GuiElement variantsContainer;
    private final KeyframeAnimation labelAnimation;
    private final KeyframeAnimation[] itemAnimations;

    public HoloVariantGroupGui(int x, int y, String category, List<OutcomePreview> outcomes, int offset, IStatSorter sorter, PlayerEntity player, Consumer<OutcomePreview> onVariantHover, Consumer<OutcomePreview> onVariantBlur, Consumer<OutcomePreview> onVariantSelect) {
        super(x, y, 0, 50);
        GuiStringSmall label = new GuiStringSmall(0, 0, I18n.func_135052_a((String)("tetra.variant_category." + category + ".label"), (Object[])new Object[0]));
        label.setColor(0x7F7F7F);
        this.addChild((GuiElement)label);
        this.variantsContainer = new GuiElement(0, 8, this.width, this.height);
        this.addChild(this.variantsContainer);
        this.labelAnimation = new KeyframeAnimation(100, (GuiElement)label).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateX((float)(x - 5), (float)x)}).withDelay(40 * offset);
        int width = 0;
        this.itemAnimations = new KeyframeAnimation[outcomes.size()];
        for (int i = 0; i < outcomes.size(); ++i) {
            HoloVariantItemGui variant;
            OutcomePreview outcome = outcomes.get(i);
            if (SchematicType.minor.equals((Object)outcome.type)) {
                variant = new HoloVariantItemGui(i / 2 * 15, i % 2 * 15, outcome, sorter.getValue(player, outcome.itemStack), onVariantHover, onVariantBlur, onVariantSelect);
                this.variantsContainer.addChild((GuiElement)variant);
                this.itemAnimations[i] = new KeyframeAnimation(80, (GuiElement)variant).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateY(-5.0f, 0.0f, true)}).withDelay(40 + 40 * (offset + i / 2));
                width = variant.getX() + variant.getWidth();
                continue;
            }
            variant = new HoloVariantMajorItemGui(i / 2 * 20 + i % 2 * 10, i % 2 * 15, outcome, sorter.getValue(player, outcome.itemStack), onVariantHover, onVariantBlur, onVariantSelect);
            this.variantsContainer.addChild((GuiElement)variant);
            this.itemAnimations[i] = new KeyframeAnimation(80, (GuiElement)variant).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateX(-5.0f, 0.0f, true), new Applier.TranslateY(-5.0f, 0.0f, true)}).withDelay(40 + 40 * (offset + i / 2));
            width = variant.getX() + variant.getWidth() - i % 2 * 5;
        }
        this.setWidth(Math.max(width, label.getWidth()));
    }

    public void updateSelection(OutcomePreview outcome) {
        this.variantsContainer.getChildren(HoloVariantItemGui.class).forEach(variant -> variant.updateSelection(outcome));
    }

    public void animateIn() {
        this.labelAnimation.start();
        Arrays.stream(this.itemAnimations).forEach(KeyframeAnimation::start);
    }
}

