/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.mgui.gui.impl.GuiHorizontalLayoutGroup;
import se.mickelus.mgui.gui.impl.GuiHorizontalScrollable;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloMaterialDetailGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloMaterialGroupGui;
import se.mickelus.tetra.module.data.MaterialData;

public class HoloMaterialListGui
extends GuiElement {
    private GuiHorizontalScrollable groupsScroll;
    private GuiHorizontalLayoutGroup groups;
    private HoloMaterialDetailGui detail;
    private MaterialData selectedItem;
    private MaterialData hoveredItem;
    private KeyframeAnimation openAnimation;

    public HoloMaterialListGui(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.groupsScroll = new GuiHorizontalScrollable(0, 0, width, 75).setGlobal(true);
        this.addChild((GuiElement)this.groupsScroll);
        this.groups = new GuiHorizontalLayoutGroup(0, 0, 75, 12);
        this.groupsScroll.addChild((GuiElement)this.groups);
        this.detail = new HoloMaterialDetailGui(0, 76, width);
        this.detail.setVisible(false);
        this.addChild(this.detail);
        this.openAnimation = new KeyframeAnimation(200, (GuiElement)this).applyTo(new Applier[]{new Applier.TranslateY((float)(y - 4), (float)y), new Applier.Opacity(0.0f, 1.0f)}).withDelay(800);
        this.updateGroups();
    }

    protected void updateGroups() {
        this.groups.clearChildren();
        boolean isDevelopment = (Boolean)ConfigHandler.development.get();
        Map result = DataManager.materialData.getData().values().stream().filter(data -> data.material != null).filter(data -> !data.hidden).filter(data -> isDevelopment || data.material.getApplicableItemStacks().length > 0).collect(Collectors.groupingBy(data -> data.category, LinkedHashMap::new, Collectors.toList()));
        int offset = 0;
        for (Map.Entry entry : result.entrySet()) {
            this.groups.addChild((GuiElement)new HoloMaterialGroupGui(0, 0, (String)entry.getKey(), (List)entry.getValue(), offset, this::onHover, this::onBlur, this::onSelect));
            offset += ((List)entry.getValue()).size();
        }
        this.groupsScroll.markDirty();
    }

    protected void onShow() {
        this.onHover(null);
        this.groups.getChildren(HoloMaterialGroupGui.class).forEach(HoloMaterialGroupGui::animateIn);
    }

    public void animateOpen() {
        this.openAnimation.start();
    }

    private void onHover(MaterialData material) {
        this.hoveredItem = material;
        this.detail.update(this.selectedItem, this.hoveredItem);
    }

    private void onBlur(MaterialData material) {
        if (material.equals(this.hoveredItem)) {
            this.detail.update(this.selectedItem, null);
        }
    }

    private void onSelect(MaterialData material) {
        this.selectedItem = material;
        this.groups.getChildren(HoloMaterialGroupGui.class).forEach(group -> group.updateSelection(material));
        this.detail.update(this.selectedItem, this.hoveredItem);
    }

    public boolean onMouseClick(int x, int y, int button) {
        if (button == 1) {
            this.hoveredItem = null;
            this.onSelect(null);
            return true;
        }
        return super.onMouseClick(x, y, button);
    }

    public void reload() {
        this.updateGroups();
        if (this.isVisible()) {
            this.animateOpen();
        }
    }
}

