/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.effect.CritEffect;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.ItemEffectHandler;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.items.modular.impl.ModularSingleHeadedItem;
import se.mickelus.tetra.items.modular.impl.shield.ModularShieldItem;
import se.mickelus.tetra.util.CastOptional;

public class ThrownModularItemEntity
extends AbstractArrowEntity
implements IEntityAdditionalSpawnData {
    public static final String unlocalizedName = "thrown_modular_item";
    @ObjectHolder(value="tetra:thrown_modular_item")
    public static EntityType<ThrownModularItemEntity> type;
    private ItemStack thrownStack = new ItemStack((IItemProvider)Items.field_203184_eO);
    public static final String stackKey = "stack";
    public static final String dealtDamageKey = "dealtDamage";
    private static final DataParameter<Byte> LOYALTY_LEVEL;
    private boolean dealtDamage;
    public int returningTicks;
    private IntOpenHashSet hitEntities = new IntOpenHashSet(5);
    private int hitBlocks;

    public ThrownModularItemEntity(EntityType<? extends ThrownModularItemEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public ThrownModularItemEntity(World worldIn, LivingEntity thrower, ItemStack thrownStackIn) {
        super(type, thrower, worldIn);
        this.thrownStack = thrownStackIn.func_77946_l();
        this.field_70180_af.func_187227_b(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.func_203191_f((ItemStack)thrownStackIn)));
        CastOptional.cast(this.thrownStack.func_77973_b(), ItemModularHandheld.class).ifPresent(item -> {
            double critModifier = CritEffect.rollMultiplier(thrower.func_70681_au(), item, this.thrownStack);
            this.func_213872_b((byte)Math.round((double)this.getEffectLevel(ItemEffect.piercing) * critModifier));
            if (critModifier != 1.0 && this.field_70170_p instanceof ServerWorld) {
                Vector3d pos = thrower.func_174824_e(0.0f).func_178787_e(thrower.func_70040_Z());
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197622_o, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), 15, 0.2, 0.2, 0.2, 0.0);
            }
        });
        if (this.thrownStack.func_77973_b() instanceof ModularSingleHeadedItem) {
            this.func_213869_a(SoundEvents.field_203269_ik);
        } else if (this.thrownStack.func_77973_b() instanceof ModularShieldItem) {
            this.func_213869_a(SoundEvents.field_187721_dT);
        } else {
            this.func_213869_a(SoundEvents.field_187733_dX);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ThrownModularItemEntity(World worldIn, double x, double y, double z) {
        super(type, x, y, z, worldIn);
    }

    public ThrownModularItemEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super(type, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LOYALTY_LEVEL, (Object)0);
    }

    public void func_70071_h_() {
        if (this.field_184552_b > 4) {
            this.dealtDamage = true;
        }
        Entity shooter = this.func_234616_v_();
        if ((this.dealtDamage || this.func_203047_q()) && shooter != null) {
            byte loyaltyLevel = (Byte)this.field_70180_af.func_187225_a(LOYALTY_LEVEL);
            if (loyaltyLevel > 0 && !this.shouldReturnToThrower()) {
                if (!this.field_70170_p.field_72995_K && this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            } else if (loyaltyLevel > 0) {
                this.func_203045_n(true);
                Vector3d Vector3d2 = new Vector3d(shooter.func_226277_ct_() - this.func_226277_ct_(), shooter.func_226280_cw_() - this.func_226278_cu_(), shooter.func_226281_cx_() - this.func_226281_cx_());
                this.func_226288_n_(this.func_226277_ct_(), this.func_226278_cu_() + Vector3d2.field_72448_b * 0.015 * (double)loyaltyLevel, this.func_226281_cx_());
                if (this.field_70170_p.field_72995_K) {
                    this.field_70137_T = this.func_226278_cu_();
                }
                double speed = 0.05 * (double)loyaltyLevel;
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.95).func_178787_e(Vector3d2.func_72432_b().func_186678_a(speed)));
                if (this.returningTicks == 0) {
                    this.func_184185_a(SoundEvents.field_203270_il, 10.0f, 1.0f);
                    this.func_213317_d(Vector3d2.func_186678_a(0.01));
                }
                ++this.returningTicks;
            }
        }
        super.func_70071_h_();
    }

    private boolean shouldReturnToThrower() {
        Entity entity = this.func_234616_v_();
        if (entity != null && entity.func_70089_S()) {
            return !(entity instanceof ServerPlayerEntity) || !entity.func_175149_v();
        }
        return false;
    }

    public boolean hasDealtDamage() {
        return this.dealtDamage;
    }

    public boolean func_233570_aj_() {
        return this.field_184552_b > 0;
    }

    private int getEffectLevel(ItemEffect effect) {
        return CastOptional.cast(this.thrownStack.func_77973_b(), IModularItem.class).map(item -> item.getEffectLevel(this.thrownStack, effect)).orElse(-1);
    }

    protected ItemStack func_184550_j() {
        return this.thrownStack.func_77946_l();
    }

    @Nullable
    protected EntityRayTraceResult func_213866_a(Vector3d startVec, Vector3d endVec) {
        return this.dealtDamage ? null : super.func_213866_a(startVec, endVec);
    }

    protected void func_70227_a(RayTraceResult rayTraceResult) {
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK && !this.dealtDamage) {
            double destroySpeed;
            BlockPos pos = ((BlockRayTraceResult)rayTraceResult).func_216350_a();
            Entity shooter = this.func_234616_v_();
            BlockState blockState = this.field_70170_p.func_180495_p(pos);
            ItemModularHandheld item = CastOptional.cast(this.thrownStack.func_77973_b(), ItemModularHandheld.class).orElse(null);
            if (ForgeHooks.isToolEffective((IWorldReader)this.field_70170_p, (BlockPos)pos, (ItemStack)this.thrownStack) && shooter instanceof PlayerEntity && item != null && (destroySpeed = (double)item.func_150893_a(this.thrownStack, blockState)) > 1.0 && destroySpeed * item.getEffectEfficiency(this.thrownStack, ItemEffect.throwable) > (double)blockState.func_185887_b((IBlockReader)this.field_70170_p, pos)) {
                boolean canPierce;
                if (shooter instanceof ServerPlayerEntity) {
                    EffectHelper.sendEventToPlayer((ServerPlayerEntity)shooter, 2001, pos, Block.func_196246_j((BlockState)blockState));
                }
                item.applyBreakEffects(this.thrownStack, this.field_70170_p, blockState, pos, (LivingEntity)((PlayerEntity)shooter));
                ++this.hitBlocks;
                boolean bl = canPierce = this.getEffectLevel(ItemEffect.piercingHarvest) > 0 && this.hitBlocks < this.func_213874_s();
                if (canPierce) {
                    this.func_213317_d(this.func_213322_ci().func_72432_b().func_186678_a((double)0.8f));
                } else {
                    this.dealtDamage = true;
                    super.func_70227_a(rayTraceResult);
                }
                this.breakBlock((PlayerEntity)shooter, pos, blockState);
                if (canPierce) {
                    this.hitAdditional();
                }
                return;
            }
        }
        super.func_70227_a(rayTraceResult);
    }

    private void hitAdditional() {
        Vector3d target;
        Vector3d position = this.func_213303_ch();
        BlockRayTraceResult rayTraceResult = this.field_70170_p.func_217299_a(new RayTraceContext(position, target = position.func_178787_e(this.func_213322_ci()), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK && !ForgeEventFactory.onProjectileImpact((AbstractArrowEntity)this, (RayTraceResult)rayTraceResult)) {
            this.func_70227_a((RayTraceResult)rayTraceResult);
        }
    }

    private void breakBlock(PlayerEntity shooter, BlockPos pos, BlockState blockState) {
        ItemStack currentItem = shooter.func_184614_ca();
        shooter.func_184611_a(Hand.MAIN_HAND, this.thrownStack);
        EffectHelper.breakBlock(this.field_70170_p, shooter, this.thrownStack, pos, blockState, true);
        shooter.func_184611_a(Hand.MAIN_HAND, currentItem);
    }

    protected void func_213868_a(EntityRayTraceResult raytrace) {
        BlockPos blockpos;
        Entity target = raytrace.func_216348_a();
        Entity shooter = this.func_234616_v_();
        PlayerEntity playerShooter = CastOptional.cast(shooter, PlayerEntity.class).orElse(null);
        DamageSource damagesource = DamageSource.func_203096_a((Entity)this, (Entity)(shooter == null ? this : shooter));
        SoundEvent soundevent = SoundEvents.field_203268_ij;
        int pierceLevel = this.getEffectLevel(ItemEffect.piercing);
        int ricochetLevel = this.getEffectLevel(ItemEffect.ricochet);
        if (pierceLevel > 0 || ricochetLevel > 0) {
            if (this.hitEntities == null) {
                this.hitEntities = new IntOpenHashSet(5);
            }
            if (this.hitEntities.contains(target.func_145782_y())) {
                return;
            }
            if (this.hitEntities.size() < pierceLevel || this.hitEntities.size() < ricochetLevel) {
                this.hitEntities.add(target.func_145782_y());
            } else {
                this.dealtDamage = true;
            }
        } else {
            this.dealtDamage = true;
        }
        ItemStack heldTemp = null;
        if (playerShooter != null) {
            heldTemp = playerShooter.func_184614_ca();
            playerShooter.func_184611_a(Hand.MAIN_HAND, this.thrownStack);
        }
        if (target instanceof LivingEntity && this.thrownStack.func_77973_b() instanceof ItemModularHandheld) {
            LivingEntity targetLivingEntity = (LivingEntity)target;
            ItemModularHandheld item = (ItemModularHandheld)this.thrownStack.func_77973_b();
            double critModifier = CritEffect.rollMultiplier(targetLivingEntity.func_70681_au(), item, this.thrownStack);
            double damage = item.getAbilityBaseDamage(this.thrownStack) * item.getEffectEfficiency(this.thrownStack, ItemEffect.throwable);
            damage += (double)EnchantmentHelper.func_152377_a((ItemStack)this.thrownStack, (CreatureAttribute)targetLivingEntity.func_70668_bt());
            if (target.func_70097_a(damagesource, (float)(damage *= critModifier))) {
                if (shooter instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a((LivingEntity)targetLivingEntity, (Entity)shooter);
                    EffectHelper.applyEnchantmentHitEffects(this.func_184550_j(), targetLivingEntity, (LivingEntity)shooter);
                    ItemEffectHandler.applyHitEffects(this.thrownStack, targetLivingEntity, (LivingEntity)shooter);
                    item.tickProgression((LivingEntity)shooter, this.thrownStack, 1);
                }
                this.func_184548_a(targetLivingEntity);
                if (critModifier != 1.0 && !this.field_70170_p.field_72995_K) {
                    Vector3d hitVec = raytrace.func_216347_e();
                    ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197622_o, hitVec.func_82615_a(), hitVec.func_82617_b(), hitVec.func_82616_c(), 15, 0.2, 0.2, 0.2, 0.0);
                }
            }
        }
        float f1 = 1.0f;
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_72911_I() && EnchantmentHelper.func_203192_h((ItemStack)this.thrownStack) && this.field_70170_p.func_226660_f_(blockpos = target.func_233580_cy_())) {
            LightningBoltEntity lightning = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(this.field_70170_p);
            lightning.func_233576_c_(Vector3d.func_237492_c_((Vector3i)blockpos));
            lightning.func_204809_d(shooter instanceof ServerPlayerEntity ? (ServerPlayerEntity)shooter : null);
            this.field_70170_p.func_217376_c((Entity)lightning);
            soundevent = SoundEvents.field_203275_iq;
            f1 = 5.0f;
        }
        if (playerShooter != null) {
            playerShooter.func_184611_a(Hand.MAIN_HAND, heldTemp);
        }
        this.func_184185_a(soundevent, f1, 1.0f);
        if (this.dealtDamage) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(-0.01, -0.1, -0.01));
        } else if (ricochetLevel > 0 && !this.field_70170_p.field_72995_K) {
            Vector3d hitPos = raytrace.func_216347_e();
            this.func_226288_n_(hitPos.func_82615_a(), hitPos.func_82617_b(), hitPos.func_82616_c());
            this.func_213317_d(this.field_70170_p.func_175674_a(shooter, new AxisAlignedBB(target.func_233580_cy_()).func_186662_g(8.0), entity -> !this.hitEntities.contains(entity.func_145782_y()) && entity instanceof LivingEntity && !entity.func_180431_b(damagesource) && (shooter == null || !entity.func_184191_r(shooter))).stream().map(entity -> entity.func_213303_ch().func_72441_c(0.0, (double)entity.func_213302_cg() * 0.8, 0.0)).map(pos -> pos.func_178788_d(this.func_213303_ch())).min(Comparator.comparing(Vector3d::func_189985_c)).map(Vector3d::func_72432_b).map(direction -> direction.func_216372_d(1.0, 0.5, 1.0)).map(direction -> direction.func_186678_a(Math.max(this.func_213322_ci().func_72433_c() * 0.5, 0.3))).orElse(this.func_213322_ci().func_216372_d(-0.01, -0.1, -0.01)));
        }
    }

    protected boolean func_230298_a_(Entity target) {
        return super.func_230298_a_(target) && (this.hitEntities == null || !this.hitEntities.contains(target.func_145782_y()));
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        Entity entity = this.func_234616_v_();
        if (entity == null || entity.func_110124_au() == entityIn.func_110124_au()) {
            super.func_70100_b_(entityIn);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b(stackKey, 10)) {
            this.thrownStack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l(stackKey));
        }
        this.dealtDamage = compound.func_74767_n(dealtDamageKey);
        this.field_70180_af.func_187227_b(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.func_203191_f((ItemStack)this.thrownStack)));
        if (this.thrownStack.func_77973_b() instanceof ModularSingleHeadedItem) {
            this.func_213869_a(SoundEvents.field_203269_ik);
        } else if (this.thrownStack.func_77973_b() instanceof ModularShieldItem) {
            this.func_213869_a(SoundEvents.field_187721_dT);
        } else {
            this.func_213869_a(SoundEvents.field_187733_dX);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a(stackKey, (INBT)this.thrownStack.func_77955_b(new CompoundNBT()));
        compound.func_74757_a(dealtDamageKey, this.dealtDamage);
    }

    public void func_225516_i_() {
        byte level = (Byte)this.field_70180_af.func_187225_a(LOYALTY_LEVEL);
        if (this.field_70251_a != AbstractArrowEntity.PickupStatus.ALLOWED || level <= 0) {
            super.func_225516_i_();
        }
    }

    protected float func_203044_p() {
        return 0.99f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_150788_a(this.thrownStack);
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.thrownStack = buffer.func_150791_c();
    }

    static {
        LOYALTY_LEVEL = EntityDataManager.func_187226_a(ThrownModularItemEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    }
}

