/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.compat.botania.ManaRepair;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.items.TetraItem;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.data.EffectData;
import se.mickelus.tetra.module.data.ItemProperties;
import se.mickelus.tetra.module.data.SynergyData;
import se.mickelus.tetra.module.data.ToolData;
import se.mickelus.tetra.properties.IToolProvider;

public abstract class ModularItem
extends TetraItem
implements IModularItem,
IToolProvider {
    private static final Logger logger = LogManager.getLogger();
    protected int honeBase = 450;
    protected int honeIntegrityMultiplier = 200;
    protected boolean canHone = true;
    protected String[] majorModuleKeys;
    protected String[] minorModuleKeys;
    protected String[] requiredModules = new String[0];
    protected int baseDurability = 0;
    protected int baseIntegrity = 0;
    protected SynergyData[] synergies = new SynergyData[0];
    public static final UUID attackDamageModifier = Item.field_111210_e;
    public static final UUID attackSpeedModifier = Item.field_185050_h;
    private Cache<String, Multimap<Attribute, AttributeModifier>> attributeCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private Cache<String, ToolData> toolCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private Cache<String, EffectData> effectCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private Cache<String, ItemProperties> propertyCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();

    public ModularItem(Item.Properties properties) {
        super(properties);
        DataManager.moduleData.onReload(this::clearCaches);
    }

    @Override
    public void clearCaches() {
        logger.debug("Clearing item data caches for {}...", (Object)this.getRegistryName());
        this.attributeCache.invalidateAll();
        this.toolCache.invalidateAll();
        this.effectCache.invalidateAll();
        this.propertyCache.invalidateAll();
    }

    @Override
    public String[] getMajorModuleKeys() {
        return this.majorModuleKeys;
    }

    @Override
    public String[] getMinorModuleKeys() {
        return this.minorModuleKeys;
    }

    @Override
    public String[] getRequiredModules() {
        return this.requiredModules;
    }

    @Override
    public int getHoneBase() {
        return this.honeBase;
    }

    @Override
    public int getHoneIntegrityMultiplier() {
        return this.honeIntegrityMultiplier;
    }

    @Override
    public boolean canGainHoneProgress() {
        return this.canHone;
    }

    @Override
    public Cache<String, Multimap<Attribute, AttributeModifier>> getAttributeModifierCache() {
        return this.attributeCache;
    }

    @Override
    public Cache<String, EffectData> getEffectDataCache() {
        return this.effectCache;
    }

    @Override
    public Cache<String, ItemProperties> getPropertyCache() {
        return this.propertyCache;
    }

    public Cache<String, ToolData> getToolDataCache() {
        return this.toolCache;
    }

    @Override
    public Item getItem() {
        return this;
    }

    @Override
    public boolean canProvideTools(ItemStack itemStack) {
        return !this.isBroken(itemStack);
    }

    @Override
    public ToolData getToolData(ItemStack itemStack) {
        try {
            return (ToolData)this.getToolDataCache().get((Object)this.getDataCacheKey(itemStack), () -> Optional.ofNullable(this.getToolDataRaw(itemStack)).orElseGet(ToolData::new));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return Optional.ofNullable(this.getToolDataRaw(itemStack)).orElseGet(ToolData::new);
        }
    }

    protected ToolData getToolDataRaw(ItemStack itemStack) {
        logger.debug("Gathering tool data for {} ({})", (Object)this.func_200295_i(itemStack).getString(), (Object)this.getDataCacheKey(itemStack));
        return Stream.concat(this.getAllModules(itemStack).stream().map(module -> module.getToolData(itemStack)), Arrays.stream(this.getSynergyData(itemStack)).map(synergy -> synergy.tools)).filter(Objects::nonNull).reduce(null, ToolData::merge);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return new StringTextComponent(this.getItemName(stack));
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.addAll(this.getTooltip(stack, world, flag));
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int itemSlot, boolean isSelected) {
        ManaRepair.itemInventoryTick(itemStack, world, entity);
    }

    public int getMaxDamage(ItemStack itemStack) {
        return Optional.of(this.getPropertiesCached(itemStack)).map(properties -> Float.valueOf((float)(properties.durability + this.baseDurability) * properties.durabilityMultiplier)).map(Math::round).orElse(0);
    }

    public void setDamage(ItemStack itemStack, int damage) {
        super.setDamage(itemStack, Math.min(itemStack.func_77958_k() - 1, damage));
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return Math.min(stack.func_77958_k() - stack.func_77952_i() - 1, amount);
    }

    public void func_77622_d(ItemStack itemStack, World world, PlayerEntity player) {
        IModularItem.updateIdentifier(itemStack);
    }

    public boolean func_77636_d(@Nonnull ItemStack itemStack) {
        if (((Boolean)ConfigHandler.enableGlint.get()).booleanValue()) {
            return Arrays.stream(this.getImprovements(itemStack)).anyMatch(improvement -> improvement.enchantment);
        }
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @Override
    public SynergyData[] getAllSynergyData(ItemStack itemStack) {
        return this.synergies;
    }

    public boolean func_77616_k(ItemStack itemStack) {
        return this.canEnchantInEnchantingTable(itemStack);
    }

    public boolean isBookEnchantable(ItemStack itemStack, ItemStack bookStack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemStack, Enchantment enchantment) {
        return this.acceptsEnchantment(itemStack, enchantment);
    }

    public int getItemEnchantability(ItemStack itemStack) {
        return this.getEnchantability(itemStack);
    }
}

