/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular;

import com.google.common.cache.Cache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.UnbreakingEnchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.forgespi.Environment;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.Tooltips;
import se.mickelus.tetra.effect.EnderReverbEffect;
import se.mickelus.tetra.effect.FierySelfEffect;
import se.mickelus.tetra.effect.HauntedEffect;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.GuiModuleOffsets;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.data.EffectData;
import se.mickelus.tetra.module.data.EnchantmentMapping;
import se.mickelus.tetra.module.data.ImprovementData;
import se.mickelus.tetra.module.data.ItemProperties;
import se.mickelus.tetra.module.data.ModuleModel;
import se.mickelus.tetra.module.data.SynergyData;
import se.mickelus.tetra.module.data.VariantData;
import se.mickelus.tetra.module.improvement.DestabilizationEffect;
import se.mickelus.tetra.module.improvement.HonePacket;
import se.mickelus.tetra.module.schematic.RepairDefinition;
import se.mickelus.tetra.properties.AttributeHelper;
import se.mickelus.tetra.util.CastOptional;

public interface IModularItem {
    public static final Logger logger = LogManager.getLogger();
    public static final GuiModuleOffsets[] defaultMajorOffsets = new GuiModuleOffsets[]{new GuiModuleOffsets(new int[0]), new GuiModuleOffsets(4, 0), new GuiModuleOffsets(4, 0, 4, 18), new GuiModuleOffsets(4, 0, 4, 18, -4, 0), new GuiModuleOffsets(4, 0, 4, 18, -4, 0, -4, 18)};
    public static final GuiModuleOffsets[] defaultMinorOffsets = new GuiModuleOffsets[]{new GuiModuleOffsets(new int[0]), new GuiModuleOffsets(-21, 12), new GuiModuleOffsets(-18, 5, -18, 18), new GuiModuleOffsets(-12, -1, -21, 12, -12, 25)};
    public static final String identifierKey = "id";
    public static final String repairCountKey = "repairCount";
    public static final String cooledStrengthKey = "cooledStrength";
    public static final String honeProgressKey = "honing_progress";
    public static final String honeAvailableKey = "honing_available";
    public static final String honeCountKey = "honing_count";

    public Item getItem();

    default public ItemStack getDefaultStack() {
        return new ItemStack((IItemProvider)this.getItem());
    }

    public static void updateIdentifier(ItemStack itemStack) {
        IModularItem.updateIdentifier(itemStack.func_196082_o());
    }

    public static void updateIdentifier(CompoundNBT nbt) {
        nbt.func_74778_a(identifierKey, UUID.randomUUID().toString());
    }

    @Nullable
    default public String getIdentifier(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            return itemStack.func_77978_p().func_74779_i(identifierKey);
        }
        return null;
    }

    default public String getDataCacheKey(ItemStack itemStack) {
        return Optional.ofNullable(this.getIdentifier(itemStack)).filter(id -> !id.isEmpty()).orElseGet(() -> itemStack.func_77942_o() ? itemStack.func_77978_p().toString() : "INVALID-" + this.getItem().getRegistryName());
    }

    default public String getModelCacheKey(ItemStack itemStack, LivingEntity entity) {
        return Optional.ofNullable(this.getIdentifier(itemStack)).filter(id -> !id.isEmpty()).orElseGet(() -> itemStack.func_77942_o() ? itemStack.func_77978_p().toString() : "INVALID-" + this.getItem().getRegistryName());
    }

    public void clearCaches();

    public String[] getMajorModuleKeys();

    public String[] getMinorModuleKeys();

    public String[] getRequiredModules();

    default public boolean isModuleRequired(String moduleSlot) {
        return ArrayUtils.contains((Object[])this.getRequiredModules(), (Object)moduleSlot);
    }

    default public Collection<ItemModule> getAllModules(ItemStack stack) {
        CompoundNBT stackTag = stack.func_77978_p();
        if (stackTag != null) {
            return Stream.concat(Arrays.stream(this.getMajorModuleKeys()), Arrays.stream(this.getMinorModuleKeys())).map(arg_0 -> ((CompoundNBT)stackTag).func_74779_i(arg_0)).map(ItemUpgradeRegistry.instance::getModule).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    default public ItemModuleMajor[] getMajorModules(ItemStack itemStack) {
        String[] majorModuleKeys = this.getMajorModuleKeys();
        ItemModuleMajor[] modules = new ItemModuleMajor[majorModuleKeys.length];
        CompoundNBT tag = itemStack.func_77978_p();
        if (tag != null) {
            for (int i = 0; i < majorModuleKeys.length; ++i) {
                String moduleName = tag.func_74779_i(majorModuleKeys[i]);
                ItemModule module = ItemUpgradeRegistry.instance.getModule(moduleName);
                if (!(module instanceof ItemModuleMajor)) continue;
                modules[i] = (ItemModuleMajor)module;
            }
        }
        return modules;
    }

    default public ItemModule[] getMinorModules(ItemStack itemStack) {
        String[] minorModuleKeys = this.getMinorModuleKeys();
        ItemModule[] modules = new ItemModule[minorModuleKeys.length];
        CompoundNBT tag = itemStack.func_77978_p();
        if (tag != null) {
            for (int i = 0; i < minorModuleKeys.length; ++i) {
                ItemModule module;
                String moduleName = tag.func_74779_i(minorModuleKeys[i]);
                modules[i] = module = ItemUpgradeRegistry.instance.getModule(moduleName);
            }
        }
        return modules;
    }

    default public int getNumMajorModules() {
        return this.getMajorModuleKeys().length;
    }

    default public String[] getMajorModuleNames() {
        return (String[])Arrays.stream(this.getMajorModuleKeys()).map(key -> I18n.func_135052_a((String)("tetra.slot." + key), (Object[])new Object[0])).toArray(String[]::new);
    }

    default public int getNumMinorModules() {
        return this.getMinorModuleKeys().length;
    }

    default public String[] getMinorModuleNames() {
        return (String[])Arrays.stream(this.getMinorModuleKeys()).map(key -> I18n.func_135052_a((String)("tetra.slot." + key), (Object[])new Object[0])).toArray(String[]::new);
    }

    public static void putModuleInSlot(ItemStack itemStack, String slot, String module, String moduleVariantKey, String moduleVariant) {
        CompoundNBT tag = itemStack.func_196082_o();
        tag.func_74778_a(slot, module);
        tag.func_74778_a(moduleVariantKey, moduleVariant);
    }

    public static void putModuleInSlot(ItemStack itemStack, String slot, String module, String moduleVariant) {
        CompoundNBT tag = itemStack.func_196082_o();
        tag.func_74778_a(slot, module);
        tag.func_74778_a(module + "_material", moduleVariant);
    }

    default public boolean hasModule(ItemStack itemStack, ItemModule module) {
        return this.getAllModules(itemStack).stream().anyMatch(module::equals);
    }

    default public ItemModule getModuleFromSlot(ItemStack itemStack, String slot) {
        return Optional.ofNullable(itemStack.func_77978_p()).map(tag -> tag.func_74779_i(slot)).map(ItemUpgradeRegistry.instance::getModule).orElse(null);
    }

    public static int getIntegrityGain(ItemStack itemStack) {
        return CastOptional.cast(itemStack.func_77973_b(), IModularItem.class).map(item -> item.getPropertiesCached(itemStack)).map(properties -> properties.integrity).orElse(0);
    }

    public static int getIntegrityCost(ItemStack itemStack) {
        return CastOptional.cast(itemStack.func_77973_b(), IModularItem.class).map(item -> item.getPropertiesCached(itemStack)).map(properties -> properties.integrityUsage).orElse(0);
    }

    default public void tickProgression(LivingEntity entity, ItemStack itemStack, int multiplier) {
        if (!((Boolean)ConfigHandler.moduleProgression.get()).booleanValue()) {
            return;
        }
        this.tickHoningProgression(entity, itemStack, multiplier);
        for (ItemModuleMajor module : this.getMajorModules(itemStack)) {
            module.tickProgression(entity, itemStack, multiplier);
        }
    }

    default public void tickHoningProgression(LivingEntity entity, ItemStack itemStack, int multiplier) {
        if (!((Boolean)ConfigHandler.moduleProgression.get()).booleanValue() || !this.canGainHoneProgress()) {
            return;
        }
        CompoundNBT tag = itemStack.func_196082_o();
        if (!IModularItem.isHoneable(itemStack)) {
            int honingProgress = tag.func_74764_b(honeProgressKey) ? tag.func_74762_e(honeProgressKey) : this.getHoningLimit(itemStack);
            tag.func_74768_a(honeProgressKey, honingProgress -= multiplier);
            if (honingProgress <= 0 && !IModularItem.isHoneable(itemStack)) {
                tag.func_74757_a(honeAvailableKey, true);
                if (entity instanceof ServerPlayerEntity) {
                    TetraMod.packetHandler.sendTo(new HonePacket(itemStack), (ServerPlayerEntity)entity);
                }
            }
        }
    }

    default public int getHoningProgress(ItemStack itemStack) {
        return Optional.ofNullable(itemStack.func_77978_p()).filter(tag -> tag.func_74764_b(honeProgressKey)).map(tag -> tag.func_74762_e(honeProgressKey)).orElseGet(() -> this.getHoningLimit(itemStack));
    }

    default public void setHoningProgress(ItemStack itemStack, int progress) {
        itemStack.func_196082_o().func_74768_a(honeProgressKey, progress);
    }

    default public int getHoningLimit(ItemStack itemStack) {
        float workableFactor = (100.0f - (float)this.getEffectLevel(itemStack, ItemEffect.workable)) / 100.0f;
        return (int)Math.max((float)(this.getHoneBase() + this.getHoneIntegrityMultiplier() * IModularItem.getIntegrityCost(itemStack)) * workableFactor, 1.0f);
    }

    public int getHoneBase();

    public int getHoneIntegrityMultiplier();

    default public int getHoningIntegrityPenalty(ItemStack itemStack) {
        return this.getHoneIntegrityMultiplier() * IModularItem.getIntegrityCost(itemStack);
    }

    default public int getHonedCount(ItemStack itemStack) {
        return Optional.ofNullable(itemStack.func_77978_p()).map(tag -> tag.func_74762_e(honeCountKey)).orElse(0);
    }

    public boolean canGainHoneProgress();

    public static boolean isHoneable(ItemStack itemStack) {
        return Optional.ofNullable(itemStack.func_77978_p()).map(tag -> tag.func_74764_b(honeAvailableKey)).orElse(false);
    }

    public static int getHoningSeed(ItemStack itemStack) {
        return Optional.ofNullable(itemStack.func_77978_p()).map(tag -> tag.func_74762_e(honeCountKey)).orElse(0);
    }

    public static void removeHoneable(ItemStack itemStack) {
        CompoundNBT tag = itemStack.func_77978_p();
        if (tag != null) {
            tag.func_82580_o(honeAvailableKey);
            tag.func_82580_o(honeProgressKey);
            tag.func_74768_a(honeCountKey, tag.func_74762_e(honeCountKey) + 1);
        }
    }

    default public void applyUsageEffects(LivingEntity entity, ItemStack itemStack, double multiplier) {
        this.applyPositiveUsageEffects(entity, itemStack, multiplier);
        this.applyNegativeUsageEffects(entity, itemStack, multiplier);
    }

    default public void applyPositiveUsageEffects(LivingEntity entity, ItemStack itemStack, double multiplier) {
        this.tickProgression(entity, itemStack, (int)multiplier);
    }

    default public void applyNegativeUsageEffects(LivingEntity entity, ItemStack itemStack, double multiplier) {
        HauntedEffect.perform(entity, itemStack, multiplier);
        FierySelfEffect.perform(entity, itemStack, multiplier);
        EnderReverbEffect.perform(entity, itemStack, multiplier);
    }

    default public void applyDamage(int amount, ItemStack itemStack, LivingEntity responsibleEntity) {
        int maxDamage;
        int damage = itemStack.func_77952_i();
        if (!this.isBroken(damage, maxDamage = itemStack.func_77958_k())) {
            int reducedAmount = this.getReducedDamage(amount, itemStack, responsibleEntity);
            itemStack.func_222118_a(reducedAmount, responsibleEntity, breaker -> breaker.func_213334_d(breaker.func_184600_cs()));
            if (this.isBroken(damage + reducedAmount, maxDamage) && !responsibleEntity.field_70170_p.field_72995_K) {
                responsibleEntity.func_213334_d(responsibleEntity.func_184600_cs());
                responsibleEntity.func_184185_a(SoundEvents.field_187769_eM, 1.0f, 1.0f);
            }
        }
    }

    default public int getReducedDamage(int amount, ItemStack itemStack, LivingEntity responsibleEntity) {
        if (amount > 0) {
            int level = this.getEffectLevel(itemStack, ItemEffect.unbreaking);
            int reduction = 0;
            if (level > 0) {
                for (int i = 0; i < amount; ++i) {
                    if (!UnbreakingEnchantment.func_92097_a((ItemStack)itemStack, (int)level, (Random)responsibleEntity.field_70170_p.field_73012_v)) continue;
                    ++reduction;
                }
            }
            return amount - reduction;
        }
        return amount;
    }

    default public boolean isBroken(ItemStack itemStack) {
        return this.isBroken(itemStack.func_77952_i(), itemStack.func_77958_k());
    }

    default public boolean isBroken(int damage, int maxDamage) {
        return maxDamage != 0 && damage >= maxDamage - 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public List<ITextComponent> getTooltip(ItemStack itemStack, @Nullable World world, ITooltipFlag advanced) {
        ArrayList tooltip = Lists.newArrayList();
        if (this.isBroken(itemStack)) {
            tooltip.add(new TranslationTextComponent("item.tetra.modular.broken").func_240701_a_(new TextFormatting[]{TextFormatting.DARK_RED, TextFormatting.ITALIC}));
        }
        if (Screen.func_231173_s_()) {
            tooltip.add(Tooltips.expanded);
            Arrays.stream(this.getMajorModules(itemStack)).filter(Objects::nonNull).forEach(module -> {
                tooltip.add(new StringTextComponent("\u00bb ").func_240699_a_(TextFormatting.DARK_GRAY).func_230529_a_((ITextComponent)new StringTextComponent(module.getName(itemStack)).func_240699_a_(TextFormatting.GRAY)));
                Arrays.stream(module.getImprovements(itemStack)).map(improvement -> String.format("  - %s", this.getImprovementTooltip(improvement.key, improvement.level, true))).map(StringTextComponent::new).map(textComponent -> textComponent.func_240699_a_(TextFormatting.DARK_GRAY)).forEach(tooltip::add);
            });
            Arrays.stream(this.getMinorModules(itemStack)).filter(Objects::nonNull).map(module -> new StringTextComponent(" * ").func_240699_a_(TextFormatting.DARK_GRAY).func_230529_a_((ITextComponent)new StringTextComponent(module.getName(itemStack)).func_240699_a_(TextFormatting.GRAY))).forEach(tooltip::add);
            if (((Boolean)ConfigHandler.moduleProgression.get()).booleanValue() && this.canGainHoneProgress()) {
                if (IModularItem.isHoneable(itemStack)) {
                    tooltip.add(new StringTextComponent(" > ").func_240699_a_(TextFormatting.AQUA).func_230529_a_((ITextComponent)new TranslationTextComponent("tetra.hone.available").func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.GRAY))));
                } else {
                    int progress = this.getHoningProgress(itemStack);
                    int base = this.getHoningLimit(itemStack);
                    String percentage = String.format("%.0f", Float.valueOf(100.0f * (float)(base - progress) / (float)base));
                    tooltip.add(new StringTextComponent(" > ").func_240699_a_(TextFormatting.DARK_AQUA).func_230529_a_((ITextComponent)new TranslationTextComponent("tetra.hone.progress", new Object[]{base - progress, base, percentage}).func_240699_a_(TextFormatting.GRAY)));
                }
            }
        } else {
            Arrays.stream(this.getMajorModules(itemStack)).filter(Objects::nonNull).flatMap(module -> Arrays.stream(module.getImprovements(itemStack))).filter(improvement -> improvement.enchantment).collect(Collectors.groupingBy(VariantData::getKey, Collectors.summingInt(ImprovementData::getLevel))).entrySet().stream().map(entry -> this.getImprovementTooltip((String)entry.getKey(), (Integer)entry.getValue(), false)).map(StringTextComponent::new).map(text -> text.func_240699_a_(TextFormatting.GRAY)).forEach(tooltip::add);
            tooltip.add(Tooltips.expand);
        }
        return tooltip;
    }

    default public String getImprovementTooltip(String key, int level, boolean clearFormatting) {
        if (clearFormatting) {
            return TextFormatting.func_110646_a((String)IModularItem.getImprovementName(key, level));
        }
        return IModularItem.getImprovementName(key, level);
    }

    public static String getImprovementName(String key, int level) {
        String name = null;
        if (I18n.func_188566_a((String)("tetra.improvement." + key + ".name"))) {
            name = I18n.func_135052_a((String)("tetra.improvement." + key + ".name"), (Object[])new Object[0]);
        } else {
            String materialKey;
            String templateKey;
            int lastSlash = key.lastIndexOf("/");
            if (lastSlash != -1 && I18n.func_188566_a((String)(templateKey = "tetra.improvement." + key.substring(0, lastSlash) + ".name")) && I18n.func_188566_a((String)(materialKey = "tetra.material." + key.substring(lastSlash + 1) + ".prefix"))) {
                name = StringUtils.capitalize((String)I18n.func_135052_a((String)templateKey, (Object[])new Object[]{I18n.func_135052_a((String)materialKey, (Object[])new Object[0]).toLowerCase()}));
            }
            if (name == null) {
                name = "tetra.improvement." + key + ".name";
            }
        }
        if (level > 0) {
            name = name + " " + I18n.func_135052_a((String)("enchantment.level." + level), (Object[])new Object[0]);
        }
        return name;
    }

    public static String getImprovementDescription(String key) {
        String splitKey;
        if (I18n.func_188566_a((String)("tetra.improvement." + key + ".description"))) {
            return I18n.func_135052_a((String)("tetra.improvement." + key + ".description"), (Object[])new Object[0]);
        }
        int lastSlash = key.lastIndexOf("/");
        if (lastSlash != -1 && I18n.func_188566_a((String)(splitKey = "tetra.improvement." + key.substring(0, lastSlash) + ".description"))) {
            return I18n.func_135052_a((String)splitKey, (Object[])new Object[0]);
        }
        return "tetra.improvement." + key + ".description";
    }

    default public Optional<ItemModule> getRepairModule(ItemStack itemStack) {
        List modules = this.getAllModules(itemStack).stream().filter(itemModule -> !itemModule.getRepairDefinitions(itemStack).isEmpty()).collect(Collectors.toList());
        if (modules.size() > 0) {
            int repairCount = this.getRepairCount(itemStack);
            return Optional.of(modules.get(repairCount % modules.size()));
        }
        return Optional.empty();
    }

    default public ItemModule[] getRepairCycle(ItemStack itemStack) {
        return (ItemModule[])this.getAllModules(itemStack).stream().filter(module -> !module.getRepairDefinitions(itemStack).isEmpty()).toArray(ItemModule[]::new);
    }

    default public String getRepairModuleName(ItemStack itemStack) {
        return this.getRepairModule(itemStack).map(module -> module.getName(itemStack)).orElse(null);
    }

    default public String getRepairSlot(ItemStack itemStack) {
        return this.getRepairModule(itemStack).map(ItemModule::getSlot).orElse(null);
    }

    default public Collection<RepairDefinition> getRepairDefinitions(ItemStack itemStack) {
        return this.getRepairModule(itemStack).map(module -> module.getRepairDefinitions(itemStack)).orElse(null);
    }

    default public int getRepairMaterialCount(ItemStack itemStack, ItemStack materialStack) {
        return this.getRepairModule(itemStack).map(module -> module.getRepairDefinition(itemStack, materialStack)).map(definition -> definition.material.count).orElse(0);
    }

    default public int getRepairAmount(ItemStack itemStack) {
        return this.getItem().getMaxDamage(itemStack);
    }

    default public Collection<ToolType> getRepairRequiredTools(ItemStack itemStack, ItemStack materialStack) {
        return this.getRepairModule(itemStack).map(module -> module.getRepairRequiredTools(itemStack, materialStack)).orElseGet(Collections::emptySet);
    }

    default public Map<ToolType, Integer> getRepairRequiredToolLevels(ItemStack itemStack, ItemStack materialStack) {
        return this.getRepairModule(itemStack).map(module -> module.getRepairRequiredToolLevels(itemStack, materialStack)).orElseGet(Collections::emptyMap);
    }

    default public int getRepairRequiredToolLevel(ItemStack itemStack, ItemStack materialStack, ToolType toolType) {
        return this.getRepairModule(itemStack).filter(module -> module.getRepairRequiredTools(itemStack, materialStack).contains(toolType)).map(module -> module.getRepairRequiredToolLevel(itemStack, materialStack, toolType)).map(level -> Math.max(1, level)).orElse(0);
    }

    default public int getRepairRequiredExperience(ItemStack itemStack) {
        return this.getRepairModule(itemStack).map(module -> module.getRepairExperienceCost(itemStack)).orElse(0);
    }

    default public int getRepairCount(ItemStack itemStack) {
        return Optional.ofNullable(itemStack.func_77978_p()).map(tag -> tag.func_74762_e(repairCountKey)).orElse(0);
    }

    default public void incrementRepairCount(ItemStack itemStack) {
        CompoundNBT tag = itemStack.func_196082_o();
        tag.func_74768_a(repairCountKey, tag.func_74762_e(repairCountKey) + 1);
    }

    default public void repair(ItemStack itemStack) {
        this.getItem().setDamage(itemStack, this.getItem().getDamage(itemStack) - this.getRepairAmount(itemStack));
        this.incrementRepairCount(itemStack);
    }

    default public Map<Enchantment, Integer> getEnchantmentsFromImprovements(ItemStack itemStack) {
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
        CastOptional.cast(itemStack.func_77973_b(), IModularItem.class).map(item -> Arrays.stream(item.getMajorModules(itemStack))).orElseGet(Stream::empty).filter(Objects::nonNull).flatMap(module -> Arrays.stream(module.getImprovements(itemStack))).forEach(improvement -> {
            for (EnchantmentMapping mapping : ItemUpgradeRegistry.instance.getEnchantmentMappings(improvement.key)) {
                enchantments.merge(mapping.enchantment, (int)((float)improvement.level * mapping.multiplier), Integer::sum);
            }
        });
        return enchantments;
    }

    default public int getEnchantmentLevelFromImprovements(ItemStack itemStack, Enchantment enchantment) {
        return Arrays.stream(this.getMajorModules(itemStack)).filter(Objects::nonNull).flatMap(module -> Arrays.stream(module.getImprovements(itemStack))).mapToInt(improvement -> (int)((float)Math.max(1, improvement.level) * Arrays.stream(ItemUpgradeRegistry.instance.getEnchantmentMappings(improvement.key)).filter(mapping -> enchantment.equals(mapping.enchantment)).map(mapping -> Float.valueOf(mapping.multiplier)).reduce(Float.valueOf(0.0f), Float::sum).floatValue())).sum();
    }

    default public int getEnchantmentLevelFromImprovements(ItemStack itemStack, String slot, Enchantment enchantment) {
        return CastOptional.cast(this.getModuleFromSlot(itemStack, slot), ItemModuleMajor.class).map(module -> Arrays.stream(module.getImprovements(itemStack))).orElseGet(Stream::empty).mapToInt(improvement -> (int)((float)Math.max(1, improvement.level) * Arrays.stream(ItemUpgradeRegistry.instance.getEnchantmentMappings(improvement.key)).filter(mapping -> enchantment.equals(mapping.enchantment)).map(mapping -> Float.valueOf(mapping.multiplier)).reduce(Float.valueOf(0.0f), Float::sum).floatValue())).sum();
    }

    default public int getEnchantmentLevelFromImprovements(ItemStack itemStack, String slot, String improvementKey, Enchantment enchantment) {
        return CastOptional.cast(this.getModuleFromSlot(itemStack, slot), ItemModuleMajor.class).map(module -> Arrays.stream(module.getImprovements(itemStack))).orElseGet(Stream::empty).filter(improvement -> improvementKey.equals(improvement.key)).mapToInt(improvement -> (int)((float)Math.max(1, improvement.level) * Arrays.stream(ItemUpgradeRegistry.instance.getEnchantmentMappings(improvement.key)).filter(mapping -> enchantment.equals(mapping.enchantment)).map(mapping -> Float.valueOf(mapping.multiplier)).reduce(Float.valueOf(0.0f), Float::sum).floatValue())).sum();
    }

    default public float getStabilityModifier(ItemStack itemStack) {
        return 1.0f + (float)(this.getEffectLevel(itemStack, ItemEffect.stabilizing) - this.getEffectLevel(itemStack, ItemEffect.unstable)) / 100.0f;
    }

    default public void applyDestabilizationEffects(ItemStack itemStack, World world, float probabilityMultiplier) {
        if (!world.field_72995_K) {
            Arrays.stream(this.getMajorModules(itemStack)).filter(Objects::nonNull).forEach(module -> {
                int instability = -module.getMagicCapacity(itemStack);
                if (instability > 0) {
                    float destabilizationChance = module.getDestabilizationChance(itemStack, probabilityMultiplier);
                    DestabilizationEffect[] possibleEffects = DestabilizationEffect.getEffectsForImprovement(instability, module.getImprovements(itemStack));
                    do {
                        if (!(destabilizationChance > world.field_73012_v.nextFloat())) continue;
                        DestabilizationEffect effect = possibleEffects[world.field_73012_v.nextInt(possibleEffects.length)];
                        int currentEffectLevel = module.getImprovementLevel(itemStack, effect.destabilizationKey);
                        int newLevel = currentEffectLevel >= 0 ? currentEffectLevel + 1 : (effect.minLevel == effect.maxLevel ? effect.minLevel : effect.minLevel + world.field_73012_v.nextInt(effect.maxLevel - effect.minLevel));
                        if (!module.acceptsImprovementLevel(effect.destabilizationKey, newLevel)) continue;
                        module.addImprovement(itemStack, effect.destabilizationKey, newLevel);
                    } while ((destabilizationChance -= 1.0f) > 1.0f);
                }
            });
        }
    }

    default public void tweak(ItemStack itemStack, String slot, Map<String, Integer> tweaks) {
        ItemModule module = this.getModuleFromSlot(itemStack, slot);
        double durabilityFactor = 0.0;
        if (module == null || !module.isTweakable(itemStack)) {
            return;
        }
        if (itemStack.func_77984_f()) {
            durabilityFactor = (double)itemStack.func_77952_i() * 1.0 / (double)itemStack.func_77958_k();
        }
        tweaks.forEach((tweakKey, step) -> {
            if (module.hasTweak(itemStack, (String)tweakKey)) {
                module.setTweakStep(itemStack, (String)tweakKey, (int)step);
            }
        });
        if (itemStack.func_77984_f()) {
            itemStack.func_196085_b((int)Math.ceil(durabilityFactor * (double)itemStack.func_77958_k() - durabilityFactor * durabilityFactor * (double)module.getDurability(itemStack)));
        }
        IModularItem.updateIdentifier(itemStack);
    }

    default public Multimap<Attribute, AttributeModifier> getEffectAttributes(ItemStack itemStack) {
        return AttributeHelper.emptyMap;
    }

    default public Multimap<Attribute, AttributeModifier> getModuleAttributes(ItemStack itemStack) {
        return this.getAllModules(itemStack).stream().map(module -> module.getAttributeModifiers(itemStack)).filter(Objects::nonNull).reduce(null, AttributeHelper::merge);
    }

    default public Multimap<Attribute, AttributeModifier> getAttributeModifiers(ItemStack itemStack) {
        Multimap<Attribute, AttributeModifier> attributes = AttributeHelper.merge(this.getModuleAttributes(itemStack), this.getEffectAttributes(itemStack));
        return Arrays.stream(this.getSynergyData(itemStack)).map(synergy -> synergy.attributes).filter(Objects::nonNull).reduce(attributes, AttributeHelper::merge);
    }

    default public Multimap<Attribute, AttributeModifier> getAttributeModifiersCollapsed(ItemStack itemStack) {
        if (logger.isDebugEnabled()) {
            logger.debug("Gathering attribute modifiers for {} ({})", (Object)this.getItemName(itemStack), (Object)this.getDataCacheKey(itemStack));
        }
        return Optional.ofNullable(this.getAttributeModifiers(itemStack)).map(modifiers -> (ArrayListMultimap)modifiers.asMap().entrySet().stream().collect(Multimaps.flatteningToMultimap(Map.Entry::getKey, entry -> AttributeHelper.collapse((Collection)entry.getValue()).stream(), ArrayListMultimap::create))).map(this::fixIdentifiers).orElse(null);
    }

    default public Multimap<Attribute, AttributeModifier> fixIdentifiers(Multimap<Attribute, AttributeModifier> modifiers) {
        return AttributeHelper.fixIdentifiers(modifiers);
    }

    public Cache<String, Multimap<Attribute, AttributeModifier>> getAttributeModifierCache();

    default public Multimap<Attribute, AttributeModifier> getAttributeModifiersCached(ItemStack itemStack) {
        try {
            return (Multimap)this.getAttributeModifierCache().get((Object)this.getDataCacheKey(itemStack), () -> Optional.ofNullable(this.getAttributeModifiersCollapsed(itemStack)).orElseGet(ImmutableMultimap::of));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return this.getAttributeModifiersCollapsed(itemStack);
        }
    }

    default public double getAttributeValue(ItemStack itemStack, Attribute attribute) {
        if (this.isBroken(itemStack)) {
            return 0.0;
        }
        return AttributeHelper.getMergedAmount(this.getAttributeModifiersCached(itemStack).get((Object)attribute));
    }

    default public double getAttributeValue(ItemStack itemStack, Attribute attribute, double base) {
        if (this.isBroken(itemStack)) {
            return 0.0;
        }
        return AttributeHelper.getMergedAmount(this.getAttributeModifiersCached(itemStack).get((Object)attribute), base);
    }

    default public EffectData getEffectData(ItemStack itemStack) {
        if (logger.isDebugEnabled()) {
            logger.debug("Gathering effect data for {} ({})", (Object)this.getItemName(itemStack), (Object)this.getDataCacheKey(itemStack));
        }
        return Stream.concat(this.getAllModules(itemStack).stream().map(module -> module.getEffectData(itemStack)), Arrays.stream(this.getSynergyData(itemStack)).map(synergy -> synergy.effects)).filter(Objects::nonNull).reduce(null, EffectData::merge);
    }

    public Cache<String, EffectData> getEffectDataCache();

    default public EffectData getEffectDataCached(ItemStack itemStack) {
        try {
            return (EffectData)this.getEffectDataCache().get((Object)this.getDataCacheKey(itemStack), () -> Optional.ofNullable(this.getEffectData(itemStack)).orElseGet(EffectData::new));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return Optional.ofNullable(this.getEffectData(itemStack)).orElseGet(EffectData::new);
        }
    }

    default public ItemProperties getProperties(ItemStack itemStack) {
        if (logger.isDebugEnabled()) {
            logger.debug("Gathering properties for {} ({})", (Object)this.getItemName(itemStack), (Object)this.getDataCacheKey(itemStack));
        }
        return Stream.concat(this.getAllModules(itemStack).stream().map(module -> module.getProperties(itemStack)), Arrays.stream(this.getSynergyData(itemStack))).reduce((SynergyData)new ItemProperties(), ItemProperties::merge);
    }

    public Cache<String, ItemProperties> getPropertyCache();

    default public ItemProperties getPropertiesCached(ItemStack itemStack) {
        try {
            return (ItemProperties)this.getPropertyCache().get((Object)this.getDataCacheKey(itemStack), () -> this.getProperties(itemStack));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return this.getProperties(itemStack);
        }
    }

    default public int getEffectLevel(ItemStack itemStack, ItemEffect effect) {
        if (this.isBroken(itemStack)) {
            return -1;
        }
        return this.getEffectDataCached(itemStack).getLevel(effect);
    }

    default public double getEffectEfficiency(ItemStack itemStack, ItemEffect effect) {
        if (this.isBroken(itemStack)) {
            return 0.0;
        }
        return this.getEffectDataCached(itemStack).getEfficiency(effect);
    }

    default public Collection<ItemEffect> getEffects(ItemStack itemStack) {
        if (this.isBroken(itemStack)) {
            return Collections.emptyList();
        }
        return this.getEffectDataCached(itemStack).getValues();
    }

    default public ImprovementData[] getImprovements(ItemStack itemStack) {
        return (ImprovementData[])Arrays.stream(this.getMajorModules(itemStack)).filter(Objects::nonNull).flatMap(module -> Arrays.stream(module.getImprovements(itemStack))).toArray(ImprovementData[]::new);
    }

    default public String getDisplayNamePrefixes(ItemStack itemStack) {
        return Stream.concat(Arrays.stream(this.getImprovements(itemStack)).map(improvement -> improvement.key + ".prefix").filter(I18n::func_188566_a).map(x$0 -> I18n.func_135052_a((String)x$0, (Object[])new Object[0])), this.getAllModules(itemStack).stream().sorted(Comparator.comparing(module -> module.getItemPrefixPriority(itemStack))).map(module -> module.getItemPrefix(itemStack)).filter(Objects::nonNull)).limit(2L).reduce("", (result, prefix) -> result + prefix + " ");
    }

    default public String getItemName(ItemStack itemStack) {
        if (Environment.get().getDist().isDedicatedServer()) {
            return "";
        }
        String name = Arrays.stream(this.getSynergyData(itemStack)).map(synergyData -> synergyData.name).filter(Objects::nonNull).map(key -> "tetra.synergy." + key).filter(I18n::func_188566_a).map(x$0 -> I18n.func_135052_a((String)x$0, (Object[])new Object[0])).findFirst().orElse(null);
        if (name == null) {
            name = this.getAllModules(itemStack).stream().sorted(Comparator.comparing(module -> module.getItemNamePriority(itemStack))).map(module -> module.getItemName(itemStack)).filter(Objects::nonNull).findFirst().orElse("");
        }
        String prefixes = this.getDisplayNamePrefixes(itemStack);
        return StringUtils.capitalize((String)(prefixes + name));
    }

    public SynergyData[] getAllSynergyData(ItemStack var1);

    default public SynergyData[] getSynergyData(ItemStack itemStack) {
        SynergyData[] synergies = this.getAllSynergyData(itemStack);
        if (synergies.length > 0) {
            ItemModule[] modules = (ItemModule[])this.getAllModules(itemStack).stream().sorted(Comparator.comparing(ItemModule::getUnlocalizedName)).toArray(ItemModule[]::new);
            String[] variantKeys = (String[])this.getAllModules(itemStack).stream().map(module -> module.getVariantData(itemStack)).map(data -> data.key).sorted().toArray(String[]::new);
            String[] improvements = (String[])Arrays.stream(this.getMajorModules(itemStack)).filter(Objects::nonNull).map(module -> module.getImprovements(itemStack)).flatMap(Arrays::stream).map(data -> data.key).sorted().toArray(String[]::new);
            return (SynergyData[])Arrays.stream(synergies).filter(synergy -> this.hasVariantSynergy((SynergyData)synergy, variantKeys) || this.hasModuleSynergy(itemStack, (SynergyData)synergy, modules)).filter(synergy -> synergy.improvements.length == 0 || this.hasImprovementSynergy((SynergyData)synergy, improvements)).toArray(SynergyData[]::new);
        }
        return new SynergyData[0];
    }

    default public boolean hasImprovementSynergy(SynergyData synergy, String[] improvements) {
        int improvementMatches = 0;
        for (String improvement : improvements) {
            if (improvementMatches == synergy.improvements.length) break;
            if (!improvement.equals(synergy.improvements[improvementMatches])) continue;
            ++improvementMatches;
        }
        return synergy.improvements.length > 0 && improvementMatches == synergy.improvements.length;
    }

    default public boolean hasVariantSynergy(SynergyData synergy, String[] variantKeys) {
        int variantMatches = 0;
        for (String variantKey : variantKeys) {
            if (variantMatches == synergy.moduleVariants.length) break;
            if (!variantKey.equals(synergy.moduleVariants[variantMatches])) continue;
            ++variantMatches;
        }
        return synergy.moduleVariants.length > 0 && variantMatches == synergy.moduleVariants.length;
    }

    default public boolean hasModuleSynergy(ItemStack itemStack, SynergyData synergy, ItemModule[] modules) {
        int moduleMatches = 0;
        String variant = null;
        if (synergy.sameVariant) {
            for (ItemModule module : modules) {
                if (moduleMatches != synergy.modules.length) {
                    String moduleKey;
                    String string = moduleKey = synergy.matchSuffixed ? module.getKey() : module.getUnlocalizedName();
                    if (!moduleKey.equals(synergy.modules[moduleMatches])) continue;
                    if (variant == null) {
                        variant = module.getVariantData((ItemStack)itemStack).key;
                    }
                    if (!variant.equals(module.getVariantData((ItemStack)itemStack).key)) continue;
                    ++moduleMatches;
                    continue;
                }
                break;
            }
        } else {
            for (ItemModule module : modules) {
                if (moduleMatches != synergy.modules.length) {
                    String moduleKey;
                    String string = moduleKey = synergy.matchSuffixed ? module.getKey() : module.getUnlocalizedName();
                    if (!moduleKey.equals(synergy.modules[moduleMatches])) continue;
                    ++moduleMatches;
                    continue;
                }
                break;
            }
        }
        return synergy.modules.length > 0 && moduleMatches == synergy.modules.length;
    }

    default public void assemble(ItemStack itemStack, @Nullable World world, float severity) {
        if (itemStack.func_77952_i() > itemStack.func_77958_k()) {
            itemStack.func_196085_b(itemStack.func_77958_k());
        }
        if (world != null) {
            this.applyDestabilizationEffects(itemStack, world, severity);
        }
        CompoundNBT nbt = itemStack.func_196082_o();
        nbt.func_74768_a("HideFlags", 1);
        EnchantmentHelper.func_82782_a(this.getEnchantmentsFromImprovements(itemStack), (ItemStack)itemStack);
        IModularItem.updateIdentifier(itemStack);
    }

    default public boolean hasEnchantments(ItemStack itemStack) {
        return Arrays.stream(this.getImprovements(itemStack)).anyMatch(improvement -> improvement.enchantment);
    }

    public static ItemStack removeAllEnchantments(ItemStack itemStack) {
        itemStack.func_196083_e("Enchantments");
        itemStack.func_196083_e("StoredEnchantments");
        Arrays.stream(((IModularItem)itemStack.func_77973_b()).getMajorModules(itemStack)).filter(Objects::nonNull).forEach(module -> module.removeEnchantments(itemStack));
        IModularItem.updateIdentifier(itemStack);
        return itemStack;
    }

    default public boolean canEnchantInEnchantingTable(ItemStack itemStack) {
        return this.getEnchantability(itemStack) > 0 && !this.hasEnchantments(itemStack);
    }

    default public boolean acceptsEnchantment(ItemStack itemStack, Enchantment enchantment) {
        EnchantmentMapping[] mappings = ItemUpgradeRegistry.instance.getEnchantmentMappings(enchantment);
        if (mappings.length > 0) {
            return Arrays.stream(this.getMajorModules(itemStack)).filter(Objects::nonNull).anyMatch(module -> Arrays.stream(mappings).anyMatch(mapping -> module.acceptsImprovement(mapping.improvement)));
        }
        return false;
    }

    default public int getEnchantability(ItemStack itemStack) {
        return (int)(Arrays.stream(this.getMajorModules(itemStack)).filter(Objects::nonNull).mapToInt(module -> module.getMagicCapacity(itemStack)).filter(capacity -> capacity > 0).average().orElse(0.0) / 6.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public ImmutableList<ModuleModel> getModels(ItemStack itemStack, @Nullable LivingEntity entity) {
        return this.getAllModules(itemStack).stream().sorted(Comparator.comparing(ItemModule::getRenderLayer)).flatMap(itemModule -> Arrays.stream(itemModule.getModels(itemStack))).filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public String getTransformVariant(ItemStack itemStack, @Nullable LivingEntity entity) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public GuiModuleOffsets getMajorGuiOffsets() {
        return defaultMajorOffsets[this.getNumMajorModules()];
    }

    @OnlyIn(value=Dist.CLIENT)
    default public GuiModuleOffsets getMinorGuiOffsets() {
        return defaultMinorOffsets[this.getNumMinorModules()];
    }
}

