/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.stats.getter;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.util.CastOptional;

public class TooltipGetterBlockingDuration
implements ITooltipGetter {
    private IStatGetter durationGetter;
    private IStatGetter cooldownGetter;

    public TooltipGetterBlockingDuration(IStatGetter durationGetter, IStatGetter cooldownGetter) {
        this.durationGetter = durationGetter;
        this.cooldownGetter = cooldownGetter;
    }

    @Override
    public String getTooltipBase(PlayerEntity player, ItemStack itemStack) {
        double cooldownMultiplier = this.cooldownGetter.getValue(player, itemStack);
        if (cooldownMultiplier > 0.0) {
            if (cooldownMultiplier != 1.0) {
                double baseCooldown = CastOptional.cast(itemStack.func_77973_b(), ItemModularHandheld.class).map(item -> item.getCooldownBase(itemStack)).orElse(1.0);
                return I18n.func_135052_a((String)"tetra.stats.blocking_duration_cooldown.tooltip", (Object[])new Object[]{String.format("%.1f", this.durationGetter.getValue(player, itemStack)), String.format("%.2f", cooldownMultiplier), String.format("%.1f", cooldownMultiplier * baseCooldown)});
            }
            return I18n.func_135052_a((String)"tetra.stats.blocking_duration.tooltip", (Object[])new Object[]{String.format("%.1f", this.durationGetter.getValue(player, itemStack))});
        }
        return I18n.func_135052_a((String)"tetra.stats.blocking.tooltip", (Object[])new Object[0]);
    }

    @Override
    public boolean hasExtendedTooltip(PlayerEntity player, ItemStack itemStack) {
        return true;
    }

    @Override
    public String getTooltipExtension(PlayerEntity player, ItemStack itemStack) {
        return I18n.func_135052_a((String)"tetra.stats.blocking.tooltip_extended", (Object[])new Object[0]);
    }
}

