/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.stats.bar;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;

public class GuiStatIndicator
extends GuiTexture {
    protected String label;
    protected IStatGetter statGetter;
    protected ITooltipGetter tooltipGetter;

    public GuiStatIndicator(int x, int y, String label, int textureIndex, IStatGetter statGetter, ITooltipGetter tooltipGetter) {
        super(x, y, 7, 7, textureIndex * 7, 144, GuiTextures.workbench);
        this.label = I18n.func_135052_a((String)label, (Object[])new Object[0]);
        this.statGetter = statGetter;
        this.tooltipGetter = tooltipGetter;
    }

    public boolean update(PlayerEntity player, ItemStack currentStack, ItemStack previewStack, String slot, String improvement) {
        double diffValue;
        double value;
        if (!previewStack.func_190926_b()) {
            value = this.statGetter.getValue(player, currentStack);
            diffValue = this.statGetter.getValue(player, previewStack);
        } else {
            value = this.statGetter.getValue(player, currentStack);
            if (slot != null) {
                diffValue = value;
                value = improvement != null ? (value -= this.statGetter.getValue(player, currentStack, slot, improvement)) : (value -= this.statGetter.getValue(player, currentStack, slot));
            } else {
                diffValue = value;
            }
        }
        if (value > 0.0 || diffValue > 0.0) {
            this.setColor(this.getDiffColor(value, diffValue));
            return true;
        }
        return false;
    }

    public boolean isActive(PlayerEntity player, ItemStack itemStack) {
        return this.statGetter.getValue(player, itemStack) > 0.0;
    }

    protected int getDiffColor(double value, double diffValue) {
        if (diffValue > 0.0 && value <= 0.0) {
            return 0x55FF55;
        }
        if (diffValue <= 0.0 && value > 0.0) {
            return 0xFF5555;
        }
        if (diffValue == value) {
            return 0xFFFFFF;
        }
        return 0xAAAAFF;
    }

    public String getLabel() {
        return this.label;
    }

    public String getTooltipBase(PlayerEntity player, ItemStack itemStack) {
        return this.tooltipGetter.getTooltipBase(player, itemStack);
    }

    public boolean hasExtendedTooltip(PlayerEntity player, ItemStack itemStack) {
        return this.tooltipGetter.hasExtendedTooltip(player, itemStack);
    }

    public String getTooltipExtension(PlayerEntity player, ItemStack itemStack) {
        return this.tooltipGetter.getTooltipExtension(player, itemStack);
    }
}

