/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.stats.bar;

import com.mojang.blaze3d.matrix.MatrixStack;
import se.mickelus.mgui.gui.GuiAlignment;
import se.mickelus.tetra.gui.stats.bar.GuiBar;

public class GuiBarSegmented
extends GuiBar {
    private int maxSegments;
    private int segmentCount;
    private int diffCount;
    private int segmentLength;

    public GuiBarSegmented(int x, int y, int barLength, double min, double max) {
        super(x, y, barLength, min, max);
        this.maxSegments = (int)(max - min);
    }

    public GuiBarSegmented(int x, int y, int barLength, double min, double max, boolean invertedDiff) {
        super(x, y, barLength + 1, min, max, invertedDiff);
        this.maxSegments = (int)(max - min);
    }

    @Override
    protected void calculateBarLengths() {
        double minValue = Math.min(this.value, this.diffValue);
        this.segmentCount = (int)Math.round(minValue - this.min);
        this.diffCount = (int)Math.ceil(Math.abs(this.value - this.diffValue));
        this.segmentLength = this.width / this.maxSegments;
        this.diffColor = this.invertedDiff ^ this.value < this.diffValue ? -2007629995 : -1996532395;
    }

    @Override
    public void draw(MatrixStack matrixStack, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        if (this.alignment == GuiAlignment.right) {
            int i;
            for (i = 0; i < this.segmentCount; ++i) {
                this.drawSegmentReverse(matrixStack, refX, refY, i, -1, opacity);
            }
            for (i = this.segmentCount; i < this.segmentCount + this.diffCount; ++i) {
                this.drawSegmentReverse(matrixStack, refX, refY, i, this.diffColor, 1.0f);
            }
            for (i = this.segmentCount + this.diffCount; i < this.maxSegments; ++i) {
                this.drawSegmentReverse(matrixStack, refX, refY, i, 0xFFFFFF, 0.14f * opacity);
            }
        } else {
            int i;
            for (i = 0; i < this.segmentCount; ++i) {
                this.drawSegment(matrixStack, refX, refY, i, -1, opacity);
            }
            for (i = this.segmentCount; i < this.segmentCount + this.diffCount; ++i) {
                this.drawSegment(matrixStack, refX, refY, i, this.diffColor, 1.0f);
            }
            for (i = this.segmentCount + this.diffCount; i < this.maxSegments; ++i) {
                this.drawSegment(matrixStack, refX, refY, i, 0xFFFFFF, 0.14f * opacity);
            }
        }
    }

    private void drawSegment(MatrixStack matrixStack, int refX, int refY, int index, int color, float opacity) {
        GuiBarSegmented.drawRect((MatrixStack)matrixStack, (int)(refX + this.x + index * this.segmentLength), (int)(refY + this.y + 6), (int)(refX + this.x + (index + 1) * this.segmentLength - 1), (int)(refY + this.y + 6 + this.height), (int)color, (float)opacity);
    }

    private void drawSegmentReverse(MatrixStack matrixStack, int refX, int refY, int index, int color, float opacity) {
        this.drawSegment(matrixStack, refX + this.width, refY, -index - 1, color, opacity);
    }
}

