/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import se.mickelus.tetra.effect.AbilityUseResult;
import se.mickelus.tetra.effect.ChargedAbilityEffect;
import se.mickelus.tetra.effect.ComboPoints;
import se.mickelus.tetra.effect.EchoHelper;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.potion.ExhaustedPotionEffect;
import se.mickelus.tetra.effect.potion.SmallAbsorbPotionEffect;
import se.mickelus.tetra.effect.potion.SmallHealthPotionEffect;
import se.mickelus.tetra.effect.potion.SmallStrengthPotionEffect;
import se.mickelus.tetra.effect.potion.SteeledPotionEffect;
import se.mickelus.tetra.effect.potion.StunPotionEffect;
import se.mickelus.tetra.effect.potion.UnwaveringPotionEffect;
import se.mickelus.tetra.effect.revenge.RevengeTracker;
import se.mickelus.tetra.items.modular.ItemModularHandheld;

public class ReapEffect
extends ChargedAbilityEffect {
    public static final ReapEffect instance = new ReapEffect();

    ReapEffect() {
        super(20, 0.7f, 40, 8.0, ItemEffect.reap, ChargedAbilityEffect.TargetRequirement.none, UseAction.SPEAR, "raised");
    }

    @Override
    public void perform(PlayerEntity attacker, Hand hand, ItemModularHandheld item, ItemStack itemStack, @Nullable LivingEntity target, @Nullable BlockPos targetPos, @Nullable Vector3d hitVec, int chargedTicks) {
        if (!attacker.field_70170_p.field_72995_K) {
            int overchargeBonus = this.canOvercharge(item, itemStack) ? this.getOverchargeBonus(item, itemStack, chargedTicks) : 0;
            double momentumEfficiency = item.getEffectEfficiency(itemStack, ItemEffect.abilityMomentum);
            int revengeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge);
            int overextendLevel = item.getEffectLevel(itemStack, ItemEffect.abilityOverextend);
            boolean overextend = overextendLevel > 0 && !attacker.func_71024_bL().func_75121_c();
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)attacker;
            int cooldown = this.getCooldown(item, itemStack);
            double damageMultiplier = (double)EffectHelper.getEffectLevel(itemStack, ItemEffect.reap) / 100.0;
            double range = EffectHelper.getEffectEfficiency(itemStack, ItemEffect.reap);
            if (overchargeBonus > 0) {
                damageMultiplier += (double)(overchargeBonus * item.getEffectLevel(itemStack, ItemEffect.abilityOvercharge)) / 100.0;
                range += (double)overchargeBonus * 0.5;
            }
            int comboLevel = item.getEffectLevel(itemStack, ItemEffect.abilityCombo);
            int comboPoints = ComboPoints.get((Entity)attacker);
            if (comboLevel > 0) {
                damageMultiplier += (double)(comboLevel * comboPoints) / 100.0;
            }
            AtomicInteger kills = new AtomicInteger();
            AtomicInteger revengeKills = new AtomicInteger();
            AtomicInteger hits = new AtomicInteger();
            Vector3d targetVec = target != null ? hitVec : Vector3d.func_189986_a((float)attacker.field_70125_A, (float)attacker.field_70177_z).func_72432_b().func_186678_a(range).func_178787_e(attacker.func_174824_e(0.0f));
            AxisAlignedBB aoe = new AxisAlignedBB(targetVec, targetVec).func_72314_b(range, 1.0, range);
            this.hitEntities(serverPlayer, item, itemStack, aoe, damageMultiplier, revengeLevel, overextend, overextendLevel, momentumEfficiency, kills, revengeKills, hits);
            this.applyBuff(attacker, kills.get(), hits.get(), hand, item, itemStack, chargedTicks, comboPoints, revengeKills.get());
            attacker.field_70170_p.func_184148_a(null, attacker.func_226277_ct_(), attacker.func_226278_cu_(), attacker.func_226281_cx_(), SoundEvents.field_187730_dW, attacker.func_184176_by(), 1.0f, 1.0f);
            item.tickProgression((LivingEntity)attacker, itemStack, 1 + kills.get());
            attacker.func_184810_cG();
            attacker.func_71020_j(overextendLevel > 0 ? 6.0f : 1.0f);
            double exhilarationEfficiency = item.getEffectEfficiency(itemStack, ItemEffect.abilityExhilaration);
            if (exhilarationEfficiency > 0.0 && kills.get() > 0) {
                cooldown = (int)((double)cooldown * (1.0 - exhilarationEfficiency / 100.0));
            }
            attacker.func_184811_cZ().func_185145_a((Item)item, cooldown);
            int echoLevel = item.getEffectLevel(itemStack, ItemEffect.abilityEcho);
            if (echoLevel > 0) {
                this.echoReap(serverPlayer, hand, item, itemStack, chargedTicks, aoe, damageMultiplier, revengeLevel, overextend, overextendLevel, momentumEfficiency, comboPoints);
            }
        }
        attacker.func_226292_a_(hand, false);
        if (ComboPoints.canSpend(item, itemStack)) {
            ComboPoints.reset((Entity)attacker);
        }
        item.applyDamage(2, itemStack, (LivingEntity)attacker);
    }

    private void hitEntities(ServerPlayerEntity player, ItemModularHandheld item, ItemStack itemStack, AxisAlignedBB aoe, double damageMultiplier, int revengeLevel, boolean overextend, int overextendLevel, double momentumEfficiency, AtomicInteger kills, AtomicInteger revengeKills, AtomicInteger hits) {
        LinkedList momentumTargets = new LinkedList();
        player.field_70170_p.func_217357_a(LivingEntity.class, aoe).stream().filter(entity -> entity != player).filter(entity -> !player.func_184191_r((Entity)entity)).forEach(entity -> {
            AbilityUseResult result;
            boolean canRevenge;
            double individualDamageMultiplier = damageMultiplier;
            boolean bl = canRevenge = revengeLevel > 0 && RevengeTracker.canRevenge((Entity)player, (Entity)entity);
            if (canRevenge) {
                individualDamageMultiplier += (double)revengeLevel / 100.0;
            }
            if (overextend && entity.func_110143_aJ() / entity.func_110138_aP() >= (float)overextendLevel / 100.0f) {
                individualDamageMultiplier *= 2.0;
            }
            if ((result = item.hitEntity(itemStack, (PlayerEntity)player, (LivingEntity)entity, individualDamageMultiplier, 0.5f, 0.2f)) != AbilityUseResult.fail) {
                if (!entity.func_70089_S()) {
                    kills.incrementAndGet();
                    if (canRevenge) {
                        revengeKills.incrementAndGet();
                        RevengeTracker.removeEnemySynced(player, (Entity)entity);
                    }
                } else if (momentumEfficiency > 0.0) {
                    momentumTargets.add(entity);
                }
                hits.incrementAndGet();
            }
            if (result == AbilityUseResult.crit) {
                player.func_130014_f_().func_184133_a((PlayerEntity)player, entity.func_233580_cy_(), SoundEvents.field_187718_dS, SoundCategory.PLAYERS, 1.0f, 1.3f);
            }
        });
        if (momentumEfficiency > 0.0 && kills.get() > 0) {
            int stunDuration = (int)(momentumEfficiency * (double)kills.get() * 20.0);
            momentumTargets.forEach(entity -> entity.func_195064_c(new EffectInstance((Effect)StunPotionEffect.instance, stunDuration, 0, false, false)));
        }
    }

    private void applyBuff(PlayerEntity attacker, int kills, int hits, Hand hand, ItemModularHandheld item, ItemStack itemStack, int chargedTicks, int comboPoints, int revengeKills) {
        int overextendLevel;
        int defensiveLevel = item.getEffectLevel(itemStack, ItemEffect.abilityDefensive);
        if (defensiveLevel > 0) {
            int duration;
            if (hand == Hand.OFF_HAND) {
                if (hits > 0) {
                    duration = defensiveLevel * (1 + kills * 2);
                    attacker.func_195064_c(new EffectInstance((Effect)SteeledPotionEffect.instance, duration, hits - 1, false, true));
                }
            } else if (kills > 0) {
                duration = (int)(item.getEffectEfficiency(itemStack, ItemEffect.abilityDefensive) * 20.0);
                attacker.func_195064_c(new EffectInstance(Effects.field_76424_c, duration, kills - 1, false, true));
            }
        }
        if (kills > 0) {
            int echoLevel;
            int amp;
            int exhilarationLevel;
            double duration;
            double comboEfficiency;
            int momentumLevel;
            int speedLevel;
            int overchargeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityOvercharge);
            if (overchargeLevel > 0) {
                double duration2 = 600.0;
                attacker.func_195064_c(new EffectInstance((Effect)SmallStrengthPotionEffect.instance, (int)(duration2 *= 1.0 + (double)this.getOverchargeBonus(item, itemStack, chargedTicks) * item.getEffectEfficiency(itemStack, ItemEffect.abilityOvercharge)), kills - 1, false, true));
            }
            if ((speedLevel = item.getEffectLevel(itemStack, ItemEffect.abilitySpeed)) > 0) {
                attacker.func_195064_c(new EffectInstance(Effects.field_76422_e, (int)(item.getEffectEfficiency(itemStack, ItemEffect.abilitySpeed) * 20.0), kills - 1, false, true));
            }
            if ((momentumLevel = item.getEffectLevel(itemStack, ItemEffect.abilityMomentum)) > 0) {
                attacker.func_195064_c(new EffectInstance((Effect)UnwaveringPotionEffect.instance, momentumLevel * kills * 20, 0, false, true));
            }
            if ((comboEfficiency = item.getEffectEfficiency(itemStack, ItemEffect.abilityCombo)) > 0.0) {
                duration = 300.0;
                attacker.func_195064_c(new EffectInstance(Effects.field_76422_e, (int)(duration += comboEfficiency * (double)comboPoints * 20.0), kills - 1, false, true));
            }
            if (revengeKills > 0) {
                duration = 400.0;
                attacker.func_195064_c(new EffectInstance((Effect)SmallStrengthPotionEffect.instance, (int)(duration += item.getEffectEfficiency(itemStack, ItemEffect.abilityRevenge) * (double)revengeKills * 20.0), kills - 1, false, true));
            }
            if ((exhilarationLevel = item.getEffectLevel(itemStack, ItemEffect.abilityExhilaration)) > 0) {
                int currentAmplifier = Optional.ofNullable(attacker.func_70660_b((Effect)SmallAbsorbPotionEffect.instance)).map(EffectInstance::func_76458_c).orElse(-1);
                amp = Math.max(currentAmplifier, kills - 1);
                attacker.func_195064_c(new EffectInstance((Effect)SmallAbsorbPotionEffect.instance, 600, amp, false, true));
            }
            if ((echoLevel = item.getEffectLevel(itemStack, ItemEffect.abilityEcho)) > 0) {
                amp = Optional.ofNullable(attacker.func_70660_b((Effect)SmallStrengthPotionEffect.instance)).map(EffectInstance::func_76458_c).orElse(-1);
                amp = Math.min(echoLevel, amp + kills);
                attacker.func_195064_c(new EffectInstance((Effect)SmallStrengthPotionEffect.instance, 600, amp, false, true));
            }
        }
        if ((overextendLevel = item.getEffectLevel(itemStack, ItemEffect.abilityOverextend)) > 0) {
            if (kills > 0) {
                attacker.func_195064_c(new EffectInstance((Effect)SmallHealthPotionEffect.instance, 900, kills - 1, false, true));
            } else if (!attacker.func_71024_bL().func_75121_c()) {
                attacker.func_195064_c(new EffectInstance((Effect)ExhaustedPotionEffect.instance, 400, 4, false, true));
                attacker.func_71020_j(12.0f);
            }
        }
    }

    private void echoReap(ServerPlayerEntity player, Hand hand, ItemModularHandheld item, ItemStack itemStack, int chargedTicks, AxisAlignedBB aoe, double damageMultiplier, int revengeLevel, boolean overextend, int overextendLevel, double momentumEfficiency, int comboPoints) {
        EchoHelper.echo((PlayerEntity)player, 60, () -> {
            AtomicInteger kills = new AtomicInteger();
            AtomicInteger revengeKills = new AtomicInteger();
            AtomicInteger hits = new AtomicInteger();
            this.hitEntities(player, item, itemStack, aoe, damageMultiplier, revengeLevel, overextend, overextendLevel, momentumEfficiency, kills, revengeKills, hits);
            this.applyBuff((PlayerEntity)player, kills.get(), hits.get(), hand, item, itemStack, chargedTicks, comboPoints, revengeKills.get());
            player.func_184810_cG();
        });
    }
}

