/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DisplayEffectsScreen;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.IModularItem;

public class EffectHelper {
    private static final Cache<UUID, Float> cooledAttackStrengthCache = CacheBuilder.newBuilder().maximumSize(50L).expireAfterWrite(10L, TimeUnit.SECONDS).build();
    private static final Cache<UUID, Boolean> sprintingCache = CacheBuilder.newBuilder().maximumSize(50L).expireAfterWrite(1L, TimeUnit.SECONDS).build();

    public static void setCooledAttackStrength(PlayerEntity player, float strength) {
        cooledAttackStrengthCache.put((Object)player.func_110124_au(), (Object)Float.valueOf(strength));
    }

    public static float getCooledAttackStrength(PlayerEntity player) {
        try {
            return ((Float)cooledAttackStrengthCache.get((Object)player.func_110124_au(), () -> Float.valueOf(0.0f))).floatValue();
        }
        catch (ExecutionException e) {
            return 0.0f;
        }
    }

    public static void setSprinting(LivingEntity player, boolean isSprinting) {
        sprintingCache.put((Object)player.func_110124_au(), (Object)isSprinting);
    }

    public static boolean getSprinting(LivingEntity player) {
        try {
            return (Boolean)sprintingCache.get((Object)player.func_110124_au(), () -> false);
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    public static int getEffectLevel(ItemStack itemStack, ItemEffect effect) {
        IModularItem item = (IModularItem)itemStack.func_77973_b();
        return item.getEffectLevel(itemStack, effect);
    }

    public static double getEffectEfficiency(ItemStack itemStack, ItemEffect effect) {
        IModularItem item = (IModularItem)itemStack.func_77973_b();
        return item.getEffectEfficiency(itemStack, effect);
    }

    public static boolean breakBlock(World world, PlayerEntity breakingPlayer, ItemStack toolStack, BlockPos pos, BlockState blockState, boolean harvest) {
        if (!world.field_72995_K) {
            ServerWorld serverWorld = (ServerWorld)world;
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)breakingPlayer;
            GameType gameType = serverPlayer.field_71134_c.func_73081_b();
            int exp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)gameType, (ServerPlayerEntity)serverPlayer, (BlockPos)pos);
            TileEntity tileEntity = world.func_175625_s(pos);
            if (exp != -1) {
                boolean canRemove;
                boolean bl = canRemove = !toolStack.onBlockStartBreak(pos, breakingPlayer) && !breakingPlayer.func_223729_a(world, pos, gameType) && (!harvest || blockState.canHarvestBlock((IBlockReader)world, pos, breakingPlayer)) && blockState.func_177230_c().removedByPlayer(blockState, world, pos, breakingPlayer, harvest, world.func_204610_c(pos));
                if (canRemove) {
                    blockState.func_177230_c().func_176206_d((IWorld)world, pos, blockState);
                    if (harvest) {
                        blockState.func_177230_c().func_180657_a(world, breakingPlayer, pos, blockState, tileEntity, toolStack);
                        if (exp > 0) {
                            blockState.func_177230_c().func_180637_b(serverWorld, pos, exp);
                        }
                    }
                }
                return canRemove;
            }
            return false;
        }
        return blockState.func_177230_c().removedByPlayer(blockState, world, pos, breakingPlayer, harvest, world.func_204610_c(pos));
    }

    public static void sendEventToPlayer(ServerPlayerEntity player, int type, BlockPos pos, int data) {
        player.field_71135_a.func_147359_a((IPacket)new SPlaySoundEventPacket(type, pos, data, false));
    }

    public static void applyEnchantmentHitEffects(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        int fireAspectLevel;
        EnchantmentHelper.func_82781_a((ItemStack)itemStack).forEach((enchantment, level) -> enchantment.func_151368_a(attacker, (Entity)target, level.intValue()));
        if (attacker != null) {
            for (ItemStack equipment : attacker.func_184209_aF()) {
                EnchantmentHelper.func_82781_a((ItemStack)equipment).forEach((enchantment, level) -> enchantment.func_151368_a(attacker, (Entity)target, level.intValue()));
            }
        }
        if ((fireAspectLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)itemStack)) > 0) {
            target.func_70015_d(fireAspectLevel * 4);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderInventoryEffectTooltip(DisplayEffectsScreen<?> gui, MatrixStack mStack, int x, int y, Supplier<ITextComponent> tooltip) {
        Minecraft mc = Minecraft.func_71410_x();
        MainWindow window = mc.func_228018_at_();
        int width = window.func_198107_o();
        int height = window.func_198087_p();
        int mouseX = (int)(mc.field_71417_B.func_198024_e() * (double)width / (double)window.func_198105_m());
        int mouseY = (int)(mc.field_71417_B.func_198026_f() * (double)height / (double)window.func_198083_n());
        if (x < mouseX && mouseX < x + 120 && y < mouseY && mouseY < y + 32) {
            gui.func_238652_a_(mStack, tooltip.get(), mouseX, mouseY);
        }
    }
}

