/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.data;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.network.AbstractPacket;

public class UpdateDataPacket
extends AbstractPacket {
    private String directory;
    private Map<ResourceLocation, String> data;

    public UpdateDataPacket() {
    }

    public UpdateDataPacket(String directory, Map<ResourceLocation, JsonElement> data) {
        this.directory = directory;
        this.data = data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((JsonElement)entry.getValue()).toString()));
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.func_180714_a(this.directory);
        buffer.writeInt(this.data.size());
        this.data.forEach((resourceLocation, data) -> {
            buffer.func_192572_a(resourceLocation);
            buffer.func_180714_a(data);
        });
    }

    @Override
    public void fromBytes(PacketBuffer buffer) {
        this.directory = buffer.func_218666_n();
        int count = buffer.readInt();
        this.data = new HashMap<ResourceLocation, String>();
        for (int i = 0; i < count; ++i) {
            this.data.put(buffer.func_192575_l(), buffer.func_218666_n());
        }
    }

    @Override
    public void handle(PlayerEntity player) {
        DataManager.instance.onDataRecieved(this.directory, this.data);
    }
}

