/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.blocks.PropertyMatcher;
import se.mickelus.tetra.blocks.workbench.action.ConfigActionImpl;
import se.mickelus.tetra.craftingeffect.CraftingEffect;
import se.mickelus.tetra.craftingeffect.condition.CraftingEffectCondition;
import se.mickelus.tetra.craftingeffect.outcome.CraftingEffectOutcome;
import se.mickelus.tetra.data.CraftingEffectStore;
import se.mickelus.tetra.data.DataStore;
import se.mickelus.tetra.data.FeatureStore;
import se.mickelus.tetra.data.ImprovementStore;
import se.mickelus.tetra.data.MaterialStore;
import se.mickelus.tetra.data.ModuleStore;
import se.mickelus.tetra.data.SchematicStore;
import se.mickelus.tetra.data.deserializer.AttributesDeserializer;
import se.mickelus.tetra.data.deserializer.BlockDeserializer;
import se.mickelus.tetra.data.deserializer.BlockPosDeserializer;
import se.mickelus.tetra.data.deserializer.EnchantmentDeserializer;
import se.mickelus.tetra.data.deserializer.GlyphDeserializer;
import se.mickelus.tetra.data.deserializer.ItemDeserializer;
import se.mickelus.tetra.data.deserializer.ItemPredicateDeserializer;
import se.mickelus.tetra.data.deserializer.ModuleModelDeserializer;
import se.mickelus.tetra.data.deserializer.PropertyMatcherDeserializer;
import se.mickelus.tetra.data.deserializer.ReplacementDeserializer;
import se.mickelus.tetra.data.deserializer.ResourceLocationDeserializer;
import se.mickelus.tetra.generation.FeatureParameters;
import se.mickelus.tetra.module.Priority;
import se.mickelus.tetra.module.ReplacementDefinition;
import se.mickelus.tetra.module.data.EffectData;
import se.mickelus.tetra.module.data.EnchantmentMapping;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.data.ImprovementData;
import se.mickelus.tetra.module.data.MaterialColors;
import se.mickelus.tetra.module.data.MaterialData;
import se.mickelus.tetra.module.data.ModuleData;
import se.mickelus.tetra.module.data.ModuleModel;
import se.mickelus.tetra.module.data.SynergyData;
import se.mickelus.tetra.module.data.ToolData;
import se.mickelus.tetra.module.data.TweakData;
import se.mickelus.tetra.module.data.VariantData;
import se.mickelus.tetra.module.improvement.DestabilizationEffect;
import se.mickelus.tetra.module.schematic.OutcomeDefinition;
import se.mickelus.tetra.module.schematic.OutcomeMaterial;
import se.mickelus.tetra.module.schematic.RepairDefinition;

public class DataManager {
    private final Logger logger = LogManager.getLogger();
    public static final Gson gson = new GsonBuilder().registerTypeAdapter(ToolData.class, (Object)new ToolData.Deserializer()).registerTypeAdapter(EffectData.class, (Object)new EffectData.Deserializer()).registerTypeAdapter(GlyphData.class, (Object)new GlyphDeserializer()).registerTypeAdapter(ModuleModel.class, (Object)new ModuleModelDeserializer()).registerTypeAdapter(Priority.class, (Object)new Priority.Deserializer()).registerTypeAdapter(ItemPredicate.class, (Object)new ItemPredicateDeserializer()).registerTypeAdapter(PropertyMatcher.class, (Object)new PropertyMatcherDeserializer()).registerTypeAdapter(OutcomeMaterial.class, (Object)new OutcomeMaterial.Deserializer()).registerTypeAdapter(ReplacementDefinition.class, (Object)new ReplacementDeserializer()).registerTypeAdapter(BlockPos.class, (Object)new BlockPosDeserializer()).registerTypeAdapter(Block.class, (Object)new BlockDeserializer()).registerTypeAdapter((Type)AttributesDeserializer.typeToken.getRawType(), (Object)new AttributesDeserializer()).registerTypeAdapter(VariantData.class, (Object)new VariantData.Deserializer()).registerTypeAdapter(ImprovementData.class, (Object)new ImprovementData.Deserializer()).registerTypeAdapter(OutcomeDefinition.class, (Object)new OutcomeDefinition.Deserializer()).registerTypeAdapter(MaterialColors.class, (Object)new MaterialColors.Deserializer()).registerTypeAdapter(CraftingEffectCondition.class, (Object)new CraftingEffectCondition.Deserializer()).registerTypeAdapter(CraftingEffectOutcome.class, (Object)new CraftingEffectOutcome.Deserializer()).registerTypeAdapter(Item.class, (Object)new ItemDeserializer()).registerTypeAdapter(Enchantment.class, (Object)new EnchantmentDeserializer()).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocationDeserializer()).create();
    public static DataStore<TweakData[]> tweakData = new DataStore<TweakData[]>(gson, "tweaks", TweakData[].class);
    public static DataStore<MaterialData> materialData = new MaterialStore(gson, "materials");
    public static DataStore<ImprovementData[]> improvementData = new ImprovementStore(gson, "improvements");
    public static DataStore<ModuleData> moduleData = new ModuleStore(gson, "modules");
    public static DataStore<RepairDefinition> repairData = new DataStore<RepairDefinition>(gson, "repairs", RepairDefinition.class);
    public static DataStore<EnchantmentMapping[]> enchantmentData = new DataStore<EnchantmentMapping[]>(gson, "enchantments", EnchantmentMapping[].class);
    public static DataStore<SynergyData[]> synergyData = new DataStore<SynergyData[]>(gson, "synergies", SynergyData[].class);
    public static DataStore<ReplacementDefinition[]> replacementData = new DataStore<ReplacementDefinition[]>(gson, "replacements", ReplacementDefinition[].class);
    public static SchematicStore schematicData = new SchematicStore(gson, "schematics");
    public static DataStore<CraftingEffect> craftingEffectData = new CraftingEffectStore(gson, "crafting_effects");
    public static DataStore<ItemPredicate[]> predicateData = new DataStore<ItemPredicate[]>(gson, "predicatus", ItemPredicate[].class);
    public static DataStore<ConfigActionImpl[]> actionData = new DataStore<ConfigActionImpl[]>(gson, "actions", ConfigActionImpl[].class);
    public static DataStore<DestabilizationEffect[]> destabilizationData = new DataStore<DestabilizationEffect[]>(gson, "destabilization", DestabilizationEffect[].class);
    public static DataStore<FeatureParameters> featureData = new FeatureStore(gson, "structures");
    private final DataStore[] dataStores = new DataStore[]{tweakData, materialData, improvementData, moduleData, enchantmentData, synergyData, replacementData, schematicData, craftingEffectData, repairData, predicateData, actionData, destabilizationData, featureData};
    public static DataManager instance;

    public DataManager() {
        instance = this;
    }

    @SubscribeEvent
    public void addReloadListener(AddReloadListenerEvent event) {
        this.logger.debug("Setting up datastore reload listeners");
        Arrays.stream(this.dataStores).forEach(arg_0 -> ((AddReloadListenerEvent)event).addListener(arg_0));
    }

    @SubscribeEvent
    public void tagsUpdated(TagsUpdatedEvent event) {
        this.logger.debug("Reloaded tags");
    }

    @SubscribeEvent
    public void playerConnected(PlayerEvent.PlayerLoggedInEvent event) {
        this.logger.info("Sending data to client: {}", (Object)event.getPlayer().func_200200_C_().func_150261_e());
        for (DataStore dataStore : this.dataStores) {
            dataStore.sendToPlayer((ServerPlayerEntity)event.getPlayer());
        }
    }

    public void onDataRecieved(String directory, Map<ResourceLocation, String> data) {
        Arrays.stream(this.dataStores).filter(dataStore -> dataStore.getDirectory().equals(directory)).forEach(dataStore -> dataStore.loadFromPacket(data));
    }

    public SynergyData[] getSynergyData(String path) {
        SynergyData[] data;
        for (SynergyData entry : data = (SynergyData[])synergyData.getDataIn(new ResourceLocation("tetra", path)).stream().flatMap(Arrays::stream).toArray(SynergyData[]::new)) {
            Arrays.sort(entry.moduleVariants);
            Arrays.sort(entry.modules);
        }
        return data;
    }
}

