/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.client.gui.GuiUtils;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.mgui.gui.GuiTextureOffset;
import se.mickelus.tetra.blocks.salvage.InteractiveBlockOverlay;
import se.mickelus.tetra.blocks.workbench.WorkbenchContainer;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;
import se.mickelus.tetra.blocks.workbench.gui.GuiActionList;
import se.mickelus.tetra.blocks.workbench.gui.GuiIntegrityBar;
import se.mickelus.tetra.blocks.workbench.gui.GuiInventoryInfo;
import se.mickelus.tetra.blocks.workbench.gui.GuiModuleList;
import se.mickelus.tetra.blocks.workbench.gui.GuiSlotDetail;
import se.mickelus.tetra.blocks.workbench.gui.WorkbenchStatsGui;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.gui.HoneProgressGui;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;
import se.mickelus.tetra.properties.PropertyHelper;
import se.mickelus.tetra.util.CastOptional;

@OnlyIn(value=Dist.CLIENT)
public class WorkbenchScreen
extends ContainerScreen<WorkbenchContainer> {
    private PlayerEntity viewingPlayer;
    private final WorkbenchTile tileEntity;
    private final WorkbenchContainer container;
    private GuiElement defaultGui;
    private GuiModuleList moduleList;
    private WorkbenchStatsGui statGroup;
    private GuiIntegrityBar integrityBar;
    private HoneProgressGui honeBar;
    private GuiActionList actionList;
    private final GuiInventoryInfo inventoryInfo;
    private String selectedSlot;
    private int previewMaterialSlot = -1;
    private GuiSlotDetail slotDetail;
    private ItemStack currentTarget = ItemStack.field_190927_a;
    private ItemStack currentPreview = ItemStack.field_190927_a;
    private UpgradeSchematic currentSchematic = null;
    private ItemStack[] currentMaterials;
    private boolean hadItem = false;
    private boolean isDirty = false;

    public WorkbenchScreen(WorkbenchContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_146999_f = 320;
        this.field_147000_g = 240;
        this.tileEntity = container.getTileEntity();
        this.container = container;
        this.defaultGui = new GuiElement(0, 0, this.field_146999_f, this.field_147000_g);
        this.defaultGui.addChild((GuiElement)new GuiTextureOffset(134, 40, 51, 51, GuiTextures.workbench));
        this.defaultGui.addChild((GuiElement)new GuiTexture(72, 153, 179, 106, GuiTextures.playerInventory));
        this.moduleList = new GuiModuleList(164, 49, this::selectSlot, this::updateSlotHoverPreview);
        this.defaultGui.addChild((GuiElement)this.moduleList);
        this.statGroup = new WorkbenchStatsGui(60, 0);
        this.defaultGui.addChild((GuiElement)this.statGroup);
        this.integrityBar = new GuiIntegrityBar(0, 90);
        this.integrityBar.setAttachmentAnchor(GuiAttachment.topCenter);
        this.defaultGui.addChild((GuiElement)this.integrityBar);
        this.honeBar = new HoneProgressGui(0, 90);
        this.honeBar.setAttachmentAnchor(GuiAttachment.topCenter);
        this.honeBar.setVisible(false);
        this.defaultGui.addChild((GuiElement)this.honeBar);
        this.inventoryInfo = new GuiInventoryInfo(84, 164, (PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        this.defaultGui.addChild((GuiElement)this.inventoryInfo);
        this.actionList = new GuiActionList(0, 120);
        this.actionList.setAttachmentAnchor(GuiAttachment.topCenter);
        this.actionList.setAttachmentPoint(GuiAttachment.middleCenter);
        this.defaultGui.addChild((GuiElement)this.actionList);
        this.slotDetail = new GuiSlotDetail(46, 102, schematic -> this.tileEntity.setCurrentSchematic((UpgradeSchematic)schematic, this.selectedSlot), () -> this.selectSlot(null), this::craftUpgrade, this::previewTweaks, this::applyTweaks);
        this.defaultGui.addChild((GuiElement)this.slotDetail);
        this.tileEntity.addChangeListener("gui.workbench", () -> {
            this.isDirty = true;
        });
        this.currentMaterials = new ItemStack[4];
        Arrays.fill(this.currentMaterials, ItemStack.field_190927_a);
    }

    public void func_231158_b_(Minecraft minecraft, int width, int height) {
        super.func_231158_b_(minecraft, width, height);
        this.viewingPlayer = minecraft.field_71439_g;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_238651_a_(matrixStack, 0);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        int x = (this.field_230708_k_ - this.field_146999_f) / 2;
        int y = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.defaultGui.draw(new MatrixStack(), x, y, this.field_230708_k_, this.field_230709_l_, mouseX, mouseY, 1.0f);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
    }

    protected void func_230459_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230459_a_(matrixStack, mouseX, mouseY);
        List tooltipLines = this.defaultGui.getTooltipLines();
        if (tooltipLines != null) {
            List textComponents = tooltipLines.stream().map(line -> line.replace("\\n", "\n")).flatMap(line -> Arrays.stream(line.split("\n"))).map(StringTextComponent::new).collect(Collectors.toList());
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, textComponents, (int)mouseX, (int)mouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)280, (FontRenderer)this.field_230712_o_);
        }
        this.updateMaterialHoverPreview();
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        super.func_231044_a_(mouseX, mouseY, button);
        return this.defaultGui.onMouseClick((int)mouseX, (int)mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        super.func_231048_c_(mouseX, mouseY, button);
        this.defaultGui.onMouseRelease((int)mouseX, (int)mouseY, button);
        return true;
    }

    public boolean func_231042_a_(char typecChar, int keyCode) {
        this.slotDetail.keyTyped(typecChar);
        return false;
    }

    private void selectSlot(String slotKey) {
        this.selectedSlot = slotKey;
        this.tileEntity.clearSchematic();
        this.moduleList.setFocus(this.selectedSlot);
        if (this.selectedSlot != null) {
            this.slotDetail.onTileEntityChange(this.viewingPlayer, this.tileEntity, this.tileEntity.getTargetItemStack(), this.selectedSlot, this.tileEntity.getCurrentSchematic());
        }
        this.slotDetail.setVisible(this.selectedSlot != null);
    }

    private void deselectSchematic() {
        this.tileEntity.clearSchematic();
    }

    private void craftUpgrade() {
        this.tileEntity.initiateCrafting(this.viewingPlayer);
    }

    private void previewTweaks(Map<String, Integer> tweakMap) {
        ItemStack previewStack = this.currentTarget.func_77946_l();
        CastOptional.cast(previewStack.func_77973_b(), IModularItem.class).map(item -> item.getModuleFromSlot(previewStack, this.selectedSlot)).ifPresent(module -> tweakMap.forEach((tweakKey, step) -> {
            if (module.hasTweak(previewStack, (String)tweakKey)) {
                module.setTweakStep(previewStack, (String)tweakKey, (int)step);
            }
            IModularItem.updateIdentifier(previewStack);
        }));
        this.statGroup.update(this.currentTarget, previewStack, null, null, this.viewingPlayer);
    }

    private void applyTweaks(Map<String, Integer> tweakMap) {
        this.tileEntity.applyTweaks(this.viewingPlayer, this.selectedSlot, tweakMap);
    }

    private void onTileEntityChange() {
        boolean slotChanged;
        ItemStack newTarget = this.tileEntity.getTargetItemStack();
        ItemStack newPreview = ItemStack.field_190927_a;
        UpgradeSchematic newSchematic = this.tileEntity.getCurrentSchematic();
        String currentSlot = this.tileEntity.getCurrentSlot();
        if (newTarget.func_77973_b() instanceof IModularItem && newSchematic != null) {
            newPreview = this.buildPreviewStack(newSchematic, newTarget, currentSlot, this.tileEntity.getMaterials());
        }
        boolean targetItemChanged = !ItemStack.func_77989_b((ItemStack)this.currentTarget, (ItemStack)newTarget);
        boolean previewChanged = !ItemStack.func_77989_b((ItemStack)this.currentPreview, (ItemStack)newPreview);
        boolean schematicChanged = !Objects.equals(this.currentSchematic, newSchematic);
        boolean materialsChanged = this.diffMaterials(this.tileEntity.getMaterials());
        this.currentPreview = newPreview;
        this.currentSchematic = newSchematic;
        if (targetItemChanged) {
            ItemStack.func_77989_b((ItemStack)this.currentTarget, (ItemStack)newTarget);
            this.currentTarget = newTarget.func_77946_l();
            this.selectedSlot = null;
        }
        boolean bl = slotChanged = !Objects.equals(this.selectedSlot, currentSlot);
        if (!this.currentTarget.func_190926_b() && currentSlot != null) {
            this.selectedSlot = currentSlot;
        }
        this.container.updateSlots();
        if (slotChanged || targetItemChanged) {
            this.actionList.updateActions(this.currentTarget, this.tileEntity.getAvailableActions(this.viewingPlayer), this.viewingPlayer, action -> this.tileEntity.performAction(this.viewingPlayer, action.getKey()), this.tileEntity);
            InteractiveBlockOverlay.markDirty();
        }
        if (targetItemChanged || previewChanged || schematicChanged || slotChanged || materialsChanged) {
            this.updateItemDisplay(this.currentTarget, this.currentPreview);
            if (this.currentTarget.func_77973_b() instanceof IModularItem) {
                this.slotDetail.onTileEntityChange(this.viewingPlayer, this.tileEntity, this.currentTarget, this.selectedSlot, this.currentSchematic);
            }
        }
        this.inventoryInfo.update(this.currentSchematic, currentSlot, this.currentTarget);
        if (!this.currentTarget.func_190926_b()) {
            if (!this.hadItem) {
                this.hadItem = true;
                if (targetItemChanged && currentSlot == null) {
                    this.itemShowAnimation();
                }
            }
        } else {
            this.hadItem = false;
        }
        if (!this.currentTarget.func_190926_b()) {
            if (this.currentSchematic == null && this.selectedSlot == null) {
                this.actionList.setVisible(true);
                this.slotDetail.setVisible(false);
            } else if (this.currentTarget.func_77973_b() instanceof IModularItem) {
                this.actionList.setVisible(false);
                this.slotDetail.setVisible(this.selectedSlot != null);
            }
        } else {
            this.actionList.setVisible(false);
            this.slotDetail.setVisible(false);
        }
    }

    private boolean diffMaterials(ItemStack[] newMaterials) {
        int i;
        boolean isDiff = false;
        for (i = 0; i < newMaterials.length; ++i) {
            if (ItemStack.func_77989_b((ItemStack)newMaterials[i], (ItemStack)this.currentMaterials[i])) continue;
            isDiff = true;
            break;
        }
        for (i = 0; i < newMaterials.length; ++i) {
            this.currentMaterials[i] = newMaterials[i].func_77946_l();
        }
        return isDiff;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.inventoryInfo.update(this.tileEntity.getCurrentSchematic(), this.tileEntity.getCurrentSlot(), this.currentTarget);
        World world = this.tileEntity.func_145831_w();
        if (this.isDirty) {
            this.onTileEntityChange();
            this.isDirty = false;
        } else if (world != null && world.func_82737_E() % 20L == 0L) {
            BlockPos pos = this.tileEntity.func_174877_v();
            Map<ToolType, Integer> availableTools = PropertyHelper.getCombinedToolLevels(this.viewingPlayer, world, pos, world.func_180495_p(pos));
            if (this.tileEntity.getCurrentSchematic() != null && this.slotDetail.isVisible()) {
                this.slotDetail.update(this.viewingPlayer, this.tileEntity, availableTools);
            }
            if (this.actionList.isVisible()) {
                this.actionList.updateTools(availableTools);
            }
        }
    }

    private void updateItemDisplay(ItemStack itemStack, ItemStack previewStack) {
        this.moduleList.update(itemStack, previewStack, this.selectedSlot);
        this.statGroup.update(itemStack, previewStack, null, null, this.viewingPlayer);
        this.slotDetail.updatePreview(this.currentSchematic, this.selectedSlot, itemStack, previewStack);
        this.integrityBar.setItemStack(itemStack, previewStack);
        this.honeBar.update(itemStack, this.tileEntity.isTargetPlaceholder());
        this.honeBar.setX(Math.max(this.integrityBar.getWidth() / 2 + 8, 35));
    }

    private void itemShowAnimation() {
        this.moduleList.showAnimation();
        this.statGroup.showAnimation();
        this.integrityBar.showAnimation();
        this.honeBar.showAnimation();
        this.actionList.showAnimation();
    }

    private void updateSlotHoverPreview(String slot, String improvement) {
        if (this.tileEntity.getCurrentSlot() == null) {
            ItemStack itemStack = this.tileEntity.getTargetItemStack();
            this.statGroup.update(itemStack, ItemStack.field_190927_a, slot, improvement, this.viewingPlayer);
        }
    }

    private void updateMaterialHoverPreview() {
        int newPreviewMaterialSlot = -1;
        Slot hoveredSlot = this.getSlotUnderMouse();
        UpgradeSchematic currentSchematic = this.tileEntity.getCurrentSchematic();
        ItemStack targetStack = this.tileEntity.getTargetItemStack();
        if (currentSchematic != null && hoveredSlot != null && hoveredSlot.func_75216_d()) {
            newPreviewMaterialSlot = hoveredSlot.getSlotIndex();
        }
        if (newPreviewMaterialSlot != this.previewMaterialSlot && targetStack.func_77973_b() instanceof IModularItem) {
            ItemStack[] materials = this.tileEntity.getMaterials();
            if (newPreviewMaterialSlot != -1 && Arrays.stream(materials).allMatch(ItemStack::func_190926_b)) {
                ItemStack previewStack = this.buildPreviewStack(currentSchematic, targetStack, this.selectedSlot, new ItemStack[]{hoveredSlot.func_75211_c()});
                this.updateItemDisplay(targetStack, previewStack);
            } else {
                ItemStack previewStack = ItemStack.field_190927_a;
                if (currentSchematic != null) {
                    previewStack = this.buildPreviewStack(currentSchematic, targetStack, this.selectedSlot, materials);
                }
                this.updateItemDisplay(targetStack, previewStack);
            }
            this.previewMaterialSlot = newPreviewMaterialSlot;
        }
    }

    private ItemStack buildPreviewStack(UpgradeSchematic schematic, ItemStack targetStack, String slot, ItemStack[] materials) {
        if (schematic.isMaterialsValid(targetStack, slot, materials)) {
            ItemStack result = schematic.applyUpgrade(targetStack, materials, false, slot, null);
            boolean willReplace = schematic.willReplace(targetStack, materials, slot);
            Map<ToolType, Integer> tools = schematic.getRequiredToolLevels(targetStack, materials);
            for (Map.Entry<ToolType, Integer> entry : tools.entrySet()) {
                result = WorkbenchTile.consumeCraftingToolEffects(result, slot, willReplace, entry.getKey(), entry.getValue(), this.viewingPlayer, this.tileEntity.func_145831_w(), this.tileEntity.func_174877_v(), this.tileEntity.func_195044_w(), false);
            }
            result = WorkbenchTile.applyCraftingBonusEffects(result, slot, willReplace, this.viewingPlayer, materials, materials, tools, this.tileEntity.func_145831_w(), this.tileEntity.func_174877_v(), this.tileEntity.func_195044_w(), false);
            IModularItem.updateIdentifier(result);
            return result;
        }
        return ItemStack.field_190927_a;
    }
}

