/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import java.util.Collections;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ToolType;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.tetra.blocks.workbench.gui.ToolRequirementGui;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;

public class ToolRequirementListGui
extends GuiElement {
    private Map<ToolType, Integer> requiredTools = Collections.emptyMap();

    public ToolRequirementListGui(int x, int y) {
        super(x, y, 54, 18);
    }

    public void update(UpgradeSchematic schematic, ItemStack targetStack, String slot, ItemStack[] materials, Map<ToolType, Integer> availableTools) {
        boolean hasValidMaterials = schematic.isMaterialsValid(targetStack, slot, materials);
        this.setVisible(hasValidMaterials);
        if (hasValidMaterials) {
            this.clearChildren();
            this.requiredTools = schematic.getRequiredToolLevels(targetStack, materials);
            this.requiredTools.forEach((tool, level) -> {
                ToolRequirementGui indicator = new ToolRequirementGui(this.getNumChildren() * 16, 0, (ToolType)tool);
                indicator.updateRequirement((int)level, availableTools.getOrDefault(tool, 0));
                indicator.setAttachment(GuiAttachment.topRight);
                this.addChild(indicator);
            });
        }
    }

    public void updateAvailableTools(Map<ToolType, Integer> availableTools) {
        this.getChildren(ToolRequirementGui.class).forEach(indicator -> indicator.updateRequirement(this.requiredTools.getOrDefault(indicator.getToolType(), 0), availableTools.getOrDefault(indicator.getToolType(), 0)));
    }
}

