/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ToolType;
import se.mickelus.mgui.gui.GuiButton;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiItem;
import se.mickelus.mgui.gui.GuiString;
import se.mickelus.mgui.gui.GuiStringSmall;
import se.mickelus.mgui.gui.GuiTextSmall;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.tetra.blocks.workbench.gui.CraftButtonGui;
import se.mickelus.tetra.blocks.workbench.gui.GuiExperience;
import se.mickelus.tetra.blocks.workbench.gui.ToolRequirementListGui;
import se.mickelus.tetra.gui.GuiItemRolling;
import se.mickelus.tetra.gui.GuiMagicUsage;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloMaterialApplicable;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloMaterialTranslation;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.schematic.SchematicType;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;

public class GuiSchematicDetail
extends GuiElement {
    private static final int MAX_NUM_SLOTS = 2;
    private UpgradeSchematic schematic;
    private GuiElement glyph;
    private GuiString title;
    private GuiTextSmall description;
    private List<String> descriptionTooltip;
    private CraftButtonGui craftButton;
    private GuiString[] slotNames;
    private GuiString[] slotQuantities;
    private GuiItemRolling[] slotPlaceholders;
    private GuiTexture[] slotBorders;
    private GuiMagicUsage magicCapacity;
    private ToolRequirementListGui toolRequirementList;
    private GuiExperience experienceIndicator;
    private HoloMaterialTranslation materialTranslation;
    private HoloMaterialApplicable applicableMaterials;

    public GuiSchematicDetail(int x, int y, Runnable backListener, Runnable craftListener) {
        super(x, y, 224, 67);
        this.addChild((GuiElement)new GuiButton(-4, this.height - 2, 40, 8, "< " + I18n.func_135052_a((String)"tetra.workbench.schematic_detail.back", (Object[])new Object[0]), backListener));
        this.glyph = new GuiElement(3, 3, 16, 16);
        this.addChild(this.glyph);
        this.title = new GuiString(19, 6, 100, "");
        this.addChild((GuiElement)this.title);
        this.description = new GuiTextSmall(5, 17, 105, "");
        this.addChild((GuiElement)this.description);
        this.materialTranslation = new HoloMaterialTranslation(110, 4);
        this.addChild(this.materialTranslation);
        this.applicableMaterials = new HoloMaterialApplicable(111, 13);
        this.addChild(this.applicableMaterials);
        this.slotNames = new GuiString[2];
        this.slotQuantities = new GuiString[2];
        this.slotPlaceholders = new GuiItemRolling[2];
        this.slotBorders = new GuiTexture[2];
        for (int i = 0; i < 2; ++i) {
            this.slotNames[i] = new GuiString(140, 9 + i * 17, "");
            this.slotNames[i].setVisible(false);
            this.addChild((GuiElement)this.slotNames[i]);
            this.slotQuantities[i] = new GuiStringSmall(139, 18 + i * 18, "");
            this.slotQuantities[i].setVisible(false);
            this.addChild((GuiElement)this.slotQuantities[i]);
            this.slotPlaceholders[i] = new GuiItemRolling(121, 5 + i * 18);
            this.slotPlaceholders[i].setVisible(false);
            this.slotPlaceholders[i].setCountVisibility(GuiItem.CountMode.never);
            this.addChild(this.slotPlaceholders[i]);
            this.slotBorders[i] = new GuiTexture(121, 5 + i * 18, 16, 16, 52, 16, GuiTextures.workbench);
            this.slotBorders[i].setOpacity(0.8f);
            this.slotBorders[i].setVisible(false);
            this.addChild((GuiElement)this.slotBorders[i]);
        }
        this.magicCapacity = new GuiMagicUsage(121, 28, 80);
        this.addChild(this.magicCapacity);
        this.toolRequirementList = new ToolRequirementListGui(80, 39);
        this.addChild(this.toolRequirementList);
        this.experienceIndicator = new GuiExperience(192, 42, "tetra.workbench.schematic_detail.experience");
        this.addChild(this.experienceIndicator);
        this.craftButton = new CraftButtonGui(140, 40, craftListener);
        this.addChild((GuiElement)this.craftButton);
    }

    public void update(UpgradeSchematic schematic, ItemStack itemStack, String slot, ItemStack[] materials, Map<ToolType, Integer> availableTools, PlayerEntity player) {
        int i;
        GuiTexture glyphTexture;
        this.schematic = schematic;
        this.title.setString(schematic.getName());
        this.title.setColor(schematic.getRarity().tint);
        String descriptionString = schematic.getDescription(itemStack);
        this.description.setString(TextFormatting.GRAY + descriptionString.replace(TextFormatting.RESET.toString(), TextFormatting.RESET.toString() + TextFormatting.GRAY.toString()));
        this.descriptionTooltip = ImmutableList.of((Object)descriptionString);
        this.materialTranslation.setVisible(schematic.getNumMaterialSlots() > 0);
        this.applicableMaterials.setVisible(schematic.getNumMaterialSlots() > 0);
        if (schematic.getNumMaterialSlots() > 0) {
            this.materialTranslation.update(schematic);
            this.applicableMaterials.update(itemStack, slot, schematic, player);
        }
        this.glyph.clearChildren();
        GlyphData glyphData = schematic.getGlyph();
        GuiTexture border = null;
        if (schematic.getType() == SchematicType.major) {
            border = new GuiTexture(0, 2, 16, 9, 52, 3, GuiTextures.workbench);
            glyphTexture = new GuiTexture(-1, -1, 16, 16, glyphData.textureX, glyphData.textureY, glyphData.textureLocation);
        } else if (schematic.getType() == SchematicType.minor) {
            border = new GuiTexture(2, 1, 11, 11, 68, 0, GuiTextures.workbench);
            glyphTexture = new GuiTexture(4, 3, 8, 8, glyphData.textureX, glyphData.textureY, glyphData.textureLocation);
        } else if (schematic.getType() == SchematicType.improvement) {
            border = new GuiTexture(0, 2, 16, 9, 52, 3, GuiTextures.workbench);
            glyphTexture = new GuiTexture(-1, -1, 16, 16, glyphData.textureX, glyphData.textureY, glyphData.textureLocation);
        } else {
            glyphTexture = new GuiTexture(-1, -1, 16, 16, glyphData.textureX, glyphData.textureY, glyphData.textureLocation);
        }
        if (border != null) {
            border.setOpacity(0.3f);
            border.setColor(schematic.getRarity().tint);
            this.glyph.addChild((GuiElement)border);
        }
        glyphTexture.setColor(schematic.getRarity().tint);
        this.glyph.addChild((GuiElement)glyphTexture);
        if (schematic.getType() == SchematicType.improvement) {
            this.glyph.addChild((GuiElement)new GuiTexture(7, 7, 7, 7, 68, 16, GuiTextures.workbench).setColor(0x7F7F7F));
        }
        for (i = 0; i < schematic.getNumMaterialSlots(); ++i) {
            this.slotNames[i].setString(schematic.getSlotName(itemStack, i));
            this.slotNames[i].setVisible(true);
            this.slotPlaceholders[i].setVisible(i < materials.length && materials[i].func_190926_b());
            this.slotPlaceholders[i].setItems(schematic.getSlotPlaceholders(itemStack, i));
            this.slotBorders[i].setVisible(true);
            if (schematic.acceptsMaterial(itemStack, slot, i, materials[i])) {
                int requiredCount = schematic.getRequiredQuantity(itemStack, i, materials[i]);
                if (!materials[i].func_190926_b() && requiredCount > 1) {
                    this.slotQuantities[i].setString("/" + requiredCount);
                    this.slotQuantities[i].setColor(materials[i].func_190916_E() < requiredCount ? 0xFF5555 : 0xFFFFFF);
                }
                this.slotQuantities[i].setVisible(!materials[i].func_190926_b() && requiredCount > 1);
                continue;
            }
            this.slotQuantities[i].setVisible(false);
        }
        for (i = schematic.getNumMaterialSlots(); i < 2; ++i) {
            this.slotNames[i].setVisible(false);
            this.slotQuantities[i].setVisible(false);
            this.slotPlaceholders[i].setVisible(false);
            this.slotBorders[i].setVisible(false);
        }
        this.toolRequirementList.update(schematic, itemStack, slot, materials, availableTools);
        int xpCost = schematic.getExperienceCost(itemStack, materials, slot);
        this.experienceIndicator.setVisible(xpCost > 0);
        if (xpCost > 0) {
            if (!player.func_184812_l_()) {
                this.experienceIndicator.update(xpCost, xpCost <= player.field_71068_ca);
            } else {
                this.experienceIndicator.update(xpCost, true);
            }
        }
    }

    public void updateMagicCapacity(UpgradeSchematic schematic, String slot, ItemStack itemStack, ItemStack previewStack) {
        if (slot != null && (schematic != null && SchematicType.major.equals((Object)schematic.getType()) && this.magicCapacity.providesCapacity(itemStack, previewStack, slot) || this.magicCapacity.hasChanged(itemStack, previewStack, slot))) {
            this.magicCapacity.update(itemStack, previewStack, slot);
            this.magicCapacity.setVisible(true);
        } else {
            this.magicCapacity.setVisible(false);
        }
    }

    public void updateAvailableTools(Map<ToolType, Integer> availableTools) {
        this.toolRequirementList.updateAvailableTools(availableTools);
    }

    public void updateButton(UpgradeSchematic schematic, PlayerEntity player, ItemStack itemStack, ItemStack previewStack, ItemStack[] materials, String slot, Map<ToolType, Integer> availableTools) {
        this.craftButton.update(schematic, player, itemStack, previewStack, materials, slot, availableTools);
    }

    public List<String> getTooltipLines() {
        if (this.description.hasFocus()) {
            return this.descriptionTooltip;
        }
        return super.getTooltipLines();
    }
}

