/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.resources.I18n;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiString;
import se.mickelus.mgui.gui.GuiStringOutline;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.tetra.gui.GuiTextures;

public class GuiExperience
extends GuiElement {
    private static final int positiveColor = 0xC8FF8F;
    private static final int negativeColor = 9199709;
    private GuiTexture indicator = new GuiTexture(0, 0, 16, 16, 0, 0, GuiTextures.workbench);
    private GuiString levelString;
    private String unlocalizedTooltip;
    private List<String> formattedTooltip;

    public GuiExperience(int x, int y) {
        this(x, y, null);
    }

    public GuiExperience(int x, int y, String unlocalizedTooltip) {
        super(x, y, 16, 16);
        this.addChild((GuiElement)this.indicator);
        this.levelString = new GuiStringOutline(8, 2, "");
        this.addChild((GuiElement)this.levelString);
        this.unlocalizedTooltip = unlocalizedTooltip;
    }

    public void update(int level, boolean positive) {
        this.indicator.setTextureCoordinates(Math.min(level, 3) * 16 + 112, positive ? 0 : 16);
        this.levelString.setString(level + "");
        this.levelString.setColor(positive ? 0xC8FF8F : 9199709);
        if (this.unlocalizedTooltip != null) {
            this.formattedTooltip = Collections.singletonList(I18n.func_135052_a((String)this.unlocalizedTooltip, (Object[])new Object[]{level}));
        }
    }

    public List<String> getTooltipLines() {
        if (this.formattedTooltip != null && this.hasFocus()) {
            return this.formattedTooltip;
        }
        return super.getTooltipLines();
    }
}

